/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import javax.management.ObjectName;

class AlarmKey {
    public static final String BAD_SOURCE = "NonObjectNameSource";
    private String alarmId;

    public static AlarmKey createKey(String serverId, Object source, String type) {
        if (source instanceof ObjectName) {
            return new AlarmKey(serverId, source.toString(), type);
        }
        if (source instanceof String) {
            return new AlarmKey(serverId, (String)source, type);
        }
        return new AlarmKey(serverId, BAD_SOURCE, type);
    }

    public AlarmKey(String serverId, String source, String type) {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append(serverId);
        sbuf.append('+').append(source);
        sbuf.append('+').append(type);
        this.alarmId = sbuf.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlarmKey) {
            return ((AlarmKey)obj).alarmId.equals(this.alarmId);
        }
        return false;
    }

    public int hashCode() {
        return this.alarmId.hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append("AlarmKey[").append(this.alarmId).append("]");
        return sbuf.toString();
    }
}

