/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.varia;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import junit.framework.TestCase;

public class ObjectInstanceTestCase
extends TestCase {
    public ObjectInstanceTestCase(String s) {
        super(s);
    }

    public void testStringConstructor() {
        ObjectInstance instance = null;
        try {
            instance = new ObjectInstance("test:type=test", "ClassName");
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        ObjectInstanceTestCase.assertEquals((String)"test:type=test", (String)instance.getObjectName().toString());
        ObjectInstanceTestCase.assertEquals((String)"ClassName", (String)instance.getClassName());
    }

    public void testObjectNameConstructor() {
        ObjectInstance instance = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(":type=test");
            instance = new ObjectInstance(objectName, "ClassName");
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        ObjectInstanceTestCase.assertEquals((Object)objectName, (Object)instance.getObjectName());
        ObjectInstanceTestCase.assertEquals((String)"ClassName", (String)instance.getClassName());
    }

    public void testEquals() {
        ObjectInstance instanceTest = null;
        ObjectInstance instanceSame = null;
        ObjectInstance instanceDiffName = null;
        ObjectInstance instanceDiffClass = null;
        try {
            instanceTest = new ObjectInstance("test:type=test", "ClassName");
            instanceSame = new ObjectInstance("test:type=test", "ClassName");
            instanceDiffName = new ObjectInstance("test:type=different", "ClassName");
            instanceDiffClass = new ObjectInstance("test:type=test", "Another");
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        ObjectInstanceTestCase.assertEquals((Object)instanceTest, (Object)instanceTest);
        ObjectInstanceTestCase.assertEquals((Object)instanceTest, instanceSame);
        if (instanceTest.equals(instanceDiffName)) {
            ObjectInstanceTestCase.fail((String)"ObjectInstance.equals broken for object name");
        }
        if (instanceTest.equals(instanceDiffClass)) {
            ObjectInstanceTestCase.fail((String)"ObjectInstance.equals broken for class name");
        }
    }

    public void testErrors() {
        boolean caught = false;
        try {
            new ObjectInstance("rubbish", "ClassName");
        }
        catch (MalformedObjectNameException e) {
            caught = true;
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        if (!caught) {
            ObjectInstanceTestCase.fail((String)"ObjectInstance(String, String) failed to report malformed object name");
        }
        try {
            String NULL = null;
            new ObjectInstance(NULL, "ClassName");
        }
        catch (MalformedObjectNameException e) {
            caught = true;
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        if (!caught) {
            ObjectInstanceTestCase.fail((String)"ObjectInstance(String, String) failed to report null object name");
        }
    }

    public void testSerialization() {
        ObjectInstance original = null;
        ObjectInstance result = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(":type=test");
            original = new ObjectInstance(objectName, "ClassName");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(original);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = (ObjectInstance)ois.readObject();
        }
        catch (Exception e) {
            ObjectInstanceTestCase.fail((String)e.toString());
        }
        ObjectInstanceTestCase.assertEquals(original, result);
        ObjectInstanceTestCase.assertEquals((Object)objectName, (Object)result.getObjectName());
        ObjectInstanceTestCase.assertEquals((String)"ClassName", (String)result.getClassName());
    }
}

