/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.standard;

import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import junit.framework.TestCase;
import test.compliance.standard.InfoUtil;

public class OperationInfoTEST
extends TestCase {
    private String failureHint;
    private MBeanInfo info;
    private String operationName;
    private int impact;
    private String returnType;
    private String signatureString;

    public OperationInfoTEST(String failureHint, MBeanInfo info, String operationName, int impact, String returnType, String[] signature) {
        super("testValidOperation");
        this.failureHint = failureHint;
        this.info = info;
        this.operationName = operationName;
        this.impact = impact;
        this.returnType = returnType;
        this.signatureString = InfoUtil.makeSignatureString(signature);
    }

    public void testValidOperation() {
        MBeanOperationInfo[] operations = this.info.getOperations();
        MBeanOperationInfo foundOperation = null;
        for (int i = 0; i < operations.length; ++i) {
            if (!operations[i].getName().equals(this.operationName) || !this.signatureString.equals(InfoUtil.makeSignatureString(operations[i].getSignature()))) continue;
            foundOperation = operations[i];
            break;
        }
        OperationInfoTEST.assertNotNull((String)(this.failureHint + ": " + this.info.getClassName() + "." + this.operationName + this.signatureString + " was not found"), (Object)foundOperation);
        OperationInfoTEST.assertEquals((String)(this.failureHint + ": " + this.info.getClassName() + "." + this.operationName + this.signatureString + " impact"), (int)this.impact, (int)foundOperation.getImpact());
        OperationInfoTEST.assertEquals((String)(this.failureHint + ": " + this.info.getClassName() + "." + this.operationName + this.signatureString + " returnType"), (String)this.returnType, (String)foundOperation.getReturnType());
    }
}

