/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.relation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import junit.framework.TestCase;

public class RoleListTestCase
extends TestCase {
    boolean setUpDone = false;
    Role role1;
    Role role2;

    public RoleListTestCase(String s) {
        super(s);
    }

    public void testEmptyConstructors() {
        this.setUpRoles();
        RoleList empty = new RoleList();
        RoleListTestCase.assertEquals((int)0, (int)empty.size());
        empty = new RoleList(100);
        RoleListTestCase.assertEquals((int)0, (int)empty.size());
    }

    public void testBasicConstructor() {
        this.setUpRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(this.role1);
        roles.add(this.role2);
        RoleList full = new RoleList((List<Role>)roles);
        RoleListTestCase.assertEquals((int)2, (int)full.size());
        RoleListTestCase.assertEquals((Object)this.role1, full.get(0));
        RoleListTestCase.assertEquals((Object)this.role2, full.get(1));
        Iterator iterator = full.iterator();
        RoleListTestCase.assertEquals((Object)this.role1, iterator.next());
        RoleListTestCase.assertEquals((Object)this.role2, iterator.next());
    }

    public void testBasicConstructorOrdering() {
        this.setUpRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(this.role2);
        roles.add(this.role1);
        RoleList full = new RoleList((List<Role>)roles);
        RoleListTestCase.assertEquals((int)2, (int)full.size());
        RoleListTestCase.assertEquals((Object)this.role2, full.get(0));
        RoleListTestCase.assertEquals((Object)this.role1, full.get(1));
        Iterator iterator = full.iterator();
        RoleListTestCase.assertEquals((Object)this.role2, iterator.next());
        RoleListTestCase.assertEquals((Object)this.role1, iterator.next());
    }

    public void testBasicConstructorDuplicates() {
        this.setUpRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(this.role1);
        roles.add(this.role1);
        RoleList full = new RoleList((List<Role>)roles);
        RoleListTestCase.assertEquals((int)2, (int)full.size());
        RoleListTestCase.assertEquals((Object)this.role1, full.get(0));
        RoleListTestCase.assertEquals((Object)this.role1, full.get(1));
        Iterator iterator = full.iterator();
        RoleListTestCase.assertEquals((Object)this.role1, iterator.next());
        RoleListTestCase.assertEquals((Object)this.role1, iterator.next());
    }

    public void testErrorHandling() {
        this.setUpRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(this.role1);
        roles.add(null);
        boolean caught = false;
        try {
            new RoleList((List<Role>)roles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Constructor accepts null roles");
        }
        roles = new ArrayList();
        roles.add(this.role1);
        roles.add((Role)new Object());
        caught = false;
        try {
            new RoleList((List<Role>)roles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Constructor accepts non roles");
        }
    }

    public void testSingleAppend() {
        this.setUpRoles();
        RoleList list = new RoleList();
        list.add(this.role1);
        RoleListTestCase.assertEquals((int)1, (int)list.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(0).toString());
        Iterator iterator = list.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        list.add(this.role2);
        RoleListTestCase.assertEquals((int)2, (int)list.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(0).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)list.get(1).toString());
        iterator = list.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.add(null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"addRole(null) shouldn't work");
        }
    }

    public void testSingleAdd() {
        this.setUpRoles();
        RoleList list = new RoleList();
        list.add(this.role1);
        list.add(this.role2);
        list.add(1, this.role1);
        RoleListTestCase.assertEquals((int)3, (int)list.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(0).toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(1).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)list.get(2).toString());
        Iterator iterator = list.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.add(4, this.role1);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Shouldn't be able to add a role outside of valid range");
        }
        caught = false;
        try {
            list.add(1, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Shouldn't be able to add a null at an index");
        }
    }

    public void testSingleSet() {
        this.setUpRoles();
        RoleList list = new RoleList();
        list.add(this.role1);
        list.add(this.role2);
        list.set(1, this.role1);
        RoleListTestCase.assertEquals((int)2, (int)list.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(0).toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(1).toString());
        Iterator iterator = list.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.set(4, this.role1);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Shouldn't be able to set a role outside of valid range");
        }
        caught = false;
        try {
            list.add(1, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Shouldn't be able to set a null at an index");
        }
    }

    public void testMultipleAdd() {
        this.setUpRoles();
        RoleList list = new RoleList();
        list.add(this.role1);
        list.add(this.role1);
        RoleList listToAdd = new RoleList();
        listToAdd.add(this.role2);
        listToAdd.add(this.role2);
        list.addAll(listToAdd);
        RoleListTestCase.assertEquals((int)4, (int)list.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(0).toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(1).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)list.get(2).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)list.get(3).toString());
        Iterator iterator = list.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.addAll((RoleList)null);
        }
        catch (Exception e) {
            caught = true;
        }
        if (caught) {
            RoleListTestCase.fail((String)"Should be able to addAll a null");
        }
    }

    public void testMultipleLocationAdd() {
        this.setUpRoles();
        RoleList list = new RoleList();
        list.add(this.role1);
        list.add(this.role1);
        RoleList listToAdd = new RoleList();
        listToAdd.add(this.role2);
        listToAdd.add(this.role2);
        list.addAll(1, listToAdd);
        RoleListTestCase.assertEquals((int)4, (int)list.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(0).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)list.get(1).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)list.get(2).toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)list.get(3).toString());
        Iterator iterator = list.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        boolean caught = false;
        try {
            list.addAll(6, listToAdd);
        }
        catch (IndexOutOfBoundsException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Shouldn't be able to addAll a role outside of valid range");
        }
        caught = false;
        try {
            list.addAll(1, (RoleList)null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            RoleListTestCase.fail((String)"Shouldn't be able to addAll a null at an index");
        }
    }

    public void testClone() {
        this.setUpRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(this.role1);
        roles.add(this.role2);
        RoleList full = new RoleList((List<Role>)roles);
        RoleList clone = (RoleList)full.clone();
        RoleListTestCase.assertEquals((int)2, (int)clone.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)clone.get(0).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)clone.get(1).toString());
        Iterator iterator = clone.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
    }

    public void testSerialization() {
        this.setUpRoles();
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.add(this.role1);
        roles.add(this.role2);
        RoleList full = new RoleList((List<Role>)roles);
        ArrayList copy = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(full);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            copy = (RoleList)ois.readObject();
        }
        catch (IOException ioe) {
            RoleListTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            RoleListTestCase.fail((String)cnfe.toString());
        }
        RoleListTestCase.assertEquals((int)2, (int)copy.size());
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)copy.get(0).toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)copy.get(1).toString());
        Iterator iterator = copy.iterator();
        RoleListTestCase.assertEquals((String)this.role1.toString(), (String)iterator.next().toString());
        RoleListTestCase.assertEquals((String)this.role2.toString(), (String)iterator.next().toString());
    }

    private void setUpRoles() {
        if (this.setUpDone) {
            return;
        }
        try {
            ArrayList<ObjectName> roleValue1 = new ArrayList<ObjectName>();
            ObjectName a = new ObjectName(":a=a");
            ObjectName b = new ObjectName(":b=b");
            roleValue1.add(a);
            roleValue1.add(b);
            this.role1 = new Role("RoleName1", roleValue1);
            ArrayList<ObjectName> roleValue2 = new ArrayList<ObjectName>();
            ObjectName c = new ObjectName(":c=c");
            ObjectName d = new ObjectName(":d=d");
            roleValue2.add(c);
            roleValue2.add(d);
            this.role2 = new Role("RoleName2", roleValue2);
        }
        catch (MalformedObjectNameException mfone) {
            RoleListTestCase.fail((String)mfone.toString());
        }
        this.setUpDone = true;
    }
}

