/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.relation;

import java.io.Serializable;
import java.util.ArrayList;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationService;
import junit.framework.TestCase;

public class RelationNotificationTestCase
extends TestCase
implements Serializable {
    static final long serialVersionUID = 516562336428465857L;
    static String[] types = new String[]{"jmx.relation.creation.basic", "jmx.relation.creation.mbean", "jmx.relation.update.basic", "jmx.relation.update.mbean", "jmx.relation.removal.basic", "jmx.relation.removal.mbean"};

    public RelationNotificationTestCase(String s) {
        super(s);
    }

    public void testDifferent() {
        for (int i = 0; i < types.length - 1; ++i) {
            for (int j = i + 1; j < types.length; ++j) {
                if (!types[i].equals(types[j])) continue;
                RelationNotificationTestCase.fail((String)"Relation Notifications types not unique");
            }
        }
    }

    public void testBasicCreation() {
        Notification rn = null;
        try {
            rn = new RelationNotification("jmx.relation.creation.basic", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", null, null);
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        RelationNotificationTestCase.assertEquals((String)"jmx.relation.creation.basic", (String)rn.getType());
        RelationNotificationTestCase.assertEquals((long)21L, (long)rn.getSequenceNumber());
        RelationNotificationTestCase.assertEquals((long)23L, (long)rn.getTimeStamp());
        RelationNotificationTestCase.assertEquals((String)"message", (String)rn.getMessage());
        RelationNotificationTestCase.assertEquals((String)"relationId", (String)((RelationNotification)rn).getRelationId());
        RelationNotificationTestCase.assertEquals((String)"relationTypeName", (String)((RelationNotification)rn).getRelationTypeName());
        RelationNotificationTestCase.assertEquals(null, (Object)((RelationNotification)rn).getObjectName());
        RelationNotificationTestCase.assertEquals((int)0, (int)((RelationNotification)rn).getMBeansToUnregister().size());
    }

    public void testBasicRemoval() {
        Notification rn = null;
        Object objectName = null;
        ArrayList<ObjectName> unregs = new ArrayList<ObjectName>();
        try {
            rn = new RelationNotification("jmx.relation.removal.basic", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", null, unregs);
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        RelationNotificationTestCase.assertEquals((String)"jmx.relation.removal.basic", (String)rn.getType());
        RelationNotificationTestCase.assertEquals((long)21L, (long)rn.getSequenceNumber());
        RelationNotificationTestCase.assertEquals((long)23L, (long)rn.getTimeStamp());
        RelationNotificationTestCase.assertEquals((String)"message", (String)rn.getMessage());
        RelationNotificationTestCase.assertEquals((String)"relationId", (String)((RelationNotification)rn).getRelationId());
        RelationNotificationTestCase.assertEquals((String)"relationTypeName", (String)((RelationNotification)rn).getRelationTypeName());
        RelationNotificationTestCase.assertEquals(null, (Object)((RelationNotification)rn).getObjectName());
        RelationNotificationTestCase.assertEquals(unregs, ((RelationNotification)rn).getMBeansToUnregister());
    }

    public void testMBeanCreation() {
        Notification rn = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(":a=a");
            rn = new RelationNotification("jmx.relation.creation.mbean", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, null);
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        RelationNotificationTestCase.assertEquals((String)"jmx.relation.creation.mbean", (String)rn.getType());
        RelationNotificationTestCase.assertEquals((long)21L, (long)rn.getSequenceNumber());
        RelationNotificationTestCase.assertEquals((long)23L, (long)rn.getTimeStamp());
        RelationNotificationTestCase.assertEquals((String)"message", (String)rn.getMessage());
        RelationNotificationTestCase.assertEquals((String)"relationId", (String)((RelationNotification)rn).getRelationId());
        RelationNotificationTestCase.assertEquals((String)"relationTypeName", (String)((RelationNotification)rn).getRelationTypeName());
        RelationNotificationTestCase.assertEquals((Object)objectName, (Object)((RelationNotification)rn).getObjectName());
        RelationNotificationTestCase.assertEquals((int)0, (int)((RelationNotification)rn).getMBeansToUnregister().size());
    }

    public void testMBeanRemoval() {
        Notification rn = null;
        ObjectName objectName = null;
        ArrayList<ObjectName> unregs = new ArrayList<ObjectName>();
        try {
            objectName = new ObjectName(":a=a");
            rn = new RelationNotification("jmx.relation.removal.mbean", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, unregs);
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        RelationNotificationTestCase.assertEquals((String)"jmx.relation.removal.mbean", (String)rn.getType());
        RelationNotificationTestCase.assertEquals((long)21L, (long)rn.getSequenceNumber());
        RelationNotificationTestCase.assertEquals((long)23L, (long)rn.getTimeStamp());
        RelationNotificationTestCase.assertEquals((String)"message", (String)rn.getMessage());
        RelationNotificationTestCase.assertEquals((String)"relationId", (String)((RelationNotification)rn).getRelationId());
        RelationNotificationTestCase.assertEquals((String)"relationTypeName", (String)((RelationNotification)rn).getRelationTypeName());
        RelationNotificationTestCase.assertEquals((Object)objectName, (Object)((RelationNotification)rn).getObjectName());
        RelationNotificationTestCase.assertEquals(unregs, ((RelationNotification)rn).getMBeansToUnregister());
    }

    public void testBasicUpdate() {
        Notification rn = null;
        ArrayList<ObjectName> newRoles = new ArrayList<ObjectName>();
        ArrayList<ObjectName> oldRoles = new ArrayList<ObjectName>();
        try {
            rn = new RelationNotification("jmx.relation.update.basic", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", null, "roleName", newRoles, oldRoles);
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        RelationNotificationTestCase.assertEquals((String)"jmx.relation.update.basic", (String)rn.getType());
        RelationNotificationTestCase.assertEquals((long)21L, (long)rn.getSequenceNumber());
        RelationNotificationTestCase.assertEquals((long)23L, (long)rn.getTimeStamp());
        RelationNotificationTestCase.assertEquals((String)"message", (String)rn.getMessage());
        RelationNotificationTestCase.assertEquals((String)"relationId", (String)((RelationNotification)rn).getRelationId());
        RelationNotificationTestCase.assertEquals((String)"relationTypeName", (String)((RelationNotification)rn).getRelationTypeName());
        RelationNotificationTestCase.assertEquals(null, (Object)((RelationNotification)rn).getObjectName());
        RelationNotificationTestCase.assertEquals((String)"roleName", (String)((RelationNotification)rn).getRoleName());
        RelationNotificationTestCase.assertEquals((int)0, (int)((RelationNotification)rn).getNewRoleValue().size());
        RelationNotificationTestCase.assertEquals((int)0, (int)((RelationNotification)rn).getOldRoleValue().size());
    }

    public void testMBeanUpdate() {
        Notification rn = null;
        ObjectName objectName = null;
        ArrayList<ObjectName> newRoles = new ArrayList<ObjectName>();
        ArrayList<ObjectName> oldRoles = new ArrayList<ObjectName>();
        try {
            objectName = new ObjectName(":a=a");
            rn = new RelationNotification("jmx.relation.update.mbean", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleName", newRoles, oldRoles);
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        RelationNotificationTestCase.assertEquals((String)"jmx.relation.update.mbean", (String)rn.getType());
        RelationNotificationTestCase.assertEquals((long)21L, (long)rn.getSequenceNumber());
        RelationNotificationTestCase.assertEquals((long)23L, (long)rn.getTimeStamp());
        RelationNotificationTestCase.assertEquals((String)"message", (String)rn.getMessage());
        RelationNotificationTestCase.assertEquals((String)"relationId", (String)((RelationNotification)rn).getRelationId());
        RelationNotificationTestCase.assertEquals((String)"relationTypeName", (String)((RelationNotification)rn).getRelationTypeName());
        RelationNotificationTestCase.assertEquals((Object)objectName, (Object)((RelationNotification)rn).getObjectName());
        RelationNotificationTestCase.assertEquals((String)"roleName", (String)((RelationNotification)rn).getRoleName());
        RelationNotificationTestCase.assertEquals((int)0, (int)((RelationNotification)rn).getNewRoleValue().size());
        RelationNotificationTestCase.assertEquals((int)0, (int)((RelationNotification)rn).getOldRoleValue().size());
    }

    public void testCreationRemovalErrors() {
        RelationNotification rn = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(":a=a");
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        ArrayList<ObjectName> unregs = new ArrayList<ObjectName>();
        boolean caught = false;
        try {
            rn = new RelationNotification("blah", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, unregs);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts an invalid type");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.basic", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, unregs);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts basic update");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.mbean", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, unregs);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts mean update");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.creation.basic", null, 21L, 23L, "message", "relationId", "relationTypeName", objectName, unregs);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts null source");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.creation.basic", new RelationService(true), 21L, 23L, "message", null, "relationTypeName", objectName, unregs);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts null relation id");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.creation.basic", new RelationService(true), 21L, 23L, "message", "relation id", null, objectName, unregs);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts null relation type name");
        }
    }

    public void testCreationRemovalErrors2() {
        RelationNotification rn = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(":a=a");
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        ArrayList<ObjectName> unregs = new ArrayList<ObjectName>();
        boolean caught = false;
        try {
            rn = new RelationNotification(null, new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, unregs);
        }
        catch (NullPointerException e) {
            RelationNotificationTestCase.fail((String)"FAILS IN RI: Throws the wrong exception type");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts an a null type");
        }
    }

    public void testUpdateErrors() {
        RelationNotification rn = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(":a=a");
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        ArrayList<ObjectName> newRoles = new ArrayList<ObjectName>();
        ArrayList<ObjectName> oldRoles = new ArrayList<ObjectName>();
        boolean caught = false;
        try {
            rn = new RelationNotification("blah", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts an invalid type");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.creation.basic", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts basic create");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.creation.mbean", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts mean create");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.removal.basic", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts basic remove");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.removal.mbean", new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts mean remove");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.basic", null, 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts null source");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.basic", new RelationService(true), 21L, 23L, "message", null, "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts null relation id");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.basic", new RelationService(true), 21L, 23L, "message", "relation id", null, objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts null relation type name");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.basic", new RelationService(true), 21L, 23L, "message", "relation id", null, objectName, null, newRoles, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts null role info");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.basic", new RelationService(true), 21L, 23L, "message", "relation id", "relationTypeName", objectName, "roleInfo", null, oldRoles);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Creation/Removal accepts null new role value");
        }
        caught = false;
        try {
            rn = new RelationNotification("jmx.relation.update.basic", new RelationService(true), 21L, 23L, "message", "relation id", "relationTypeName", objectName, "roleInfo", newRoles, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts null old role value");
        }
    }

    public void testUpdateErrors2() {
        RelationNotification rn = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(":a=a");
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        ArrayList<ObjectName> newRoles = new ArrayList<ObjectName>();
        ArrayList<ObjectName> oldRoles = new ArrayList<ObjectName>();
        boolean caught = false;
        try {
            rn = new RelationNotification(null, new RelationService(true), 21L, 23L, "message", "relationId", "relationTypeName", objectName, "roleInfo", newRoles, oldRoles);
        }
        catch (NullPointerException e) {
            RelationNotificationTestCase.fail((String)"FAILS IN RI: Throws the wrong exception type");
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        catch (Exception e) {
            RelationNotificationTestCase.fail((String)e.toString());
        }
        if (!caught) {
            RelationNotificationTestCase.fail((String)"Update accepts an a null type");
        }
    }
}

