/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.relation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.MBeanServerNotification;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import junit.framework.TestCase;

public class MBeanServerNotificationFilterTestCase
extends TestCase {
    MBeanServerNotificationFilter mbsnf;
    ObjectName on1;
    ObjectName on2;
    MBeanServerNotification n1;
    MBeanServerNotification n2;

    public MBeanServerNotificationFilterTestCase(String s) {
        super(s);
    }

    public void testDefault() {
        this.setUpTest();
        this.mbsnf.enableObjectName(this.on1);
        this.mbsnf.enableObjectName(this.on2);
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)true, (boolean)this.mbsnf.isNotificationEnabled(this.n1));
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)true, (boolean)this.mbsnf.isNotificationEnabled(this.n2));
    }

    public void testEnableAll() {
        this.setUpTest();
        this.mbsnf.enableAllObjectNames();
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)true, (boolean)this.mbsnf.isNotificationEnabled(this.n1));
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)true, (boolean)this.mbsnf.isNotificationEnabled(this.n2));
    }

    public void testEnableOne() {
        this.setUpTest();
        this.mbsnf.enableObjectName(this.on2);
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)false, (boolean)this.mbsnf.isNotificationEnabled(this.n1));
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)true, (boolean)this.mbsnf.isNotificationEnabled(this.n2));
    }

    public void testDisableAll() {
        this.setUpTest();
        this.mbsnf.enableObjectName(this.on1);
        this.mbsnf.disableAllObjectNames();
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)false, (boolean)this.mbsnf.isNotificationEnabled(this.n1));
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)false, (boolean)this.mbsnf.isNotificationEnabled(this.n2));
    }

    public void testDisableOne() {
        this.setUpTest();
        this.mbsnf.enableAllObjectNames();
        this.mbsnf.disableObjectName(this.on2);
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)true, (boolean)this.mbsnf.isNotificationEnabled(this.n1));
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)false, (boolean)this.mbsnf.isNotificationEnabled(this.n2));
    }

    public void testGetters() {
        this.setUpTest();
        try {
            MBeanServerNotificationFilterTestCase.assertEquals((int)0, (int)this.mbsnf.getEnabledObjectNames().size());
            MBeanServerNotificationFilterTestCase.assertEquals(null, this.mbsnf.getDisabledObjectNames());
            this.mbsnf.enableAllObjectNames();
            MBeanServerNotificationFilterTestCase.assertEquals(null, this.mbsnf.getEnabledObjectNames());
            MBeanServerNotificationFilterTestCase.assertEquals((int)0, (int)this.mbsnf.getDisabledObjectNames().size());
            this.mbsnf.disableObjectName(this.on1);
            MBeanServerNotificationFilterTestCase.assertEquals(null, this.mbsnf.getEnabledObjectNames());
            MBeanServerNotificationFilterTestCase.assertEquals((int)1, (int)this.mbsnf.getDisabledObjectNames().size());
            MBeanServerNotificationFilterTestCase.assertEquals((Object)this.on1, (Object)this.mbsnf.getDisabledObjectNames().elementAt(0));
            this.mbsnf.disableAllObjectNames();
            MBeanServerNotificationFilterTestCase.assertEquals((int)0, (int)this.mbsnf.getEnabledObjectNames().size());
            MBeanServerNotificationFilterTestCase.assertEquals(null, this.mbsnf.getDisabledObjectNames());
            this.mbsnf.enableObjectName(this.on1);
            MBeanServerNotificationFilterTestCase.assertEquals((int)1, (int)this.mbsnf.getEnabledObjectNames().size());
            MBeanServerNotificationFilterTestCase.assertEquals(null, this.mbsnf.getDisabledObjectNames());
            MBeanServerNotificationFilterTestCase.assertEquals((Object)this.on1, (Object)this.mbsnf.getEnabledObjectNames().elementAt(0));
        }
        catch (NullPointerException e) {
            MBeanServerNotificationFilterTestCase.fail((String)("FAILS IN RI: " + e.toString()));
        }
    }

    public void testSerialization() {
        this.setUpTest();
        this.mbsnf.enableObjectName(this.on2);
        MBeanServerNotificationFilter mbsnf2 = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.mbsnf);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            mbsnf2 = (MBeanServerNotificationFilter)ois.readObject();
        }
        catch (IOException ioe) {
            MBeanServerNotificationFilterTestCase.fail((String)ioe.toString());
        }
        catch (ClassNotFoundException cnfe) {
            MBeanServerNotificationFilterTestCase.fail((String)cnfe.toString());
        }
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)false, (boolean)this.mbsnf.isNotificationEnabled(this.n1));
        MBeanServerNotificationFilterTestCase.assertEquals((boolean)true, (boolean)this.mbsnf.isNotificationEnabled(this.n2));
    }

    private void setUpTest() {
        this.mbsnf = new MBeanServerNotificationFilter();
        this.mbsnf.enableType("JMX.mbean.registered");
        try {
            this.on1 = new ObjectName(":a=a");
            this.on2 = new ObjectName(":b=b");
        }
        catch (Exception e) {
            MBeanServerNotificationFilterTestCase.fail((String)e.toString());
        }
        this.n1 = new MBeanServerNotification("JMX.mbean.registered", new Object(), 1L, this.on1);
        this.n2 = new MBeanServerNotification("JMX.mbean.registered", new Object(), 2L, this.on2);
    }
}

