/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import junit.framework.TestCase;
import test.compliance.query.support.Trivial;

public class QueryMBeansObjectNameOnlyTestCase
extends TestCase {
    int implSize;

    public QueryMBeansObjectNameOnlyTestCase(String s) {
        super(s);
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        this.implSize = server.getMBeanCount();
        MBeanServerFactory.releaseMBeanServer(server);
    }

    public void testExactFound() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1")));
            server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2"));
            server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1"));
            resultMBeans = server.queryMBeans(new ObjectName("Domain1:type=instance1"), null);
            resultNames = server.queryNames(new ObjectName("Domain1:type=instance1"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testExactNotFound() {
        MBeanServer server = null;
        HashSet instances = new HashSet();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2"));
            server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1"));
            resultMBeans = server.queryMBeans(new ObjectName("Domain2:type=instance2"), null);
            resultNames = server.queryNames(new ObjectName("Domain2:type=instance2"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetAllMBeans() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1")));
            resultMBeans = server.queryMBeans(new ObjectName("*:*"), null);
            resultNames = server.queryNames(new ObjectName("*:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, this.implSize);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetAllMBeans2() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1")));
            resultMBeans = server.queryMBeans(new ObjectName(""), null);
            resultNames = server.queryNames(new ObjectName(""), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, this.implSize);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetAllMBeans3() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1")));
            resultMBeans = server.queryMBeans(null, null);
            resultNames = server.queryNames(null, null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, this.implSize);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetOneDomain() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2")));
            server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1"));
            resultMBeans = server.queryMBeans(new ObjectName("Domain1:*"), null);
            resultNames = server.queryNames(new ObjectName("Domain1:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetDefaultDomain() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("Domain1");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2")));
            server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1"));
            resultMBeans = server.queryMBeans(new ObjectName(":*"), null);
            resultNames = server.queryNames(new ObjectName(":*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testGetOneProperty() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance1")));
            server.registerMBean(new Trivial(), new ObjectName("Domain1:type=instance2"));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain2:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Domain3:type=instance1")));
            resultMBeans = server.queryMBeans(new ObjectName("*:type=instance1"), null);
            resultNames = server.queryNames(new ObjectName("*:type=instance1"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSpecAll() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Printer,type=laser")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=laser,date=1993")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Socrates:description=Printer,type=laser,date=1993")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=ink")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Disk,capacity=2")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Disk,capacity=1")));
            resultMBeans = server.queryMBeans(new ObjectName("*:*"), null);
            resultNames = server.queryNames(new ObjectName("*:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, this.implSize);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSpecDefault() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Printer,type=laser"));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=laser,date=1993")));
            server.registerMBean(new Trivial(), new ObjectName("Socrates:description=Printer,type=laser,date=1993"));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=ink")));
            server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Disk,capacity=2"));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Disk,capacity=1")));
            resultMBeans = server.queryMBeans(new ObjectName(":*"), null);
            resultNames = server.queryNames(new ObjectName(":*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSpecMyDomain() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Printer,type=laser")));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=laser,date=1993"));
            server.registerMBean(new Trivial(), new ObjectName("Socrates:description=Printer,type=laser,date=1993"));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=ink"));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Disk,capacity=2")));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Disk,capacity=1"));
            resultMBeans = server.queryMBeans(new ObjectName("MyDomain:*"), null);
            resultNames = server.queryNames(new ObjectName("MyDomain:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSpecAnyAnyDomain() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Printer,type=laser")));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=laser,date=1993"));
            server.registerMBean(new Trivial(), new ObjectName("Socrates:description=Printer,type=laser,date=1993"));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=ink"));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Disk,capacity=2")));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Disk,capacity=1"));
            resultMBeans = server.queryMBeans(new ObjectName("??Domain:*"), null);
            resultNames = server.queryNames(new ObjectName("??Domain:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testAsteriskDomAsterisk() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Printer,type=laser")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=laser,date=1993")));
            server.registerMBean(new Trivial(), new ObjectName("Socrates:description=Printer,type=laser,date=1993"));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=ink")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Disk,capacity=2")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Disk,capacity=1")));
            resultMBeans = server.queryMBeans(new ObjectName("*Dom*:*"), null);
            resultNames = server.queryNames(new ObjectName("*Dom*:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSpecLaserPrinters() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Printer,type=laser")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=laser,date=1993")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Socrates:description=Printer,type=laser,date=1993")));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=ink"));
            server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Disk,capacity=2"));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Disk,capacity=1"));
            resultMBeans = server.queryMBeans(new ObjectName("*:description=Printer,type=laser,*"), null);
            resultNames = server.queryNames(new ObjectName("*:description=Printer,type=laser,*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSpecPrinters() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer();
            instances.add(server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Printer,type=laser")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=laser,date=1993")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("Socrates:description=Printer,type=laser,date=1993")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Printer,type=ink")));
            server.registerMBean(new Trivial(), new ObjectName("MyDomain:description=Disk,capacity=2"));
            server.registerMBean(new Trivial(), new ObjectName("DefaultDomain:description=Disk,capacity=2"));
            resultMBeans = server.queryMBeans(new ObjectName("*:description=Printer,*"), null);
            resultNames = server.queryNames(new ObjectName("*:description=Printer,*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testSuffixMatchManyDomain() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DomainA123:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DomainA321:type=instance2")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DomainA2224:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DomainA3:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("DomainA:type=instance1")));
            server.registerMBean(new Trivial(), new ObjectName("Domain:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("Dom:type=instance1"));
            resultMBeans = server.queryMBeans(new ObjectName("DomainA*:*"), null);
            resultNames = server.queryNames(new ObjectName("DomainA*:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testPrefixMatchManyDomain() {
        MBeanServer server = null;
        HashSet<ObjectInstance> instances = new HashSet<ObjectInstance>();
        Set<ObjectInstance> resultMBeans = null;
        Set<ObjectName> resultNames = null;
        try {
            server = MBeanServerFactory.createMBeanServer("QueryMBeans");
            instances.add(server.registerMBean(new Trivial(), new ObjectName("123ADomain:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("321ADomain:type=instance2")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("2224ADomain:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("3ADomain:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("3ADomai123ADomain:type=instance1")));
            instances.add(server.registerMBean(new Trivial(), new ObjectName("ADomain:type=instance1")));
            server.registerMBean(new Trivial(), new ObjectName("Domain:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("ADomai:type=instance1"));
            server.registerMBean(new Trivial(), new ObjectName("main:type=instance1"));
            resultMBeans = server.queryMBeans(new ObjectName("*ADomain:*"), null);
            resultNames = server.queryNames(new ObjectName("*ADomain:*"), null);
        }
        catch (Exception e) {
            QueryMBeansObjectNameOnlyTestCase.fail((String)e.toString());
        }
        this.checkit(resultMBeans, resultNames, instances, 0);
        if (server != null) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    private void checkit(Set resultMBeans, Set resultNames, HashSet expected, int others) {
        boolean found;
        Iterator iterator2;
        QueryMBeansObjectNameOnlyTestCase.assertEquals((int)(expected.size() + others), (int)resultMBeans.size());
        QueryMBeansObjectNameOnlyTestCase.assertEquals((int)(expected.size() + others), (int)resultNames.size());
        HashSet<ObjectName> expectedNames = new HashSet<ObjectName>();
        Iterator iterator = expected.iterator();
        while (iterator.hasNext()) {
            expectedNames.add(((ObjectInstance)iterator.next()).getObjectName());
        }
        iterator = resultMBeans.iterator();
        while (iterator.hasNext()) {
            ObjectInstance instance = (ObjectInstance)iterator.next();
            iterator2 = expected.iterator();
            found = false;
            while (iterator2.hasNext()) {
                if (!iterator2.next().equals(instance)) continue;
                iterator2.remove();
                found = true;
                break;
            }
            if (found || instance.getObjectName().getDomain().equals("JMImplementation")) continue;
            QueryMBeansObjectNameOnlyTestCase.fail((String)("Unexpected instance " + instance.getObjectName()));
        }
        iterator = resultNames.iterator();
        while (iterator.hasNext()) {
            ObjectName name = (ObjectName)iterator.next();
            iterator2 = expectedNames.iterator();
            found = false;
            while (iterator2.hasNext()) {
                if (!iterator2.next().equals(name)) continue;
                iterator2.remove();
                found = true;
                break;
            }
            if (found || name.getDomain().equals("JMImplementation")) continue;
            QueryMBeansObjectNameOnlyTestCase.fail((String)("Unexpected name " + name));
        }
    }
}

