/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.openmbean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Set;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import junit.framework.TestCase;

public class CompositeTypeTestCase
extends TestCase {
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeType;

    public CompositeTypeTestCase(String s) {
        super(s);
    }

    public void testCompositeTypeOpenType() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertEquals((String)(class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = CompositeTypeTestCase.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName(), (String)compositeType.getClassName());
        CompositeTypeTestCase.assertEquals((String)"description", (String)compositeType.getDescription());
        CompositeTypeTestCase.assertEquals((String)"typeName", (String)compositeType.getTypeName());
        CompositeTypeTestCase.assertTrue((String)"Composite type should not be an array", (!compositeType.isArray() ? 1 : 0) != 0);
    }

    public void testContainsKey() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertTrue((String)"Composite type should contain key name1", (compositeType.containsKey("name1") ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"Composite type should contain key name2", (compositeType.containsKey("name2") ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"Composite type should not contain key nameX", (!compositeType.containsKey("nameX") ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"Composite type should not contain key null", (!compositeType.containsKey(null) ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"Composite type should not contain key <empty>", (!compositeType.containsKey("") ? 1 : 0) != 0);
    }

    public void testGetDescriptionForItemName() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertEquals((String)"desc1", (String)compositeType.getDescription("name1"));
        CompositeTypeTestCase.assertEquals((String)"desc2", (String)compositeType.getDescription("name2"));
    }

    public void testGetTypeForItemName() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertEquals(SimpleType.STRING, compositeType.getType("name1"));
        CompositeTypeTestCase.assertEquals(SimpleType.INTEGER, compositeType.getType("name2"));
    }

    public void testKeySet() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        Set<String> keys = compositeType.keySet();
        CompositeTypeTestCase.assertTrue((String)"Should be 2 items", (keys.size() == 2 ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"Should contain name1", (boolean)keys.contains("name1"));
        CompositeTypeTestCase.assertTrue((String)"Should contain name2", (boolean)keys.contains("name2"));
    }

    public void testIsValue() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertTrue((String)"null is not a value of composite type", (!compositeType.isValue(null) ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"object is not a value of composite type", (!compositeType.isValue(new Object()) ? 1 : 0) != 0);
        Object[] itemValues = new Object[]{"string", new Integer(2)};
        CompositeDataSupport data = new CompositeDataSupport(compositeType, itemNames, itemValues);
        CompositeTypeTestCase.assertTrue((String)"data should be a value of composite type", (boolean)compositeType.isValue(data));
        CompositeType compositeType2 = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        data = new CompositeDataSupport(compositeType2, itemNames, itemValues);
        CompositeTypeTestCase.assertTrue((String)"data should be a value of composite type, even though not the object instance", (boolean)compositeType.isValue(data));
        OpenType[] itemTypes2 = new OpenType[]{SimpleType.STRING, SimpleType.LONG};
        compositeType2 = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes2);
        Object[] itemValues2 = new Object[]{"string", new Long(2L)};
        data = new CompositeDataSupport(compositeType2, itemNames, itemValues2);
        CompositeTypeTestCase.assertTrue((String)"data should not be a value of composite type, it has different types", (!compositeType.isValue(data) ? 1 : 0) != 0);
        compositeType2 = new CompositeType("typeName2", "description", itemNames, itemDescriptions, itemTypes);
        data = new CompositeDataSupport(compositeType2, itemNames, itemValues);
        CompositeTypeTestCase.assertTrue((String)"data should not be a value of composite type, it has a different type name", (!compositeType.isValue(data) ? 1 : 0) != 0);
        String[] itemNames2 = new String[]{"nameX", "name2"};
        compositeType2 = new CompositeType("typeName", "description", itemNames2, itemDescriptions, itemTypes);
        data = new CompositeDataSupport(compositeType2, itemNames2, itemValues);
        CompositeTypeTestCase.assertTrue((String)"data should not be a value of composite type, it has different item names", (!compositeType.isValue(data) ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertTrue((String)"null is not equal composite type", (!compositeType.equals(null) ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"object is not equal composite type", (!compositeType.equals(new Object()) ? 1 : 0) != 0);
        CompositeType compositeType2 = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should be equal composite type, even though not the object instance", (boolean)compositeType.equals(compositeType2));
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should be equal composite type, even though not the object instance", (boolean)compositeType2.equals(compositeType));
        OpenType[] itemTypes2 = new OpenType[]{SimpleType.STRING, SimpleType.LONG};
        compositeType2 = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes2);
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should not be equal composite type, it has different types", (!compositeType.equals(compositeType2) ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should not be equal composite type, it has different types", (!compositeType2.equals(compositeType) ? 1 : 0) != 0);
        compositeType2 = new CompositeType("typeName2", "description", itemNames, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should not be equal composite type, it has a different type name", (!compositeType.equals(compositeType2) ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should not be equal composite type, it has a different type name", (!compositeType2.equals(compositeType) ? 1 : 0) != 0);
        String[] itemNames2 = new String[]{"nameX", "name2"};
        compositeType2 = new CompositeType("typeName", "description", itemNames2, itemDescriptions, itemTypes);
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should not be equal composite type, it has different item names", (!compositeType.equals(compositeType2) ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"compositeType2 should not be equal composite type, it has different item names", (!compositeType2.equals(compositeType) ? 1 : 0) != 0);
    }

    public void testHashCode() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        int myHashCode = "typeName".hashCode() + SimpleType.STRING.hashCode() + SimpleType.INTEGER.hashCode() + "name1".hashCode() + "name2".hashCode();
        CompositeTypeTestCase.assertTrue((String)"Wrong hash code generated", (myHashCode == compositeType.hashCode() ? 1 : 0) != 0);
    }

    public void testToString() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        String toString = compositeType.toString();
        CompositeTypeTestCase.assertTrue((String)"toString() should contain the composite type class name", (toString.indexOf((class$javax$management$openmbean$CompositeType == null ? (class$javax$management$openmbean$CompositeType = CompositeTypeTestCase.class$("javax.management.openmbean.CompositeType")) : class$javax$management$openmbean$CompositeType).getName()) != -1 ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"toString() should contain the item name name1", (toString.indexOf("name1") != -1 ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)"toString() should contain the item name name2", (toString.indexOf("name2") != -1 ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)("toString() should contain " + SimpleType.STRING), (toString.indexOf(SimpleType.STRING.toString()) != -1 ? 1 : 0) != 0);
        CompositeTypeTestCase.assertTrue((String)("toString() should contain " + SimpleType.INTEGER), (toString.indexOf(SimpleType.INTEGER.toString()) != -1 ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        CompositeType compositeType = new CompositeType("typeName", "description", itemNames, itemDescriptions, itemTypes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(compositeType);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        CompositeTypeTestCase.assertEquals((Object)compositeType, (Object)result);
    }

    public void testErrors() throws Exception {
        String[] itemNames = new String[]{"name1", "name2"};
        String[] itemDescriptions = new String[]{"desc1", "desc2"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
        boolean caught = false;
        try {
            new CompositeType(null, "description", itemNames, itemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null typeName");
        }
        caught = false;
        try {
            new CompositeType("", "description", itemNames, itemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for empty typeName");
        }
        caught = false;
        try {
            new CompositeType("typeName", null, itemNames, itemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null description");
        }
        caught = false;
        try {
            new CompositeType("typeName", "", itemNames, itemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for empty description");
        }
        caught = false;
        try {
            new CompositeType("typeName", "description", null, itemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null item names");
        }
        caught = false;
        try {
            new CompositeType("typeName", "description", itemNames, null, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null item descriptions");
        }
        caught = false;
        try {
            new CompositeType("typeName", "description", itemNames, itemDescriptions, null);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null item types");
        }
        String[] nullItemNames = new String[]{"name1", null};
        caught = false;
        try {
            new CompositeType("typeName", "description", nullItemNames, itemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null element of item names");
        }
        String[] nullItemDescriptions = new String[]{"desc1", null};
        caught = false;
        try {
            new CompositeType("typeName", "description", itemNames, nullItemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null element of item descriptions");
        }
        OpenType[] nullItemTypes = new OpenType[]{SimpleType.STRING, null};
        caught = false;
        try {
            new CompositeType("typeName", "description", itemNames, itemDescriptions, nullItemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for null element of item types");
        }
        String[] wrongItemNames = new String[]{"name1"};
        caught = false;
        try {
            new CompositeType("typeName", "description", wrongItemNames, itemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for wrong number of elements for item names");
        }
        String[] wrongItemDescriptions = new String[]{"desc1"};
        caught = false;
        try {
            new CompositeType("typeName", "description", itemNames, wrongItemDescriptions, itemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for wrong number of elements for item descriptions");
        }
        OpenType[] wrongItemTypes = new OpenType[]{SimpleType.STRING};
        caught = false;
        try {
            new CompositeType("typeName", "description", itemNames, itemDescriptions, wrongItemTypes);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted IllegalArgumentException for wrong number of elements for item types");
        }
        String[] duplicateItemNames = new String[]{"desc1", "desc1"};
        caught = false;
        try {
            new CompositeType("typeName", "description", duplicateItemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted OpenDataException for duplicate item names");
        }
        duplicateItemNames = new String[]{"desc1", " desc1 "};
        caught = false;
        try {
            new CompositeType("typeName", "description", duplicateItemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            caught = true;
        }
        if (!caught) {
            CompositeTypeTestCase.fail((String)"Excepted OpenDataException for duplicate item names");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

