/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.metadata;

import java.lang.reflect.Method;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class MBeanOperationInfoTEST
extends TestCase {
    public MBeanOperationInfoTEST(String s) {
        super(s);
    }

    public void testConstructorWithMethod() {
        try {
            Class<?> c = ((Object)((Object)this)).getClass();
            Method m = c.getMethod("testConstructorWithMethod", new Class[0]);
            MBeanOperationInfo info = new MBeanOperationInfo("This is a description.", m);
            MBeanOperationInfoTEST.assertTrue((boolean)info.getDescription().equals("This is a description."));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getName().equals(m.getName()));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getReturnType().equals("void"));
            MBeanOperationInfoTEST.assertTrue((info.getSignature().length == 0 ? 1 : 0) != 0);
            MBeanOperationInfoTEST.assertTrue((info.getImpact() == 3 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanOperationInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testConstructor() {
        try {
            MBeanOperationInfo info = new MBeanOperationInfo("MyOperation", "This is a description.", new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")}, "java.util.StringBuffer", 0);
            MBeanOperationInfoTEST.assertTrue((boolean)info.getDescription().equals("This is a description."));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getName().equals("MyOperation"));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getReturnType().equals("java.util.StringBuffer"));
            MBeanOperationInfoTEST.assertTrue((info.getSignature().length == 2 ? 1 : 0) != 0);
            MBeanOperationInfoTEST.assertTrue((info.getImpact() == 0 ? 1 : 0) != 0);
            MBeanOperationInfoTEST.assertTrue((boolean)info.getSignature()[0].getName().equals("FooParam"));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getSignature()[1].getName().equals("BarParam"));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getSignature()[0].getDescription().equals("description"));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getSignature()[1].getDescription().equals("description"));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getSignature()[0].getType().equals("java.lang.Object"));
            MBeanOperationInfoTEST.assertTrue((boolean)info.getSignature()[1].getType().equals("java.lang.String"));
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanOperationInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testClone() {
        try {
            MBeanOperationInfo info = new MBeanOperationInfo("MyOperation", "This is a description.", new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")}, "java.util.StringBuffer", 2);
            MBeanOperationInfo clone = (MBeanOperationInfo)info.clone();
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getDescription().equals("This is a description."));
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getName().equals("MyOperation"));
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getReturnType().equals("java.util.StringBuffer"));
            MBeanOperationInfoTEST.assertTrue((clone.getSignature().length == 2 ? 1 : 0) != 0);
            MBeanOperationInfoTEST.assertTrue((clone.getImpact() == 2 ? 1 : 0) != 0);
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getSignature()[0].getName().equals("FooParam"));
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getSignature()[1].getName().equals("BarParam"));
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getSignature()[0].getDescription().equals("description"));
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getSignature()[1].getDescription().equals("description"));
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getSignature()[0].getType().equals("java.lang.Object"));
            MBeanOperationInfoTEST.assertTrue((boolean)clone.getSignature()[1].getType().equals("java.lang.String"));
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanOperationInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testGetNameEmpty() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("", "This is a description.", new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")}, "java.util.StringBuffer", 2);
        }
        catch (Exception e) {
            return;
        }
        MBeanOperationInfoTEST.fail((String)"empty name is not a valid java identifier");
    }

    public void testGetNameNull() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo(null, "This is a description.", new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")}, "java.util.StringBuffer", 2);
        }
        catch (Exception e) {
            return;
        }
        MBeanOperationInfoTEST.fail((String)"null name is not a valid java identifier");
    }

    public void testGetNameInvalidType() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("invalid type", "This is a description.", new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")}, "java.util.StringBuffer", 2);
        }
        catch (Exception e) {
            return;
        }
        MBeanOperationInfoTEST.fail((String)"'invalid type' is not a valid java identifier");
    }

    public void testGetDescriptionNull() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("SomeName", null, new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")}, "java.util.StringBuffer", 2);
            MBeanOperationInfoTEST.assertTrue((info1.getDescription() == null ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanOperationInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testGetImpactInvalid() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("SomeName", "some description", new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")}, "java.util.StringBuffer", -22342);
            if (info1.getImpact() != 1 && info1.getImpact() != 0 && info1.getImpact() != 2 && info1.getImpact() != 3) {
                MBeanOperationInfoTEST.fail((String)"FAILS IN RI: MBeanOperation.getImpact() is only allowed to return values that match either ACTION, ACTION_INFO, INFO or UNKNOWN constant values.");
            }
            MBeanOperationInfoTEST.fail((String)"ERROR IN TEST: invalid impact value test does not work correctly.");
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Exception e) {
            return;
        }
        MBeanOperationInfoTEST.fail((String)"Invalid impact");
    }

    public void testGetSignatureNull() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("SomeName", "some description", null, "java.util.StringBuffer", 1);
            MBeanOperationInfoTEST.assertTrue((info1.getSignature().length == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanOperationInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testGetSignatureEmpty() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("SomeName", "some description", new MBeanParameterInfo[0], "java.util.StringBuffer", 1);
            MBeanOperationInfoTEST.assertTrue((info1.getSignature().length == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace();
            MBeanOperationInfoTEST.fail((String)("Unexpected error: " + t.toString()));
        }
    }

    public void testGetReturnTypeEmpty() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("SomeName", "some description", new MBeanParameterInfo[0], "", 1);
        }
        catch (Exception e) {
            return;
        }
        MBeanOperationInfoTEST.fail((String)"An empty return type is not a valid java identifier");
    }

    public void testGetReturnTypeNull() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("SomeName", "some description", new MBeanParameterInfo[0], "", 1);
        }
        catch (Exception e) {
            return;
        }
        MBeanOperationInfoTEST.fail((String)"A null return type is not a valid java identifier");
    }

    public void testGetReturnTypeInvalid() {
        try {
            MBeanOperationInfo info1 = new MBeanOperationInfo("SomeName", "some description", new MBeanParameterInfo[0], "invalid type", 1);
        }
        catch (Exception e) {
            return;
        }
        MBeanOperationInfoTEST.fail((String)"'invalid type' return type is not a valid java identifier");
    }
}

