/*
 * Decompiled with CFR 0.152.
 */
package test.compliance.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanParameterInfo;
import junit.framework.TestCase;

public class MBeanConstructorInfoTEST
extends TestCase {
    MBeanParameterInfo[] params1 = new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Object", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")};
    MBeanParameterInfo[] params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("FooParam", "java.lang.Character", "description"), new MBeanParameterInfo("BarParam", "java.lang.String", "description")};

    public MBeanConstructorInfoTEST(String s) {
        super(s);
    }

    public void testMBeanConstructorInfo() throws Exception {
        MBeanConstructorInfo info = new MBeanConstructorInfo("name", "description", this.params1);
        MBeanConstructorInfoTEST.assertEquals((String)"name", (String)info.getName());
        MBeanConstructorInfoTEST.assertEquals((String)"description", (String)info.getDescription());
        MBeanConstructorInfoTEST.assertEquals(Arrays.asList(this.params1), Arrays.asList(info.getSignature()));
    }

    public void testHashCode() throws Exception {
        MBeanConstructorInfo info1 = new MBeanConstructorInfo("name", "description", this.params1);
        MBeanConstructorInfo info2 = new MBeanConstructorInfo("name", "description", this.params1);
        MBeanConstructorInfoTEST.assertTrue((String)"Different instances with the same hashcode are equal", (info1.hashCode() == info2.hashCode() ? 1 : 0) != 0);
    }

    public void testEquals() throws Exception {
        MBeanConstructorInfo info = new MBeanConstructorInfo("name", "description", this.params1);
        MBeanConstructorInfoTEST.assertTrue((String)"Null should not be equal", (!info.equals(null) ? 1 : 0) != 0);
        MBeanConstructorInfoTEST.assertTrue((String)"Only MBeanConstructorInfo should be equal", (!info.equals(new Object()) ? 1 : 0) != 0);
        MBeanConstructorInfo info2 = new MBeanConstructorInfo("name", "description", this.params1);
        MBeanConstructorInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info.equals(info2));
        MBeanConstructorInfoTEST.assertTrue((String)"Different instances of the same data are equal", (boolean)info2.equals(info));
        info2 = new MBeanConstructorInfo("name", "description2", this.params1);
        MBeanConstructorInfoTEST.assertTrue((String)"Different instances with different descriptions are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanConstructorInfoTEST.assertTrue((String)"Different instances with different descritpions are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanConstructorInfo("name2", "description", this.params1);
        MBeanConstructorInfoTEST.assertTrue((String)"Instances with different names are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanConstructorInfoTEST.assertTrue((String)"Instances with different names are not equal", (!info2.equals(info) ? 1 : 0) != 0);
        info2 = new MBeanConstructorInfo("name", "description", this.params2);
        MBeanConstructorInfoTEST.assertTrue((String)"Instances with different types are not equal", (!info.equals(info2) ? 1 : 0) != 0);
        MBeanConstructorInfoTEST.assertTrue((String)"Instances with different types are not equal", (!info2.equals(info) ? 1 : 0) != 0);
    }

    public void testSerialization() throws Exception {
        MBeanConstructorInfo info = new MBeanConstructorInfo("name", "description", this.params1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(info);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object result = ois.readObject();
        MBeanConstructorInfoTEST.assertEquals((Object)info, (Object)result);
    }

    public void testErrors() throws Exception {
        MBeanConstructorInfo info;
        boolean caught = false;
        try {
            info = new MBeanConstructorInfo(null, "description", this.params1);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanConstructorInfoTEST.fail((String)"Expected IllegalArgumentException for null name");
        }
        caught = false;
        try {
            info = new MBeanConstructorInfo("", "description", this.params1);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanConstructorInfoTEST.fail((String)"Expected IllegalArgumentException for an empty name");
        }
        caught = false;
        try {
            info = new MBeanConstructorInfo("invalid name", "description", this.params1);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        if (!caught) {
            MBeanConstructorInfoTEST.fail((String)"Expected IllegalArgumentException for an 'invalid name'");
        }
    }
}

