/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi.marshal.strategy;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.iiop.rmi.ExceptionAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.marshal.CDRStream;
import org.jboss.iiop.rmi.marshal.CDRStreamReader;
import org.jboss.iiop.rmi.marshal.CDRStreamWriter;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class SkeletonStrategy {
    private CDRStreamReader[] paramReaders;
    private Method m;
    private ExceptionWriter[] excepWriters;
    private CDRStreamWriter retvalWriter;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$UserException;
    static /* synthetic */ Class class$org$omg$CORBA$portable$OutputStream;

    public SkeletonStrategy(Method m) {
        this.m = m;
        Class<?>[] paramTypes = m.getParameterTypes();
        int len = paramTypes.length;
        this.paramReaders = new CDRStreamReader[len];
        for (int i = 0; i < len; ++i) {
            this.paramReaders[i] = CDRStream.readerFor(paramTypes[i]);
        }
        Class<?>[] excepTypes = m.getExceptionTypes();
        len = excepTypes.length;
        int n = 0;
        for (int i = 0; i < len; ++i) {
            if ((class$java$rmi$RemoteException == null ? SkeletonStrategy.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(excepTypes[i])) continue;
            ++n;
        }
        this.excepWriters = new ExceptionWriter[n];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if ((class$java$rmi$RemoteException == null ? SkeletonStrategy.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(excepTypes[i])) continue;
            this.excepWriters[j++] = new ExceptionWriter(excepTypes[i]);
        }
        ExceptionWriter.arraysort(this.excepWriters);
        this.retvalWriter = CDRStream.writerFor(m.getReturnType());
    }

    public Object[] readParams(InputStream in) {
        int len = this.paramReaders.length;
        Object[] params = new Object[len];
        for (int i = 0; i < len; ++i) {
            params[i] = this.paramReaders[i].read(in);
        }
        return params;
    }

    public Method getMethod() {
        return this.m;
    }

    public boolean isNonVoid() {
        return this.retvalWriter != null;
    }

    public void writeRetval(OutputStream out, Object retVal) {
        this.retvalWriter.write(out, retVal);
    }

    public void writeException(OutputStream out, Exception e) {
        int len = this.excepWriters.length;
        for (int i = 0; i < len; ++i) {
            if (!this.excepWriters[i].getExceptionClass().isInstance(e)) continue;
            this.excepWriters[i].write(out, e);
            return;
        }
        throw new UnknownException((Throwable)e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ExceptionWriter
    implements CDRStreamWriter {
        private Class clz;
        private Method writeMethod = null;
        private String reposId;

        ExceptionWriter(Class clz) {
            this.clz = clz;
            if ((class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = SkeletonStrategy.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(clz) && (class$org$omg$CORBA$UserException == null ? (class$org$omg$CORBA$UserException = SkeletonStrategy.class$("org.omg.CORBA.UserException")) : class$org$omg$CORBA$UserException).isAssignableFrom(clz)) {
                String helperClassName = clz.getName() + "Helper";
                try {
                    Class<?> helperClass = clz.getClassLoader().loadClass(helperClassName);
                    Class[] paramTypes = new Class[]{class$org$omg$CORBA$portable$OutputStream == null ? (class$org$omg$CORBA$portable$OutputStream = SkeletonStrategy.class$("org.omg.CORBA.portable.OutputStream")) : class$org$omg$CORBA$portable$OutputStream, clz};
                    this.writeMethod = helperClass.getMethod("write", paramTypes);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + helperClassName + ": " + e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("No write method in helper class " + helperClassName + ": " + e);
                }
            }
            try {
                this.reposId = ExceptionAnalysis.getExceptionAnalysis(clz).getExceptionRepositoryId();
            }
            catch (RMIIIOPViolationException e) {
                throw new RuntimeException("Cannot obtain exception repository id for " + clz.getName() + ":\n" + e);
            }
        }

        Class getExceptionClass() {
            return this.clz;
        }

        public void write(OutputStream out, Object excep) {
            if (this.writeMethod != null) {
                try {
                    this.writeMethod.invoke(null, out, excep);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Internal error: " + e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Exception marshaling IDLEntity: " + e.getTargetException());
                }
            } else {
                out.write_string(this.reposId);
                out.write_value((Serializable)((Exception)excep), this.clz);
            }
        }

        static void arraysort(ExceptionWriter[] a) {
            int len = a.length;
            for (int i = 0; i < len - 1; ++i) {
                for (int j = i + 1; j < len; ++j) {
                    if (!a[i].clz.isAssignableFrom(a[j].clz)) continue;
                    ExceptionWriter tmp = a[i];
                    a[i] = a[j];
                    a[j] = tmp;
                }
            }
        }
    }
}

