/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.security.SimplePrincipal;

public class TestLoginModule
implements LoginModule {
    Subject subject;
    String principal;
    String name;
    boolean succeed;
    boolean throwEx;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.subject = subject;
        this.principal = (String)options.get("principal");
        if (this.principal == null) {
            this.principal = "guest";
        }
        this.name = (String)options.get("name");
        String opt = (String)options.get("succeed");
        this.succeed = Boolean.valueOf(opt);
        opt = (String)options.get("throwEx");
        this.throwEx = Boolean.valueOf(opt);
        System.out.println("initialize, name=" + this.name);
        opt = (String)options.get("initEx");
        if (Boolean.valueOf(opt) == Boolean.TRUE) {
            throw new IllegalArgumentException("Failed during init, name=" + this.name);
        }
    }

    public boolean login() throws LoginException {
        System.out.println("login, name=" + this.name + ", succeed=" + this.succeed);
        if (this.throwEx) {
            throw new LoginException("Failed during login, name=" + this.name);
        }
        return this.succeed;
    }

    public boolean commit() throws LoginException {
        System.out.println("commit, name=" + this.name);
        this.subject.getPrincipals().add((Principal)new SimplePrincipal(this.principal));
        this.subject.getPublicCredentials().add("A public credential");
        this.subject.getPrivateCredentials().add("A private credential");
        return true;
    }

    public boolean abort() throws LoginException {
        System.out.println("abort, name=" + this.name);
        return true;
    }

    public boolean logout() throws LoginException {
        System.out.println("logout, name=" + this.name);
        this.subject.getPrincipals().remove(new SimplePrincipal(this.principal));
        return this.succeed;
    }
}

