/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datalist;

import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class HtmlDataList
extends UIData {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataList";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.List";
    private String _layout = null;
    private String _rowIndexVar = null;
    private String _rowCountVar = null;

    public void processDecodes(FacesContext context) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) continue;
            Iterator it = this.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!child.isRendered()) continue;
                child.processDecodes(context);
            }
        }
        this.setRowIndex(-1);
    }

    public void setRowIndex(int rowIndex) {
        super.setRowIndex(rowIndex);
        String rowIndexVar = this.getRowIndexVar();
        String rowCountVar = this.getRowCountVar();
        if (rowIndexVar != null || rowCountVar != null) {
            Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            if (rowIndex >= 0) {
                if (rowIndexVar != null) {
                    requestMap.put(this.getRowIndexVar(), new Integer(rowIndex));
                }
                if (rowCountVar != null) {
                    requestMap.put(this.getRowCountVar(), new Integer(this.getRowCount()));
                }
            } else {
                if (rowIndexVar != null) {
                    requestMap.remove(this.getRowIndexVar());
                }
                if (rowCountVar != null) {
                    requestMap.remove(this.getRowCountVar());
                }
            }
        }
    }

    public HtmlDataList() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public void setLayout(String layout) {
        this._layout = layout;
    }

    public String getLayout() {
        if (this._layout != null) {
            return this._layout;
        }
        ValueBinding vb = this.getValueBinding("layout");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowIndexVar(String rowIndexVar) {
        this._rowIndexVar = rowIndexVar;
    }

    public String getRowIndexVar() {
        if (this._rowIndexVar != null) {
            return this._rowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("rowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowCountVar(String rowCountVar) {
        this._rowCountVar = rowCountVar;
    }

    public String getRowCountVar() {
        if (this._rowCountVar != null) {
            return this._rowCountVar;
        }
        ValueBinding vb = this.getValueBinding("rowCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._layout, this._rowIndexVar, this._rowCountVar};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._layout = (String)values[1];
        this._rowIndexVar = (String)values[2];
        this._rowCountVar = (String)values[3];
    }
}

