/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.generic;

import java.util.List;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerHA;
import org.jboss.invocation.InvokerProxyHA;
import org.jboss.invocation.jrmp.server.JRMPProxyFactory;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.proxy.generic.ProxyFactoryHAMBean;
import org.jboss.system.Registry;

public class ProxyFactoryHA
extends JRMPProxyFactory
implements ProxyFactoryHAMBean,
DistributedReplicantManager.ReplicantListener {
    protected String replicantName = null;
    protected InvokerHA invokerHA;
    protected HATarget target;
    protected Invoker invoker;
    protected DistributedReplicantManager drm = null;
    protected ObjectName partitionObjectName;
    protected String loadBalancePolicy = (class$org$jboss$ha$framework$interfaces$RoundRobin == null ? (class$org$jboss$ha$framework$interfaces$RoundRobin = ProxyFactoryHA.class$("org.jboss.ha.framework.interfaces.RoundRobin")) : class$org$jboss$ha$framework$interfaces$RoundRobin).getName();
    protected NotificationListener listener;
    protected int state = 0;
    static /* synthetic */ Class class$org$jboss$ha$framework$interfaces$RoundRobin;

    public ObjectName getPartitionObjectName() {
        return this.partitionObjectName;
    }

    public void setPartitionObjectName(ObjectName partitionObjectName) {
        this.partitionObjectName = partitionObjectName;
    }

    public String getLoadBalancePolicy() {
        return this.loadBalancePolicy;
    }

    public void setLoadBalancePolicy(String loadBalancePolicy) {
        this.loadBalancePolicy = loadBalancePolicy;
    }

    public void createService() throws Exception {
        super.createService();
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute("State");
        this.listener = new StateChangeListener();
        this.getServer().addNotificationListener(this.getTargetName(), this.listener, (NotificationFilter)filter, null);
    }

    protected void startService() throws Exception {
        String partitionName = (String)this.getServer().getAttribute(this.partitionObjectName, "PartitionName");
        HAPartition partition = (HAPartition)this.getServer().getAttribute(this.partitionObjectName, "HAPartition");
        if (partition == null) {
            throw new RuntimeException("Partition is not registered: " + this.partitionObjectName);
        }
        this.drm = partition.getDistributedReplicantManager();
        this.replicantName = this.getTargetName().toString();
        this.invokerHA = (InvokerHA)Registry.lookup((Object)this.getInvokerName());
        if (this.invokerHA == null) {
            throw new RuntimeException("Invoker is not registered: " + this.getInvokerName());
        }
        int mode = 1;
        if (this.state == 3) {
            mode = 2;
        }
        this.target = new HATarget(partition, this.replicantName, this.invokerHA.getStub(), mode);
        this.invokerHA.registerBean(this.getTargetName(), this.target);
        String clusterFamilyName = partitionName + "/" + this.getTargetName() + "/";
        this.drm.registerListener(this.replicantName, this);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = cl.loadClass(this.loadBalancePolicy);
        LoadBalancePolicy policy = (LoadBalancePolicy)clazz.newInstance();
        this.invoker = this.invokerHA.createProxy(this.getTargetName(), policy, clusterFamilyName + "H");
        super.startService();
    }

    public void stopService() throws Exception {
        super.stopService();
        try {
            this.invokerHA.unregisterBean(this.getTargetName());
            this.target.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.drm != null) {
            this.drm.unregisterListener(this.replicantName, this);
        }
    }

    public void destroyService() throws Exception {
        super.destroyService();
        this.getServer().removeNotificationListener(this.getTargetName(), this.listener);
    }

    protected void containerIsFullyStarted() {
        if (this.target != null) {
            this.target.setInvocationsAuthorization(2);
        }
    }

    protected void containerIsAboutToStop() {
        if (this.target != null) {
            this.target.setInvocationsAuthorization(0);
            this.target.disable();
        }
    }

    public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId) {
        try {
            if (this.invoker instanceof InvokerProxyHA) {
                ((InvokerProxyHA)this.invoker).updateClusterInfo(this.target.getReplicants(), this.target.getCurrentViewId());
            }
            this.log.debug((Object)("Rebinding in JNDI... " + key));
            this.rebind();
        }
        catch (Exception none) {
            this.log.debug((Object)none);
        }
    }

    protected void createProxy(Object cacheID, String proxyBindingName, ClassLoader loader, Class[] ifaces) {
        GenericProxyFactory proxyFactory = new GenericProxyFactory();
        this.theProxy = proxyFactory.createProxy(cacheID, this.getTargetName(), this.invoker, this.getJndiName(), proxyBindingName, this.getInterceptorClasses(), loader, ifaces);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StateChangeListener
    implements NotificationListener {
        StateChangeListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification notif = (AttributeChangeNotification)notification;
                ProxyFactoryHA.this.state = (Integer)notif.getNewValue();
                if (ProxyFactoryHA.this.state == 3) {
                    ProxyFactoryHA.this.log.debug((Object)("Started: enabling remote access to mbean " + ProxyFactoryHA.this.getTargetName()));
                    ProxyFactoryHA.this.containerIsFullyStarted();
                } else if (ProxyFactoryHA.this.state == 1) {
                    ProxyFactoryHA.this.log.debug((Object)("About to stop: disabling remote access to mbean " + ProxyFactoryHA.this.getTargetName()));
                    ProxyFactoryHA.this.containerIsAboutToStop();
                }
            }
        }
    }
}

