/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jms.IllegalStateException;
import org.jboss.mq.MessageStatistics;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.jmx.DestinationMBeanSupport;
import org.jboss.mq.server.jmx.TopicMBean;

public class Topic
extends DestinationMBeanSupport
implements TopicMBean {
    JMSTopic destination;

    public String getTopicName() {
        return this.destinationName;
    }

    public void startService() throws Exception {
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new IllegalStateException("TopicName was not set");
        }
        JMSDestinationManager jmsServer = (JMSDestinationManager)this.server.getAttribute(this.jbossMQService, "Interceptor");
        this.spyDest = new SpyTopic(this.destinationName);
        this.destination = new JMSTopic(this.spyDest, null, jmsServer, this.parameters);
        jmsServer.addDestination(this.destination);
        if (this.jndiName == null) {
            this.setJNDIName("topic/" + this.destinationName);
        } else {
            this.setJNDIName(this.jndiName);
        }
        super.startService();
    }

    public void removeAllMessages() throws Exception {
        this.destination.removeAllMessages();
    }

    public int getAllMessageCount() {
        return this.destination.getAllMessageCount();
    }

    public int getDurableMessageCount() {
        return this.destination.getDurableMessageCount();
    }

    public int getNonDurableMessageCount() {
        return this.destination.getNonDurableMessageCount();
    }

    public int getAllSubscriptionsCount() {
        return this.destination.getAllSubscriptionsCount();
    }

    public int getDurableSubscriptionsCount() {
        return this.destination.getDurableSubscriptionsCount();
    }

    public int getNonDurableSubscriptionsCount() {
        return this.destination.getNonDurableSubscriptionsCount();
    }

    public List listAllSubscriptions() {
        return this.destination.getAllSubscriptions();
    }

    public List listDurableSubscriptions() {
        return this.destination.getDurableSubscriptions();
    }

    public List listNonDurableSubscriptions() {
        return this.destination.getNonDurableSubscriptions();
    }

    public List listMessages(String id) throws Exception {
        BasicQueue queue = this.findBasicQueue(id);
        return Arrays.asList(queue.browse(null));
    }

    public List listMessages(String id, String selector) throws Exception {
        BasicQueue queue = this.findBasicQueue(id);
        return Arrays.asList(queue.browse(selector));
    }

    public MessageCounter[] getMessageCounter() {
        return this.destination.getMessageCounter();
    }

    public MessageStatistics[] getMessageStatistics() throws Exception {
        return MessageCounter.getMessageStatistics(this.destination.getMessageCounter());
    }

    protected BasicQueue findBasicQueue(String id) throws Exception {
        ArrayList queues = this.destination.getAllQueues();
        if (id == null) {
            throw new IllegalArgumentException("Null subscription id: " + this.help(queues));
        }
        Iterator i = queues.iterator();
        while (i.hasNext()) {
            BasicQueue q = (BasicQueue)i.next();
            if (!q.getDescription().equals(id)) continue;
            return q;
        }
        throw new IllegalArgumentException("Invalid subscription id: " + this.help(queues));
    }

    protected String help(List queues) {
        return "id must be one from the following list " + queues;
    }
}

