/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Reference {
    public static final QName TOKEN = new QName(WSConstants.WSSE_NS, "Reference");
    protected Element element = null;

    public Reference(Element elem) throws WSSecurityException {
        if (elem == null) {
            throw new WSSecurityException(3, "noReference");
        }
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(0, "badElement", new Object[]{TOKEN, el});
        }
    }

    public Reference(Document doc) {
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:Reference");
    }

    public Element getElement() {
        return this.element;
    }

    public String getValueType() {
        return this.element.getAttribute("ValueType");
    }

    public String getURI() {
        return this.element.getAttribute("URI");
    }

    public void setValueType(String valueType) {
        this.element.setAttribute("ValueType", valueType);
    }

    public void setURI(String uri) {
        this.element.setAttribute("URI", uri);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }
}

