/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BinarySecurity {
    public static final QName TOKEN = new QName(WSConstants.WSSE_NS, "BinarySecurityToken");
    public static final QName TOKEN_KI = new QName(WSConstants.WSSE_NS, "KeyIdentifier");
    public static final String BASE64_BINARY = "Base64Binary";
    public static String BASE64_ENCODING = null;
    protected Element element = null;

    public BinarySecurity(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN) && !el.equals(TOKEN_KI)) {
            throw new WSSecurityException(4, "badTokenType", new Object[]{el});
        }
        if (!this.getEncodingType().endsWith(BASE64_BINARY)) {
            throw new WSSecurityException(4, "badEncoding", new Object[]{this.getEncodingType()});
        }
    }

    public BinarySecurity(Document doc) {
        this.element = doc.createElementNS(WSConstants.WSSE_NS, "wsse:BinarySecurityToken");
        WSSecurityUtil.setNamespace(this.element, WSConstants.WSSE_NS, "wsse");
        this.setEncodingType(BASE64_ENCODING);
        this.element.appendChild(doc.createTextNode(""));
    }

    public String getValueType() {
        String valueType = this.element.getAttribute("ValueType");
        if (valueType.length() == 0) {
            valueType = this.element.getAttributeNS(WSConstants.WSSE_NS, "ValueType");
        }
        return valueType;
    }

    protected void setValueType(String type) {
        this.element.setAttributeNS(null, "ValueType", type);
    }

    public String getEncodingType() {
        String encodingType = this.element.getAttribute("EncodingType");
        if (encodingType.length() == 0) {
            encodingType = this.element.getAttributeNS(WSConstants.WSSE_NS, "EncodingType");
        }
        return encodingType;
    }

    protected void setEncodingType(String encoding) {
        this.element.setAttributeNS(null, "EncodingType", encoding);
    }

    public byte[] getToken() {
        Text node = this.getFirstNode();
        if (node == null) {
            return null;
        }
        try {
            return Base64.decode((String)node.getData());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setToken(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Text node = this.getFirstNode();
        node.setData(Base64.encode((byte[])data));
    }

    protected Text getFirstNode() {
        Node node = this.element.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String getID() {
        return this.element.getAttributeNS(WSConstants.WSU_NS, "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, WSConstants.WSU_NS, "wsu");
        this.element.setAttributeNS(WSConstants.WSU_NS, prefix + ":Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    static {
        BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    }
}

