/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.WSDoAllConstants;
import org.apache.ws.axis.security.WSDoAllReceiverResult;
import org.apache.ws.axis.security.saml.SAMLIssuer;
import org.apache.ws.axis.security.saml.SAMLIssuerFactory;
import org.apache.ws.axis.security.util.AxisUtil;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSAddTimestamp;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.WSSAddSAMLToken;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDoAllSender
extends BasicHandler {
    static Log log = LogFactory.getLog((String)(class$org$apache$ws$axis$security$WSDoAllSender == null ? (class$org$apache$ws$axis$security$WSDoAllSender = WSDoAllSender.class$("org.apache.ws.axis.security.WSDoAllSender")) : class$org$apache$ws$axis$security$WSDoAllSender).getName());
    static final WSSecurityEngine secEngine = new WSSecurityEngine();
    private boolean doDebug = true;
    private static Hashtable cryptos = new Hashtable(5);
    private MessageContext msgContext = null;
    private boolean noSerialization = false;
    private SOAPConstants soapConstants = null;
    String actor = null;
    String username = null;
    String pwType = null;
    String[] utElements = null;
    Crypto sigCrypto = null;
    int sigKeyId = 0;
    String sigAlgorithm = null;
    Vector signatureParts = new Vector();
    Crypto encCrypto = null;
    int encKeyId = 0;
    String encSymmAlgo = null;
    String encKeyTransport = null;
    String encUser = null;
    Vector encryptParts = new Vector();
    X509Certificate encCert = null;
    protected int timeToLive = 300;
    static /* synthetic */ Class class$org$apache$ws$axis$security$WSDoAllSender;

    private void initialize() {
        this.signatureParts.removeAllElements();
        this.encryptParts.removeAllElements();
    }

    public void invoke(MessageContext mc) throws AxisFault {
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug((Object)("WSDoAllSender: enter invoke() with msg type: " + mc.getCurrentMessage().getMessageType()));
        }
        this.initialize();
        this.noSerialization = false;
        this.msgContext = mc;
        Vector actions = new Vector();
        String action = null;
        action = (String)this.getOption("action");
        if (action == null) {
            action = (String)this.msgContext.getProperty("action");
        }
        if (action == null) {
            throw new AxisFault("WSDoAllReceiver: No action defined");
        }
        int doAction = AxisUtil.decodeAction(action, actions);
        if (doAction == 0) {
            return;
        }
        boolean mu = this.decodeMustUnderstand();
        this.actor = (String)this.getOption("actor");
        if (this.actor == null) {
            this.actor = (String)this.msgContext.getProperty("actor");
        }
        this.username = (String)this.getOption("user");
        if (this.username == null || this.username.equals("")) {
            this.username = this.msgContext.getUsername();
            this.msgContext.setUsername(null);
        }
        if ((doAction & 3) != 0 && (this.username == null || this.username.equals(""))) {
            throw new AxisFault("WSDoAllSender: Empty username for specified action");
        }
        if (this.doDebug) {
            log.debug((Object)("Action: " + doAction));
            log.debug((Object)("Actor: " + this.actor + ", mu: " + mu));
        }
        Document doc = null;
        Message message = this.msgContext.getCurrentMessage();
        SOAPPart sPart = (SOAPPart)message.getSOAPPart();
        doc = (Document)this.msgContext.getProperty("SND_SECURTIY");
        if (doc == null) {
            try {
                doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
            }
            catch (Exception e) {
                throw new AxisFault("WSDoAllSender: cannot get SOAP envlope from message" + e);
            }
        }
        this.soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if ((doAction & 1) == 1) {
            this.decodeUTParameter();
        }
        if ((doAction & 2) == 2) {
            this.sigCrypto = this.loadSignatureCrypto();
            this.decodeSignatureParameter();
        }
        if ((doAction & 0x10) == 16) {
            this.decodeSignatureParameter();
        }
        if ((doAction & 4) == 4) {
            this.encCrypto = this.loadEncryptionCrypto();
            this.decodeEncryptionParameter();
        }
        block13: for (int i = 0; i < actions.size(); ++i) {
            int actionToDo = (Integer)actions.get(i);
            if (this.doDebug) {
                log.debug((Object)("Performing Action: " + actionToDo));
            }
            Object password = null;
            switch (actionToDo) {
                case 1: {
                    this.performUTAction(actionToDo, mu, doc);
                    continue block13;
                }
                case 4: {
                    this.performENCRAction(mu, actionToDo, doc);
                    continue block13;
                }
                case 2: {
                    this.performSIGNAction(actionToDo, mu, doc);
                    continue block13;
                }
                case 16: {
                    this.performST_SIGNAction(actionToDo, mu, doc);
                    continue block13;
                }
                case 8: {
                    this.performSTAction(actionToDo, mu, doc);
                    continue block13;
                }
                case 32: {
                    this.performTSAction(actionToDo, mu, doc);
                    continue block13;
                }
                case 256: {
                    this.noSerialization = true;
                }
            }
        }
        if (this.noSerialization) {
            this.msgContext.setProperty("SND_SECURTIY", (Object)doc);
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            sPart.setCurrentMessage((Object)os.toByteArray(), 4);
            if (this.doDebug) {
                String osStr = null;
                try {
                    osStr = os.toString("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    osStr = os.toString();
                }
                log.debug((Object)"Send request:");
                log.debug((Object)osStr);
            }
            this.msgContext.setProperty("SND_SECURTIY", null);
        }
        if (this.doDebug) {
            log.debug((Object)"WSDoAllSender: exit invoke()");
        }
    }

    private void performSIGNAction(int actionToDo, boolean mu, Document doc) throws AxisFault {
        String password = this.getPassword(this.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef").getPassword();
        WSSignEnvelope wsSign = new WSSignEnvelope(this.actor, mu);
        if (this.sigKeyId != 0) {
            wsSign.setKeyIdentifierType(this.sigKeyId);
        }
        if (this.sigAlgorithm != null) {
            wsSign.setSignatureAlgorithm(this.sigAlgorithm);
        }
        wsSign.setUserInfo(this.username, password);
        if (this.signatureParts.size() > 0) {
            wsSign.setParts(this.signatureParts);
        }
        try {
            wsSign.build(doc, this.sigCrypto);
        }
        catch (WSSecurityException e) {
            throw new AxisFault("WSDoAllSender: Signature: error during message procesing" + e);
        }
    }

    private void performENCRAction(boolean mu, int actionToDo, Document doc) throws AxisFault {
        WSEncryptBody wsEncrypt = new WSEncryptBody(this.actor, mu);
        if (this.encKeyId != 0) {
            wsEncrypt.setKeyIdentifierType(this.encKeyId);
        }
        if (this.encKeyId == 5) {
            String encKeyName = null;
            encKeyName = (String)this.getOption("EmbeddedKeyName");
            if (encKeyName == null) {
                encKeyName = (String)this.msgContext.getProperty("EmbeddedKeyName");
            }
            wsEncrypt.setEmbeddedKeyName(encKeyName);
            byte[] embeddedKey = this.getPassword(this.encUser, actionToDo, "EmbeddedKeyCallbackClass", "EmbeddedKeyCallbackRef").getKey();
            wsEncrypt.setKey(embeddedKey);
        }
        if (this.encSymmAlgo != null) {
            wsEncrypt.setSymmetricEncAlgorithm(this.encSymmAlgo);
        }
        if (this.encKeyTransport != null) {
            wsEncrypt.setKeyEnc(this.encKeyTransport);
        }
        wsEncrypt.setUserInfo(this.encUser);
        wsEncrypt.setUseThisCert(this.encCert);
        if (this.encryptParts.size() > 0) {
            wsEncrypt.setParts(this.encryptParts);
        }
        try {
            wsEncrypt.build(doc, this.encCrypto);
        }
        catch (WSSecurityException e) {
            throw new AxisFault("WSDoAllSender: Encryption: error during message processing" + e);
        }
    }

    private void performUTAction(int actionToDo, boolean mu, Document doc) throws AxisFault {
        String password = this.getPassword(this.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef").getPassword();
        WSSAddUsernameToken builder = new WSSAddUsernameToken(this.actor, mu);
        builder.setPasswordType(this.pwType);
        builder.build(doc, this.username, password);
        if (this.utElements != null && this.utElements.length > 0) {
            for (int j = 0; j < this.utElements.length; ++j) {
                this.utElements[j].trim();
                if (this.utElements[j].equals("Nonce")) {
                    builder.addNonce(doc);
                }
                if (!this.utElements[j].equals("Created")) continue;
                builder.addCreated(doc);
            }
        }
    }

    private void performSTAction(int actionToDo, boolean mu, Document doc) throws AxisFault {
        WSSAddSAMLToken builder = new WSSAddSAMLToken(this.actor, mu);
        String samlPropFile = null;
        samlPropFile = (String)this.getOption("samlPropFile");
        if (samlPropFile == null) {
            samlPropFile = (String)this.msgContext.getProperty("samlPropFile");
        }
        SAMLIssuer saml = SAMLIssuerFactory.getInstance(samlPropFile);
        saml.setAxisMsg(this.msgContext);
        saml.setAxisHandler(this);
        saml.setUsername(this.username);
        SAMLAssertion assertion = saml.newAssertion();
        builder.build(doc, assertion);
    }

    private void performST_SIGNAction(int actionToDo, boolean mu, Document doc) throws AxisFault {
        String samlPropFile = null;
        samlPropFile = (String)this.getOption("samlPropFile");
        if (samlPropFile == null) {
            samlPropFile = (String)this.msgContext.getProperty("samlPropFile");
        }
        Crypto crypto = null;
        try {
            crypto = this.loadSignatureCrypto();
        }
        catch (AxisFault ex) {
            // empty catch block
        }
        SAMLIssuer saml = SAMLIssuerFactory.getInstance(samlPropFile);
        saml.setAxisMsg(this.msgContext);
        saml.setAxisHandler(this);
        saml.setUsername(this.username);
        saml.setUserCrypto(crypto);
        saml.setInstanceDoc(doc);
        SAMLAssertion assertion = saml.newAssertion();
        if (assertion == null) {
            throw new AxisFault("WSDoAllSender: Signed SAML: no SAML token received");
        }
        String issuerKeyName = null;
        String issuerKeyPW = null;
        Crypto issuerCrypto = null;
        WSSignEnvelope wsSign = new WSSignEnvelope(this.actor, mu);
        String password = null;
        if (saml.isSenderVouches()) {
            issuerKeyName = saml.getIssuerKeyName();
            issuerKeyPW = saml.getIssuerKeyPassword();
            issuerCrypto = saml.getIssuerCrypto();
        } else {
            password = this.getPassword(this.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef").getPassword();
            wsSign.setUserInfo(this.username, password);
        }
        if (this.sigKeyId != 0) {
            wsSign.setKeyIdentifierType(this.sigKeyId);
        }
        try {
            wsSign.build(doc, crypto, assertion, issuerCrypto, issuerKeyName, issuerKeyPW);
        }
        catch (WSSecurityException e) {
            throw new AxisFault("WSDoAllSender: Signed SAML: error during message processing" + e);
        }
    }

    private void performTSAction(int actionToDo, boolean mu, Document doc) throws AxisFault {
        String ttl = null;
        ttl = (String)this.getOption("timeToLive");
        if (ttl == null) {
            ttl = (String)this.msgContext.getProperty("timeToLive");
        }
        int ttl_i = 0;
        if (ttl != null) {
            try {
                ttl_i = Integer.parseInt(ttl);
            }
            catch (NumberFormatException e) {
                ttl_i = this.timeToLive;
            }
        }
        if (ttl_i <= 0) {
            ttl_i = this.timeToLive;
        }
        WSAddTimestamp timeStampBuilder = new WSAddTimestamp(this.actor, mu);
        timeStampBuilder.build(doc, ttl_i);
    }

    protected Crypto loadSignatureCrypto() throws AxisFault {
        Crypto crypto = null;
        String sigPropFile = null;
        sigPropFile = (String)this.getOption("signaturePropFile");
        if (sigPropFile == null) {
            sigPropFile = (String)this.msgContext.getProperty("signaturePropFile");
        }
        if (sigPropFile != null) {
            crypto = (Crypto)cryptos.get(sigPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(sigPropFile);
                cryptos.put(sigPropFile, crypto);
            }
        } else {
            throw new AxisFault("WSDoAllSender: Signature: no crypto property file");
        }
        return crypto;
    }

    protected Crypto loadEncryptionCrypto() throws AxisFault {
        Crypto crypto = null;
        String encPropFile = null;
        encPropFile = (String)this.getOption("encryptionPropFile");
        if (encPropFile == null) {
            encPropFile = (String)this.msgContext.getProperty("encryptionPropFile");
        }
        if (encPropFile != null) {
            crypto = (Crypto)cryptos.get(encPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(encPropFile);
                cryptos.put(encPropFile, crypto);
            }
        } else {
            crypto = this.sigCrypto;
            if (crypto == null) {
                throw new AxisFault("WSDoAllSender: Encryption: no crypto property file");
            }
        }
        return crypto;
    }

    private void decodeUTParameter() throws AxisFault {
        this.pwType = (String)this.getOption("passwordType");
        if (this.pwType == null) {
            this.pwType = (String)this.msgContext.getProperty("passwordType");
        }
        if (this.pwType != null) {
            this.pwType = this.pwType.equals("PasswordText") ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
        }
        String tmpS = null;
        tmpS = (String)this.getOption("addUTElements");
        if (tmpS == null) {
            tmpS = (String)this.msgContext.getProperty("addUTElements");
        }
        if (tmpS != null) {
            this.utElements = StringUtil.split(tmpS, ' ');
        }
    }

    private void decodeSignatureParameter() throws AxisFault {
        String tmpS = null;
        tmpS = (String)this.getOption("signatureKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)this.msgContext.getProperty("signatureKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSDoAllConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new AxisFault("WSDoAllSender: Signature: unknown key identification");
            }
            this.sigKeyId = I;
            if (this.sigKeyId != 2 && this.sigKeyId != 1 && this.sigKeyId != 3 && this.sigKeyId != 4) {
                throw new AxisFault("WSDoAllSender: Signature: illegal key identification");
            }
        }
        if ((this.sigAlgorithm = (String)this.getOption("signatureAlgorithm")) == null) {
            tmpS = (String)this.msgContext.getProperty("signatureAlgorithm");
        }
        if ((tmpS = (String)this.getOption("signatureParts")) == null) {
            tmpS = (String)this.msgContext.getProperty("signatureParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, this.signatureParts);
        }
    }

    private void decodeEncryptionParameter() throws AxisFault {
        this.encUser = (String)this.getOption("encryptionUser");
        if (this.encUser == null) {
            this.encUser = (String)this.msgContext.getProperty("encryptionUser");
        }
        if (this.encUser == null && (this.encUser = this.username) == null) {
            throw new AxisFault("WSDoAllSender: Encryption: no username");
        }
        this.handleSpecialUser(this.encUser);
        String tmpS = null;
        tmpS = (String)this.getOption("encryptionKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)this.msgContext.getProperty("encryptionKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSDoAllConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new AxisFault("WSDoAllSender: Encryption: unknown key identification");
            }
            this.encKeyId = I;
            if (this.encKeyId != 2 && this.encKeyId != 3 && this.encKeyId != 4 && this.encKeyId != 1 && this.encKeyId != 5) {
                throw new AxisFault("WSDoAllSender: Encryption: illegal key identification");
            }
        }
        if ((this.encSymmAlgo = (String)this.getOption("encryptionSymAlgorithm")) == null) {
            this.encSymmAlgo = (String)this.msgContext.getProperty("encryptionSymAlgorithm");
        }
        if ((this.encKeyTransport = (String)this.getOption("encryptionKeyTransportAlgorithm")) == null) {
            this.encKeyTransport = (String)this.msgContext.getProperty("encryptionKeyTransportAlgorithm");
        }
        if ((tmpS = (String)this.getOption("encryptionParts")) == null) {
            tmpS = (String)this.msgContext.getProperty("encryptionParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, this.encryptParts);
        }
    }

    private boolean decodeMustUnderstand() throws AxisFault {
        boolean mu = true;
        String mustUnderstand = null;
        mustUnderstand = (String)this.getOption("mustUnderstand");
        if (mustUnderstand == null) {
            mustUnderstand = (String)this.msgContext.getProperty("mustUnderstand");
        }
        if (mustUnderstand != null) {
            if (mustUnderstand.equals("0") || mustUnderstand.equals("false")) {
                mu = false;
            } else if (mustUnderstand.equals("1") || mustUnderstand.equals("true")) {
                mu = true;
            } else {
                throw new AxisFault("WSDoAllSender: illegal mustUnderstand parameter");
            }
        }
        return mu;
    }

    private WSPasswordCallback getPassword(String username, int doAction, String clsProp, String refProp) throws AxisFault {
        WSPasswordCallback pwCb = null;
        String password = null;
        String callback = null;
        CallbackHandler cbHandler = null;
        callback = (String)this.getOption(clsProp);
        if (callback == null) {
            callback = (String)this.msgContext.getProperty(clsProp);
        }
        if (callback != null) {
            pwCb = this.readPwViaCallbackClass(callback, username, doAction);
            if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                throw new AxisFault("WSDoAllSender: password callback class provided null or empty password");
            }
        } else {
            cbHandler = (CallbackHandler)this.msgContext.getProperty(refProp);
            if (cbHandler != null) {
                pwCb = this.performCallback(cbHandler, username, doAction);
                if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                    throw new AxisFault("WSDoAllSender: password callback provided null or empty password");
                }
            } else {
                password = this.msgContext.getPassword();
                if (password == null) {
                    throw new AxisFault("WSDoAllSender: application provided null or empty password");
                }
                this.msgContext.setPassword(null);
                pwCb = new WSPasswordCallback("", 0);
                pwCb.setPassword(password);
            }
        }
        return pwCb;
    }

    private WSPasswordCallback readPwViaCallbackClass(String callback, String username, int doAction) throws AxisFault {
        Class<?> cbClass = null;
        CallbackHandler cbHandler = null;
        try {
            cbClass = Class.forName(callback);
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault("WSDoAllSender: cannot load password callback class: " + callback, (Throwable)e);
        }
        try {
            cbHandler = (CallbackHandler)cbClass.newInstance();
        }
        catch (Exception e) {
            throw new AxisFault("WSDoAllSender: cannot create instance of password callback: " + callback, (Throwable)e);
        }
        return this.performCallback(cbHandler, username, doAction);
    }

    private WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws AxisFault {
        WSPasswordCallback pwCb = null;
        int reason = 0;
        switch (doAction) {
            case 1: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new AxisFault("WSDoAllSender: password callback failed", (Throwable)e);
        }
        return pwCb;
    }

    private void splitEncParts(String tmpS, Vector encryptParts) throws AxisFault {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split(tmpS, ';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split(rawParts[i], '}');
            if (partDef.length == 1) {
                if (this.doDebug) {
                    log.debug((Object)("single partDef: '" + partDef[0] + "'"));
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), this.soapConstants.getEnvelopeURI(), "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                nmSpace = nmSpace.length() <= 1 ? this.soapConstants.getEnvelopeURI() : nmSpace.substring(1);
                String element = partDef[2].trim();
                if (this.doDebug) {
                    log.debug((Object)("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'"));
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                throw new AxisFault("WSDoAllSender: wrong part definition: " + tmpS);
            }
            encryptParts.add(encPart);
        }
    }

    private void handleSpecialUser(String encUser) {
        if (!"useReqSigCert".equals(encUser)) {
            return;
        }
        Vector results = null;
        results = (Vector)this.msgContext.getProperty("RECV_RESULTS");
        if (results == null) {
            return;
        }
        for (int i = 0; i < results.size(); ++i) {
            WSDoAllReceiverResult rResult = (WSDoAllReceiverResult)results.get(i);
            String hActor = rResult.getActor();
            if (!WSSecurityUtil.isActorEqual(this.actor, hActor)) continue;
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 2) continue;
                this.encCert = wser.getCertificate();
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

