/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.wsdl.symbolTable.BindingEntry;
import org.jboss.axis.wsdl.symbolTable.PortTypeEntry;
import org.jboss.axis.wsdl.symbolTable.ServiceEntry;
import org.jboss.axis.wsdl.symbolTable.SymbolTable;
import org.jboss.axis.wsdl.toJava.Emitter;
import org.jboss.axis.wsdl.toJava.JavaBindingWriter;
import org.jboss.axis.wsdl.toJava.JavaClassWriter;
import org.jboss.axis.wsdl.toJava.Utils;

public class JavaServiceIfaceWriter
extends JavaClassWriter {
    private Service service;
    private SymbolTable symbolTable;
    static /* synthetic */ Class class$javax$xml$rpc$ServiceException;

    protected JavaServiceIfaceWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName(), "service");
        this.service = sEntry.getService();
        this.symbolTable = symbolTable;
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getExtendsText() {
        return "extends javax.xml.rpc.Service ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeComment(pw, this.service.getDocumentationElement());
        Map portMap = this.service.getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId(portName)) {
                portName = Utils.xmlNameToJavaClass(portName);
            }
            String bindingType = (String)bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
            pw.println("    public java.lang.String get" + portName + "Address();");
            pw.println();
            pw.println("    public " + bindingType + " get" + portName + "() throws " + (class$javax$xml$rpc$ServiceException == null ? JavaServiceIfaceWriter.class$("javax.xml.rpc.ServiceException") : class$javax$xml$rpc$ServiceException).getName() + ";");
            pw.println();
            pw.println("    public " + bindingType + " get" + portName + "(java.net.URL portAddress) throws " + (class$javax$xml$rpc$ServiceException == null ? JavaServiceIfaceWriter.class$("javax.xml.rpc.ServiceException") : class$javax$xml$rpc$ServiceException).getName() + ";");
        }
    }
}

