/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.eval.CodeSnippetCodeStream;
import org.eclipse.jdt.internal.eval.CodeSnippetScope;
import org.eclipse.jdt.internal.eval.EvaluationConstants;
import org.eclipse.jdt.internal.eval.EvaluationContext;

public class CodeSnippetFieldReference
extends FieldReference
implements ProblemReasons,
EvaluationConstants {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetFieldReference(char[] source, long pos, EvaluationContext evaluationContext) {
        super(source, pos);
        this.evaluationContext = evaluationContext;
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
            this.receiver.generateCode(currentScope, codeStream, !this.codegenBinding.isStatic());
            assignment.expression.generateCode(currentScope, codeStream, true);
            this.fieldStore(codeStream, this.codegenBinding, null, valueRequired);
        } else {
            ((CodeSnippetCodeStream)codeStream).generateEmulationForField(this.codegenBinding);
            this.receiver.generateCode(currentScope, codeStream, !this.codegenBinding.isStatic());
            if (this.codegenBinding.isStatic()) {
                codeStream.aconst_null();
            }
            assignment.expression.generateCode(currentScope, codeStream, true);
            if (valueRequired) {
                if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                    codeStream.dup2_x2();
                } else {
                    codeStream.dup_x2();
                }
            }
            ((CodeSnippetCodeStream)codeStream).generateEmulatedWriteAccessForField(this.codegenBinding);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != AstNode.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (valueRequired) {
                if (this.codegenBinding.constant == AstNode.NotAConstant) {
                    if (this.codegenBinding.declaringClass == null) {
                        codeStream.arraylength();
                    } else if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
                        if (isStatic) {
                            codeStream.getstatic(this.codegenBinding);
                        } else {
                            codeStream.getfield(this.codegenBinding);
                        }
                    } else {
                        if (isStatic) {
                            codeStream.aconst_null();
                        }
                        ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(this.codegenBinding);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else {
                    if (!isStatic) {
                        codeStream.invokeObjectGetClass();
                        codeStream.pop();
                    }
                    codeStream.generateConstant(this.codegenBinding.constant, this.implicitConversion);
                }
            } else if (!isStatic) {
                codeStream.invokeObjectGetClass();
                codeStream.pop();
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (isStatic) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.dup();
                codeStream.getfield(this.codegenBinding);
            }
            int operationTypeID = this.implicitConversion >> 4;
            if (operationTypeID == 11) {
                codeStream.generateStringAppend(currentScope, null, expression);
            } else {
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(currentScope, codeStream, true);
                }
                codeStream.sendOperator(operator, operationTypeID);
                codeStream.generateImplicitConversion(assignmentImplicitConversion);
            }
            this.fieldStore(codeStream, this.codegenBinding, null, valueRequired);
        } else {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (isStatic) {
                ((CodeSnippetCodeStream)codeStream).generateEmulationForField(this.codegenBinding);
                codeStream.aconst_null();
                codeStream.aconst_null();
                ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(this.codegenBinding);
            } else {
                ((CodeSnippetCodeStream)codeStream).generateEmulationForField(this.binding);
                isStatic = this.codegenBinding.isStatic();
                this.receiver.generateCode(currentScope, codeStream, !isStatic);
                codeStream.dup();
                ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(this.codegenBinding);
            }
            int operationTypeID = this.implicitConversion >> 4;
            if (operationTypeID == 11) {
                codeStream.generateStringAppend(currentScope, null, expression);
            } else {
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(currentScope, codeStream, true);
                }
                codeStream.sendOperator(operator, operationTypeID);
                codeStream.generateImplicitConversion(assignmentImplicitConversion);
            }
            if (valueRequired) {
                if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                    codeStream.dup2_x2();
                } else {
                    codeStream.dup_x2();
                }
            }
            ((CodeSnippetCodeStream)codeStream).generateEmulatedWriteAccessForField(this.codegenBinding);
        }
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        if (this.codegenBinding.canBeSeenBy(this.receiverType, this, currentScope)) {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (isStatic) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.dup();
                codeStream.getfield(this.codegenBinding);
            }
            if (valueRequired) {
                if (isStatic) {
                    if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                        codeStream.dup2();
                    } else {
                        codeStream.dup();
                    }
                } else if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                    codeStream.dup2_x1();
                } else {
                    codeStream.dup_x1();
                }
            }
            codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
            codeStream.sendOperator(postIncrement.operator, this.codegenBinding.type.id);
            codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
            this.fieldStore(codeStream, this.codegenBinding, null, false);
        } else {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (this.codegenBinding.isStatic()) {
                codeStream.aconst_null();
            }
            codeStream.dup();
            ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(this.codegenBinding);
            if (valueRequired) {
                if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                    codeStream.dup2_x1();
                } else {
                    codeStream.dup_x1();
                }
            }
            if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                codeStream.dup2_x1();
                codeStream.pop2();
            } else {
                codeStream.dup_x1();
                codeStream.pop();
            }
            ((CodeSnippetCodeStream)codeStream).generateEmulationForField(this.codegenBinding);
            codeStream.swap();
            if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                codeStream.dup2_x2();
            } else {
                codeStream.dup2_x1();
            }
            codeStream.pop2();
            codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
            codeStream.sendOperator(postIncrement.operator, this.codegenBinding.type.id);
            codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
            ((CodeSnippetCodeStream)codeStream).generateEmulatedWriteAccessForField(this.codegenBinding);
        }
    }

    public void manageSyntheticReadAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (this.binding.declaringClass != this.receiverType && !this.receiverType.isArrayType() && this.binding.declaringClass != null && this.binding.constant == AstNode.NotAConstant && (currentScope.environment().options.targetJDK >= 1 && this.binding.declaringClass.id != 1 || !this.binding.declaringClass.canBeSeenBy(currentScope))) {
            this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(this.binding, (ReferenceBinding)this.receiverType);
        }
    }

    public void manageSyntheticWriteAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (this.binding.declaringClass != this.receiverType && !this.receiverType.isArrayType() && this.binding.declaringClass != null && this.binding.constant == AstNode.NotAConstant && (currentScope.environment().options.targetJDK >= 1 && this.binding.declaringClass.id != 1 || !this.binding.declaringClass.canBeSeenBy(currentScope))) {
            this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(this.binding, (ReferenceBinding)this.receiverType);
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.receiverType = this.receiver.resolveType(scope);
        if (this.receiverType == null) {
            this.constant = AstNode.NotAConstant;
            return null;
        }
        this.codegenBinding = this.binding = scope.getField(this.receiverType, this.token, this);
        FieldBinding firstAttempt = this.binding;
        boolean isNotVisible = false;
        if (!this.binding.isValidBinding() && this.binding instanceof ProblemFieldBinding && ((ProblemFieldBinding)this.binding).problemId() == 2) {
            isNotVisible = true;
            if (this.evaluationContext.declaringTypeName != null) {
                this.delegateThis = scope.getField(scope.enclosingSourceType(), EvaluationConstants.DELEGATE_THIS, this);
                if (this.delegateThis == null) {
                    this.constant = AstNode.NotAConstant;
                    scope.problemReporter().invalidField(this, this.receiverType);
                    return null;
                }
            } else {
                this.constant = AstNode.NotAConstant;
                scope.problemReporter().invalidField(this, this.receiverType);
                return null;
            }
            CodeSnippetScope localScope = new CodeSnippetScope(scope);
            this.codegenBinding = this.binding = localScope.getFieldForCodeSnippet(this.delegateThis.type, this.token, this);
        }
        if (!this.binding.isValidBinding()) {
            this.constant = AstNode.NotAConstant;
            if (isNotVisible) {
                this.codegenBinding = this.binding = firstAttempt;
            }
            scope.problemReporter().invalidField(this, this.receiverType);
            return null;
        }
        if (this.isFieldUseDeprecated(this.binding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().deprecatedField(this.binding, this);
        }
        this.constant = FieldReference.getConstantFor(this.binding, this, this.receiver.isImplicitThis(), scope);
        if (!this.receiver.isThis()) {
            this.constant = AstNode.NotAConstant;
        }
        this.resolvedType = this.binding.type;
        return this.resolvedType;
    }
}

