/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;

public abstract class MethodPattern
extends SearchPattern {
    protected char[] selector;
    protected char[] declaringQualification;
    protected char[] declaringSimpleName;
    protected char[] returnQualification;
    protected char[] returnSimpleName;
    protected char[][] parameterQualifications;
    protected char[][] parameterSimpleNames;
    protected char[] decodedSelector;
    protected int decodedParameterCount;

    public MethodPattern(int matchMode, boolean isCaseSensitive) {
        super(matchMode, isCaseSensitive);
    }

    public abstract String getPatternName();

    protected boolean matchIndexEntry() {
        if (this.selector != null) {
            switch (this.matchMode) {
                case 0: {
                    if (CharOperation.equals(this.selector, this.decodedSelector, this.isCaseSensitive)) break;
                    return false;
                }
                case 1: {
                    if (CharOperation.prefixEquals(this.selector, this.decodedSelector, this.isCaseSensitive)) break;
                    return false;
                }
                case 2: {
                    if (CharOperation.match(this.selector, this.decodedSelector, this.isCaseSensitive)) break;
                    return false;
                }
            }
        }
        return this.parameterSimpleNames == null || this.parameterSimpleNames.length == this.decodedParameterCount;
    }

    protected boolean needsResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        if (this.returnSimpleName != null || this.returnQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (this.parameterQualifications[i] != null || this.parameterSimpleNames[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(this.getPatternName());
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            buffer.append("*.");
        }
        if (this.selector != null) {
            buffer.append(this.selector);
        } else {
            buffer.append("*");
        }
        buffer.append('(');
        if (this.parameterSimpleNames == null) {
            buffer.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    buffer.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    buffer.append('*');
                } else {
                    buffer.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.returnQualification != null) {
            buffer.append(" --> ").append(this.returnQualification).append('.');
        } else if (this.returnSimpleName != null) {
            buffer.append(" --> ");
        }
        if (this.returnSimpleName != null) {
            buffer.append(this.returnSimpleName);
        } else if (this.returnQualification != null) {
            buffer.append("*");
        }
        buffer.append(", ");
        switch (this.matchMode) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

