/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchSet;

public class MatchLocatorParser
extends Parser {
    public MatchSet matchSet;
    private LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor();

    public MatchLocatorParser(ProblemReporter problemReporter, int sourceLevel) {
        super(problemReporter, true, sourceLevel);
    }

    protected void classInstanceCreation(boolean alwaysQualified) {
        super.classInstanceCreation(alwaysQualified);
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.expressionStack[this.expressionPtr]);
        }
    }

    protected void consumeAssignment() {
        super.consumeAssignment();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.expressionStack[this.expressionPtr]);
        }
    }

    protected void consumeExplicitConstructorInvocation(int flag, int recFlag) {
        super.consumeExplicitConstructorInvocation(flag, recFlag);
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.astStack[this.astPtr]);
        }
    }

    protected void consumeFieldAccess(boolean isSuperAccess) {
        super.consumeFieldAccess(isSuperAccess);
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.expressionStack[this.expressionPtr]);
        }
    }

    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.expressionStack[this.expressionPtr]);
        }
    }

    protected void consumeMethodInvocationPrimary() {
        super.consumeMethodInvocationPrimary();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.expressionStack[this.expressionPtr]);
        }
    }

    protected void consumeMethodInvocationSuper() {
        super.consumeMethodInvocationSuper();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.expressionStack[this.expressionPtr]);
        }
    }

    protected void consumePrimaryNoNewArray() {
        --this.intPtr;
        --this.intPtr;
    }

    protected void consumeSingleTypeImportDeclarationName() {
        super.consumeSingleTypeImportDeclarationName();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.astStack[this.astPtr]);
        }
    }

    protected void consumeTypeImportOnDemandDeclarationName() {
        super.consumeTypeImportOnDemandDeclarationName();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.astStack[this.astPtr]);
        }
    }

    protected void consumeUnaryExpression(int op, boolean post) {
        super.consumeUnaryExpression(op, post);
        if (this.matchSet != null) {
            this.matchSet.checkMatching(this.expressionStack[this.expressionPtr]);
        }
    }

    protected TypeReference copyDims(TypeReference typeRef, int dim) {
        TypeReference result = super.copyDims(typeRef, dim);
        if (this.matchSet != null) {
            if (this.matchSet.removePossibleMatch(typeRef) != null) {
                this.matchSet.addPossibleMatch(result);
            } else if (this.matchSet.removeTrustedMatch(typeRef) != null) {
                this.matchSet.addTrustedMatch(result);
            }
        }
        return result;
    }

    protected CompilationUnitDeclaration dietParse(ICompilationUnit sourceUnit, MatchLocator locator, IFile file, CompilationUnit compilationUnit) {
        MatchSet originalMatchSet = this.matchSet;
        CompilationUnitDeclaration unit = null;
        try {
            this.matchSet = new MatchSet(locator);
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
            unit = this.dietParse(sourceUnit, compilationResult);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (originalMatchSet == null) {
                if (!this.matchSet.isEmpty() && unit != null && file != null) {
                    locator.addMatchingOpenable((IResource)file, compilationUnit, unit, this.matchSet);
                }
                this.matchSet = null;
            } else {
                this.matchSet = originalMatchSet;
            }
            throw throwable;
        }
        Object var8_10 = null;
        if (originalMatchSet == null) {
            if (!this.matchSet.isEmpty() && unit != null && file != null) {
                locator.addMatchingOpenable((IResource)file, compilationUnit, unit, this.matchSet);
            }
            this.matchSet = null;
        } else {
            this.matchSet = originalMatchSet;
        }
        return unit;
    }

    protected TypeReference getTypeReference(int dim) {
        TypeReference typeRef = super.getTypeReference(dim);
        if (this.matchSet != null) {
            this.matchSet.checkMatching(typeRef);
        }
        return typeRef;
    }

    protected NameReference getUnspecifiedReference() {
        NameReference nameRef = super.getUnspecifiedReference();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(nameRef);
        }
        return nameRef;
    }

    protected NameReference getUnspecifiedReferenceOptimized() {
        NameReference nameRef = super.getUnspecifiedReferenceOptimized();
        if (this.matchSet != null) {
            this.matchSet.checkMatching(nameRef);
        }
        return nameRef;
    }

    public void parseBodies(CompilationUnitDeclaration unit) {
        TypeDeclaration[] types = unit.types;
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                TypeDeclaration type = types[i];
                if ((this.matchSet.matchContainer & 1) != 0 || (this.matchSet.matchContainer & 2) != 0 || (this.matchSet.matchContainer & 8) != 0) {
                    this.matchSet.checkMatching(type);
                }
                this.parseBodies(type, unit);
                ++i;
            }
        }
    }

    private void parseBodies(TypeDeclaration type, CompilationUnitDeclaration unit) {
        MemberTypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                FieldDeclaration field = fields[i];
                if (field instanceof Initializer) {
                    this.parse((Initializer)field, type, unit);
                }
                field.traverse((IAbstractSyntaxTreeVisitor)this.localDeclarationVisitor, null);
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            while (i < methods.length) {
                AbstractMethodDeclaration method = methods[i];
                if (method.sourceStart >= type.bodyStart) {
                    if (method instanceof MethodDeclaration) {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)method;
                        this.parse(methodDeclaration, unit);
                        methodDeclaration.traverse((IAbstractSyntaxTreeVisitor)this.localDeclarationVisitor, (ClassScope)null);
                    } else if (method instanceof ConstructorDeclaration) {
                        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)method;
                        this.parse(constructorDeclaration, unit);
                        constructorDeclaration.traverse((IAbstractSyntaxTreeVisitor)this.localDeclarationVisitor, (ClassScope)null);
                    }
                } else if (method.isDefaultConstructor()) {
                    method.parseStatements(this, unit);
                }
                ++i;
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                MemberTypeDeclaration memberType = memberTypes[i];
                this.parseBodies(memberType, unit);
                memberType.traverse((IAbstractSyntaxTreeVisitor)this.localDeclarationVisitor, (ClassScope)null);
                ++i;
            }
        }
    }

    public class LocalDeclarationVisitor
    extends AbstractSyntaxTreeVisitorAdapter {
        public boolean visit(AnonymousLocalTypeDeclaration anonymousTypeDeclaration, BlockScope scope) {
            if ((MatchLocatorParser.this.matchSet.matchContainer & 8) != 0) {
                MatchLocatorParser.this.matchSet.checkMatching(anonymousTypeDeclaration);
            }
            return true;
        }

        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            if ((MatchLocatorParser.this.matchSet.matchContainer & 2) != 0) {
                MatchLocatorParser.this.matchSet.checkMatching(constructorDeclaration);
            }
            return (constructorDeclaration.bits & 2) != 0;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            if ((MatchLocatorParser.this.matchSet.matchContainer & 2) != 0) {
                MatchLocatorParser.this.matchSet.checkMatching(fieldDeclaration);
            }
            return (fieldDeclaration.bits & 2) != 0;
        }

        public boolean visit(Initializer initializer, MethodScope scope) {
            if ((MatchLocatorParser.this.matchSet.matchContainer & 2) != 0) {
                MatchLocatorParser.this.matchSet.checkMatching(initializer);
            }
            return (initializer.bits & 2) != 0;
        }

        public boolean visit(LocalTypeDeclaration localTypeDeclaration, BlockScope scope) {
            if ((MatchLocatorParser.this.matchSet.matchContainer & 8) != 0) {
                MatchLocatorParser.this.matchSet.checkMatching(localTypeDeclaration);
            }
            return true;
        }

        public boolean visit(MemberTypeDeclaration memberTypeDeclaration, ClassScope scope) {
            if ((MatchLocatorParser.this.matchSet.matchContainer & 2) != 0) {
                MatchLocatorParser.this.matchSet.checkMatching(memberTypeDeclaration);
            }
            return true;
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            if ((MatchLocatorParser.this.matchSet.matchContainer & 2) != 0) {
                MatchLocatorParser.this.matchSet.checkMatching(methodDeclaration);
            }
            return (methodDeclaration.bits & 2) != 0;
        }
    }
}

