/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.internal.core.index.IDocument;
import org.eclipse.jdt.internal.core.index.IIndexer;
import org.eclipse.jdt.internal.core.index.IIndexerOutput;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;

public abstract class AbstractIndexer
implements IIndexer,
IIndexConstants,
IJavaSearchConstants {
    IIndexerOutput output;

    public void addClassDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[] superclass, char[][] superinterfaces) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(packageName, enclosingTypeNames, name, true));
        this.addSuperTypeReference(modifiers, packageName, name, enclosingTypeNames, 'C', superclass, 'C');
        if (superinterfaces != null) {
            int i = 0;
            int max = superinterfaces.length;
            while (i < max) {
                this.addSuperTypeReference(modifiers, packageName, name, enclosingTypeNames, 'C', superinterfaces[i], 'I');
                ++i;
            }
        }
    }

    public void addConstructorDeclaration(char[] typeName, char[][] parameterTypes, char[][] exceptionTypes) {
        int numberOfArguments = 0;
        if (parameterTypes != null) {
            numberOfArguments = parameterTypes.length;
            int i = 0;
            while (i < numberOfArguments) {
                this.addTypeReference(parameterTypes[i]);
                ++i;
            }
        }
        char[] countChars = numberOfArguments < 10 ? IIndexConstants.COUNTS[numberOfArguments] : String.valueOf(numberOfArguments).toCharArray();
        this.output.addRef(AbstractIndexer.concat(IIndexConstants.CONSTRUCTOR_DECL, CharOperation.lastSegment(typeName, '.'), countChars, '/'));
        if (exceptionTypes != null) {
            int i = 0;
            int max = exceptionTypes.length;
            while (i < max) {
                this.addTypeReference(exceptionTypes[i]);
                ++i;
            }
        }
    }

    public void addConstructorReference(char[] typeName, int argCount) {
        char[] countChars = argCount < 10 ? IIndexConstants.COUNTS[argCount] : String.valueOf(argCount).toCharArray();
        this.output.addRef(AbstractIndexer.concat(IIndexConstants.CONSTRUCTOR_REF, CharOperation.lastSegment(typeName, '.'), countChars, '/'));
    }

    public void addFieldDeclaration(char[] typeName, char[] fieldName) {
        this.output.addRef(CharOperation.concat(IIndexConstants.FIELD_DECL, fieldName));
        this.addTypeReference(typeName);
    }

    public void addFieldReference(char[] fieldName) {
        this.output.addRef(CharOperation.concat(IIndexConstants.FIELD_REF, fieldName));
    }

    public void addInterfaceDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[][] superinterfaces) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(packageName, enclosingTypeNames, name, false));
        if (superinterfaces != null) {
            int i = 0;
            int max = superinterfaces.length;
            while (i < max) {
                this.addSuperTypeReference(modifiers, packageName, name, enclosingTypeNames, 'I', superinterfaces[i], 'I');
                ++i;
            }
        }
    }

    public void addMethodDeclaration(char[] methodName, char[][] parameterTypes, char[] returnType, char[][] exceptionTypes) {
        int numberOfArguments = 0;
        if (parameterTypes != null) {
            numberOfArguments = parameterTypes.length;
            int i = 0;
            while (i < numberOfArguments) {
                this.addTypeReference(parameterTypes[i]);
                ++i;
            }
        }
        char[] countChars = numberOfArguments < 10 ? IIndexConstants.COUNTS[numberOfArguments] : String.valueOf(numberOfArguments).toCharArray();
        this.output.addRef(AbstractIndexer.concat(IIndexConstants.METHOD_DECL, methodName, countChars, '/'));
        if (exceptionTypes != null) {
            int i = 0;
            int max = exceptionTypes.length;
            while (i < max) {
                this.addTypeReference(exceptionTypes[i]);
                ++i;
            }
        }
        if (returnType != null) {
            this.addTypeReference(returnType);
        }
    }

    public void addMethodReference(char[] methodName, int argCount) {
        char[] countChars = argCount < 10 ? IIndexConstants.COUNTS[argCount] : String.valueOf(argCount).toCharArray();
        this.output.addRef(AbstractIndexer.concat(IIndexConstants.METHOD_REF, methodName, countChars, '/'));
    }

    public void addNameReference(char[] name) {
        this.output.addRef(CharOperation.concat(IIndexConstants.REF, name));
    }

    private void addSuperTypeReference(int modifiers, char[] packageName, char[] typeName, char[][] enclosingTypeNames, char classOrInterface, char[] superTypeName, char superClassOrInterface) {
        char[] superQualification;
        if (superTypeName == null) {
            superTypeName = IIndexConstants.OBJECT;
        }
        char[] enclosingTypeName = CharOperation.concatWith(enclosingTypeNames, '$');
        char[] typeSimpleName = CharOperation.lastSegment(typeName, '.');
        char[] superTypeSimpleName = CharOperation.lastSegment(superTypeName, '.');
        if (superTypeSimpleName == superTypeName) {
            superQualification = null;
        } else {
            int length = superTypeName.length - superTypeSimpleName.length - 1;
            superQualification = new char[length];
            System.arraycopy(superTypeName, 0, superQualification, 0, length);
        }
        char[] superTypeSourceName = CharOperation.lastSegment(superTypeSimpleName, '$');
        if (superTypeSourceName != superTypeSimpleName) {
            int start = superQualification == null ? 0 : superQualification.length + 1;
            int prefixLength = superTypeSimpleName.length - superTypeSourceName.length;
            char[] mangledQualification = new char[start + prefixLength];
            if (superQualification != null) {
                System.arraycopy(superQualification, 0, mangledQualification, 0, start - 1);
                mangledQualification[start - 1] = 46;
            }
            System.arraycopy(superTypeSimpleName, 0, mangledQualification, start, prefixLength);
            superQualification = mangledQualification;
            superTypeSimpleName = superTypeSourceName;
        }
        this.output.addRef(AbstractIndexer.concat(IIndexConstants.SUPER_REF, superTypeSimpleName, superQualification, superClassOrInterface, typeSimpleName, enclosingTypeName, packageName, classOrInterface, (char)modifiers, '/'));
    }

    public void addTypeReference(char[] typeName) {
        this.output.addRef(CharOperation.concat(IIndexConstants.TYPE_REF, CharOperation.lastSegment(typeName, '.')));
    }

    public static final char[] bestConstructorDeclarationPrefix(char[] typeName, int arity, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || typeName == null) {
            return IIndexConstants.CONSTRUCTOR_DECL;
        }
        switch (matchMode) {
            case 0: {
                if (arity >= 0) {
                    char[] countChars = arity < 10 ? IIndexConstants.COUNTS[arity] : String.valueOf(arity).toCharArray();
                    return AbstractIndexer.concat(IIndexConstants.CONSTRUCTOR_DECL, typeName, countChars, '/');
                }
            }
            case 1: {
                return CharOperation.concat(IIndexConstants.CONSTRUCTOR_DECL, typeName);
            }
            case 2: {
                int starPos = CharOperation.indexOf('*', typeName);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat(IIndexConstants.CONSTRUCTOR_DECL, typeName);
                    }
                    default: {
                        int refLength = IIndexConstants.CONSTRUCTOR_DECL.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(IIndexConstants.CONSTRUCTOR_DECL, 0, result, 0, refLength);
                        System.arraycopy(typeName, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return IIndexConstants.CONSTRUCTOR_DECL;
    }

    public static final char[] bestConstructorReferencePrefix(char[] typeName, int arity, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || typeName == null) {
            return IIndexConstants.CONSTRUCTOR_REF;
        }
        switch (matchMode) {
            case 0: {
                if (arity >= 0) {
                    char[] countChars = arity < 10 ? IIndexConstants.COUNTS[arity] : String.valueOf(arity).toCharArray();
                    return AbstractIndexer.concat(IIndexConstants.CONSTRUCTOR_REF, typeName, countChars, '/');
                }
            }
            case 1: {
                return CharOperation.concat(IIndexConstants.CONSTRUCTOR_REF, typeName);
            }
            case 2: {
                int starPos = CharOperation.indexOf('*', typeName);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat(IIndexConstants.CONSTRUCTOR_REF, typeName);
                    }
                    default: {
                        int refLength = IIndexConstants.CONSTRUCTOR_REF.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(IIndexConstants.CONSTRUCTOR_REF, 0, result, 0, refLength);
                        System.arraycopy(typeName, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return IIndexConstants.CONSTRUCTOR_REF;
    }

    public static final char[] bestFieldDeclarationPrefix(char[] name, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || name == null) {
            return IIndexConstants.FIELD_DECL;
        }
        switch (matchMode) {
            case 0: 
            case 1: {
                return CharOperation.concat(IIndexConstants.FIELD_DECL, name);
            }
            case 2: {
                int starPos = CharOperation.indexOf('*', name);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat(IIndexConstants.FIELD_DECL, name);
                    }
                    default: {
                        int refLength = IIndexConstants.FIELD_DECL.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(IIndexConstants.FIELD_DECL, 0, result, 0, refLength);
                        System.arraycopy(name, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return IIndexConstants.FIELD_DECL;
    }

    public static final char[] bestMethodDeclarationPrefix(char[] selector, int arity, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || selector == null) {
            return IIndexConstants.METHOD_DECL;
        }
        switch (matchMode) {
            case 0: {
                if (arity >= 0) {
                    char[] countChars = arity < 10 ? IIndexConstants.COUNTS[arity] : String.valueOf(arity).toCharArray();
                    return AbstractIndexer.concat(IIndexConstants.METHOD_DECL, selector, countChars, '/');
                }
            }
            case 1: {
                return CharOperation.concat(IIndexConstants.METHOD_DECL, selector);
            }
            case 2: {
                int starPos = CharOperation.indexOf('*', selector);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat(IIndexConstants.METHOD_DECL, selector);
                    }
                    default: {
                        int refLength = IIndexConstants.METHOD_DECL.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(IIndexConstants.METHOD_DECL, 0, result, 0, refLength);
                        System.arraycopy(selector, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return IIndexConstants.METHOD_DECL;
    }

    public static final char[] bestMethodReferencePrefix(char[] selector, int arity, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || selector == null) {
            return IIndexConstants.METHOD_REF;
        }
        switch (matchMode) {
            case 0: {
                if (arity >= 0) {
                    char[] countChars = arity < 10 ? IIndexConstants.COUNTS[arity] : String.valueOf(arity).toCharArray();
                    return AbstractIndexer.concat(IIndexConstants.METHOD_REF, selector, countChars, '/');
                }
            }
            case 1: {
                return CharOperation.concat(IIndexConstants.METHOD_REF, selector);
            }
            case 2: {
                int starPos = CharOperation.indexOf('*', selector);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat(IIndexConstants.METHOD_REF, selector);
                    }
                    default: {
                        int refLength = IIndexConstants.METHOD_REF.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(IIndexConstants.METHOD_REF, 0, result, 0, refLength);
                        System.arraycopy(selector, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return IIndexConstants.METHOD_REF;
    }

    public static final char[] bestReferencePrefix(char[] tag, char[] name, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive || name == null) {
            return tag;
        }
        switch (matchMode) {
            case 0: 
            case 1: {
                return CharOperation.concat(tag, name);
            }
            case 2: {
                int starPos = CharOperation.indexOf('*', name);
                switch (starPos) {
                    case -1: {
                        return CharOperation.concat(tag, name);
                    }
                    default: {
                        int refLength = tag.length;
                        char[] result = new char[refLength + starPos];
                        System.arraycopy(tag, 0, result, 0, refLength);
                        System.arraycopy(name, 0, result, refLength, starPos);
                        return result;
                    }
                    case 0: 
                }
            }
        }
        return tag;
    }

    public static final char[] bestTypeDeclarationPrefix(char[] packageName, char[] typeName, char classOrInterface, int matchMode, boolean isCaseSensitive) {
        if (!isCaseSensitive) {
            packageName = null;
            typeName = null;
        }
        switch (classOrInterface) {
            default: {
                return IIndexConstants.TYPE_DECL;
            }
            case 'C': {
                if (packageName != null) break;
                return IIndexConstants.CLASS_DECL;
            }
            case 'I': {
                if (packageName != null) break;
                return IIndexConstants.INTERFACE_DECL;
            }
        }
        block4 : switch (matchMode) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (typeName == null) break;
                int starPos = CharOperation.indexOf('*', typeName);
                switch (starPos) {
                    case -1: {
                        break block4;
                    }
                    case 0: {
                        typeName = null;
                        break block4;
                    }
                }
                typeName = CharOperation.subarray(typeName, 0, starPos);
            }
        }
        int packageLength = packageName.length;
        int typeLength = typeName == null ? 0 : typeName.length;
        char[] result = new char[9 + packageLength + typeLength + 3];
        int pos = 9;
        System.arraycopy(IIndexConstants.TYPE_DECL, 0, result, 0, 9);
        result[pos++] = classOrInterface;
        result[pos++] = 47;
        System.arraycopy(packageName, 0, result, pos, packageLength);
        pos += packageLength;
        result[pos++] = 47;
        if (typeLength > 0) {
            System.arraycopy(typeName, 0, result, pos, typeName.length);
        }
        return result;
    }

    protected static final char[] concat(char[] firstWithSeparator, char[] second, char[] third, char[] fourth, char[] fifth, char separator) {
        int length1 = firstWithSeparator.length;
        int length2 = second == null ? 0 : second.length;
        int length3 = third == null ? 0 : third.length;
        int length4 = fourth == null ? 0 : fourth.length;
        int length5 = fifth == null ? 0 : fifth.length;
        char[] result = new char[length1 + length2 + length3 + length4 + length5 + 3];
        System.arraycopy(firstWithSeparator, 0, result, 0, length1);
        if (second != null) {
            System.arraycopy(second, 0, result, length1, length2);
        }
        int pos = length1 + length2;
        result[pos] = separator;
        if (third != null) {
            System.arraycopy(third, 0, result, pos + 1, length3);
        }
        result[pos += length3 + 1] = separator;
        if (fourth != null) {
            System.arraycopy(fourth, 0, result, pos + 1, length4);
        }
        result[pos += length4 + 1] = separator;
        if (fifth != null) {
            System.arraycopy(fifth, 0, result, pos + 1, length5);
        }
        return result;
    }

    protected static final char[] concat(char[] firstWithSeparator, char[] second, char[] third, char separator) {
        int length1 = firstWithSeparator.length;
        int length2 = second == null ? 0 : second.length;
        int length3 = third == null ? 0 : third.length;
        char[] result = new char[length1 + length2 + length3 + 1];
        System.arraycopy(firstWithSeparator, 0, result, 0, length1);
        if (second != null) {
            System.arraycopy(second, 0, result, length1, length2);
        }
        result[length1 + length2] = separator;
        if (third != null) {
            System.arraycopy(third, 0, result, length1 + length2 + 1, length3);
        }
        return result;
    }

    protected static final char[] concat(char[] firstWithSeparator, char[] second, char[] third, char charAfterThird, char[] fourth, char[] fifth, char[] sixth, char charAfterSixth, char last, char separator) {
        int length1 = firstWithSeparator.length;
        int length2 = second == null ? 0 : second.length;
        int length3 = third == null ? 0 : third.length;
        int length4 = fourth == null ? 0 : fourth.length;
        int length5 = fifth == null ? 0 : fifth.length;
        int length6 = sixth == null ? 0 : sixth.length;
        char[] result = new char[length1 + length2 + length3 + length4 + length5 + length6 + 9];
        System.arraycopy(firstWithSeparator, 0, result, 0, length1);
        if (second != null) {
            System.arraycopy(second, 0, result, length1, length2);
        }
        int pos = length1 + length2;
        result[pos] = separator;
        if (third != null) {
            System.arraycopy(third, 0, result, pos + 1, length3);
        }
        result[pos += length3 + 1] = separator;
        result[++pos] = charAfterThird;
        result[++pos] = separator;
        if (fourth != null) {
            System.arraycopy(fourth, 0, result, pos + 1, length4);
        }
        result[pos += length4 + 1] = separator;
        if (fifth != null) {
            System.arraycopy(fifth, 0, result, pos + 1, length5);
        }
        result[pos += length5 + 1] = separator;
        if (sixth != null) {
            System.arraycopy(sixth, 0, result, pos + 1, length6);
        }
        result[pos += length6 + 1] = separator;
        result[++pos] = charAfterSixth;
        result[++pos] = last;
        return result;
    }

    protected static final char[] encodeTypeEntry(char[] packageName, char[][] enclosingTypeNames, char[] typeName, boolean isClass) {
        int packageLength = packageName == null ? 0 : packageName.length;
        int enclosingTypeNamesLength = 0;
        if (enclosingTypeNames != null) {
            int i = 0;
            int length = enclosingTypeNames.length;
            while (i < length) {
                enclosingTypeNamesLength += enclosingTypeNames[i].length + 1;
                ++i;
            }
        }
        char[] result = new char[9 + packageLength + typeName.length + enclosingTypeNamesLength + 4];
        int pos = 9;
        System.arraycopy(IIndexConstants.TYPE_DECL, 0, result, 0, 9);
        result[pos++] = isClass ? 67 : 73;
        result[pos++] = 47;
        if (packageName != null) {
            System.arraycopy(packageName, 0, result, pos, packageLength);
            pos += packageLength;
        }
        result[pos++] = 47;
        System.arraycopy(typeName, 0, result, pos, typeName.length);
        pos += typeName.length;
        result[pos++] = 47;
        if (enclosingTypeNames != null) {
            int i = 0;
            int length = enclosingTypeNames.length;
            while (i < length) {
                int enclosingTypeNameLength = enclosingTypeNames[i].length;
                System.arraycopy(enclosingTypeNames[i], 0, result, pos, enclosingTypeNameLength);
                pos += enclosingTypeNameLength;
                result[pos++] = 47;
                ++i;
            }
        }
        return result;
    }

    public abstract String[] getFileTypes();

    public void index(IDocument document, IIndexerOutput output) throws IOException {
        this.output = output;
        if (this.shouldIndex(document)) {
            this.indexFile(document);
        }
    }

    protected abstract void indexFile(IDocument var1) throws IOException;

    public boolean shouldIndex(IDocument document) {
        String type = document.getType();
        String[] supportedTypes = this.getFileTypes();
        int i = 0;
        while (i < supportedTypes.length) {
            if (supportedTypes[i].equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

