/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.core.index.IDocument;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.index.IIndexer;
import org.eclipse.jdt.internal.core.index.IQueryResult;
import org.eclipse.jdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.jdt.internal.core.index.impl.BlocksIndexOutput;
import org.eclipse.jdt.internal.core.index.impl.InMemoryIndex;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.index.impl.IndexerOutput;
import org.eclipse.jdt.internal.core.index.impl.Int;
import org.eclipse.jdt.internal.core.index.impl.MergeFactory;
import org.eclipse.jdt.internal.core.index.impl.SimpleIndexInput;

public class Index
implements IIndex {
    public static final int MAX_FOOTPRINT = 10000000;
    protected InMemoryIndex addsIndex;
    protected IndexInput addsIndexInput;
    protected int state = 1;
    protected Map removedInAdds;
    protected Map removedInOld;
    protected static final int CAN_MERGE = 0;
    protected static final int MERGED = 1;
    private File indexFile;
    public String toString;

    public Index(File indexDirectory, boolean reuseExistingFile) throws IOException {
        this(indexDirectory, ".index", reuseExistingFile);
    }

    public Index(File indexDirectory, String indexName, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexDirectory, indexName);
        this.initialize(reuseExistingFile);
    }

    public Index(String indexName, boolean reuseExistingFile) throws IOException {
        this(indexName, null, reuseExistingFile);
    }

    public Index(String indexName, String toString, boolean reuseExistingFile) throws IOException {
        this.indexFile = new File(indexName);
        this.toString = toString;
        this.initialize(reuseExistingFile);
    }

    public void add(IDocument document, IIndexer indexer) throws IOException {
        IndexedFile indexedFile;
        if (this.timeToMerge()) {
            this.merge();
        }
        if ((indexedFile = this.addsIndex.getIndexedFile(document.getName())) != null) {
            this.remove(indexedFile, 0);
        }
        IndexerOutput output = new IndexerOutput(this.addsIndex);
        indexer.index(document, output);
        this.state = 0;
    }

    protected boolean canMerge() {
        return this.state == 0;
    }

    public void empty() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            if (!this.indexFile.exists()) {
                mainIndex.save(mainIndexOutput);
            }
        }
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public int getNumDocuments() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumFiles();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    public int getNumWords() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumWords();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPath(int documentNumber) throws IOException {
        String string;
        BlocksIndexInput input;
        block4: {
            String string2;
            block3: {
                input = new BlocksIndexInput(this.indexFile);
                try {
                    ((IndexInput)input).open();
                    IndexedFile file = ((IndexInput)input).getIndexedFile(documentNumber);
                    if (file == null) {
                        string2 = null;
                        Object var4_6 = null;
                        break block3;
                    }
                    string = file.getPath();
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    ((IndexInput)input).close();
                    throw throwable;
                }
            }
            ((IndexInput)input).close();
            return string2;
        }
        Object var4_7 = null;
        ((IndexInput)input).close();
        return string;
    }

    public boolean hasChanged() {
        return this.canMerge();
    }

    public void initialize(boolean reuseExistingFile) throws IOException {
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
        if (reuseExistingFile && this.indexFile.exists()) {
            BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)mainIndexInput).open();
            }
            catch (IOException e) {
                BlocksIndexInput input = mainIndexInput;
                try {
                    input.opened = true;
                    input.close();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    input.opened = false;
                    throw throwable;
                }
                Object var5_9 = null;
                input.opened = false;
                this.indexFile.delete();
                mainIndexInput = null;
                throw e;
            }
            ((IndexInput)mainIndexInput).close();
        } else {
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            mainIndex.save(mainIndexOutput);
        }
    }

    protected void merge() throws IOException {
        File tempFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + "TempVA");
        BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
        BlocksIndexOutput tempIndexOutput = new BlocksIndexOutput(tempFile);
        try {
            new MergeFactory(mainIndexInput, this.addsIndexInput, tempIndexOutput, this.removedInOld, this.removedInAdds).merge();
            File mainIndexFile = (File)((IndexInput)mainIndexInput).getSource();
            File tempIndexFile = (File)tempIndexOutput.getDestination();
            mainIndexFile.delete();
            tempIndexFile.renameTo(mainIndexFile);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            throw throwable;
        }
        Object var6_8 = null;
        this.removedInAdds.clear();
        this.removedInOld.clear();
        this.addsIndex.init();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.state = 1;
    }

    public IQueryResult[] query(String word) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).query(word);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public IEntryResult[] queryEntries(char[] prefix) throws IOException {
        IEntryResult[] iEntryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iEntryResultArray = ((IndexInput)input).queryEntriesPrefixedBy(prefix);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iEntryResultArray;
    }

    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).queryInDocumentNames(word);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public IQueryResult[] queryPrefix(char[] prefix) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).queryFilesReferringToPrefix(prefix);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public void remove(String documentName) throws IOException {
        IndexedFile file = this.addsIndex.getIndexedFile(documentName);
        if (file != null) {
            Int lastRemoved = (Int)this.removedInAdds.get(documentName);
            if (lastRemoved != null) {
                int fileNum = file.getFileNumber();
                if (lastRemoved.value < fileNum) {
                    lastRemoved.value = fileNum;
                }
            } else {
                this.removedInAdds.put(documentName, new Int(file.getFileNumber()));
            }
        } else {
            this.removedInOld.put(documentName, new Int(1));
        }
        this.state = 0;
    }

    protected void remove(IndexedFile file, int index) throws IOException {
        String name = file.getPath();
        if (index == 0) {
            Int lastRemoved = (Int)this.removedInAdds.get(name);
            if (lastRemoved != null) {
                if (lastRemoved.value < file.getFileNumber()) {
                    lastRemoved.value = file.getFileNumber();
                }
            } else {
                this.removedInAdds.put(name, new Int(file.getFileNumber()));
            }
        } else if (index == 1) {
            this.removedInOld.put(name, new Int(1));
        } else {
            throw new Error();
        }
        this.state = 0;
    }

    public void save() throws IOException {
        if (this.canMerge()) {
            this.merge();
        }
    }

    protected boolean timeToMerge() {
        return this.addsIndex.getFootprint() >= 10000000L;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            str = super.toString();
        }
        str = String.valueOf(str) + "(length: " + this.getIndexFile().length() + ")";
        return str;
    }
}

