/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Util;

public class CreateCompilationUnitOperation
extends JavaModelOperation {
    protected String fName;
    protected String fSource = null;

    public CreateCompilationUnitOperation(IPackageFragment parentElement, String name, String source, boolean force) {
        super(null, new IJavaElement[]{parentElement}, force);
        this.fName = name;
        this.fSource = source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block14: {
            block12: {
                try {
                    block13: {
                        this.beginTask(Util.bind("operation.createUnitProgress"), 2);
                        JavaElementDelta delta = this.newJavaElementDelta();
                        ICompilationUnit unit = this.getCompilationUnit();
                        IPackageFragment pkg = (IPackageFragment)this.getParentElement();
                        IContainer folder = (IContainer)pkg.getResource();
                        this.worked(1);
                        IFile compilationUnitFile = folder.getFile((IPath)new Path(this.fName));
                        if (compilationUnitFile.exists()) {
                            if (!this.fForce) throw new JavaModelException(new JavaModelStatus(977, Util.bind("status.nameCollision", compilationUnitFile.getFullPath().toString())));
                            IBuffer buffer = unit.getBuffer();
                            if (buffer == null) {
                                Object var9_9 = null;
                                break block12;
                            }
                            buffer.setContents(this.fSource);
                            unit.save((IProgressMonitor)new NullProgressMonitor(), false);
                            this.fResultElements = new IJavaElement[]{unit};
                            if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                                int i = 0;
                                while (true) {
                                    if (i >= this.fResultElements.length) {
                                        this.addDelta(delta);
                                        break;
                                    }
                                    delta.changed(this.fResultElements[i], 1);
                                    ++i;
                                }
                            }
                        } else {
                            try {
                                String encoding = unit.getJavaProject().getOption("org.eclipse.jdt.core.encoding", true);
                                ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? this.fSource.getBytes() : this.fSource.getBytes(encoding));
                                this.createFile(folder, unit.getElementName(), stream, false);
                                this.fResultElements = new IJavaElement[]{unit};
                                if (Util.isExcluded(unit) || !unit.getParent().exists()) break block13;
                                int i = 0;
                                while (true) {
                                    if (i >= this.fResultElements.length) {
                                        this.addDelta(delta);
                                        break;
                                    }
                                    delta.added(this.fResultElements[i]);
                                    ++i;
                                }
                            }
                            catch (IOException e) {
                                throw new JavaModelException(e, 985);
                            }
                        }
                    }
                    this.worked(1);
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.done();
                    throw throwable;
                }
            }
            this.done();
            return;
        }
        Object var9_11 = null;
        this.done();
    }

    protected ICompilationUnit getCompilationUnit() {
        return ((IPackageFragment)this.getParentElement()).getCompilationUnit(this.fName);
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        if (JavaConventions.validateCompilationUnitName(this.fName).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fName);
        }
        if (this.fSource == null) {
            return new JavaModelStatus(984);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

