/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.WorkingCopy;

public class CommitWorkingCopyOperation
extends JavaModelOperation {
    public CommitWorkingCopyOperation(ICompilationUnit element, boolean force) {
        super(new IJavaElement[]{element}, force);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block13: {
            block12: {
                block11: {
                    try {
                        this.beginTask(Util.bind("workingCopy.commit"), 2);
                        WorkingCopy copy = (WorkingCopy)this.getCompilationUnit();
                        ICompilationUnit original = (ICompilationUnit)copy.getOriginalElement();
                        if (!original.isOpen()) {
                            original.open(null);
                        }
                        JavaElementDeltaBuilder deltaBuilder = Util.isExcluded(original) ? null : new JavaElementDeltaBuilder(original);
                        IBuffer originalBuffer = original.getBuffer();
                        if (originalBuffer == null) {
                            Object var10_5 = null;
                            break block11;
                        }
                        char[] originalContents = originalBuffer.getCharacters();
                        boolean hasSaved = false;
                        try {
                            IBuffer copyBuffer = copy.getBuffer();
                            if (copyBuffer == null) {
                                Object var8_12 = null;
                                if (!hasSaved) {
                                    originalBuffer.setContents(originalContents);
                                }
                                break block12;
                            }
                            originalBuffer.setContents(copyBuffer.getCharacters());
                            original.save(this.fMonitor, this.fForce);
                            this.setAttribute("hasModifiedResource", "true");
                            hasSaved = true;
                        }
                        catch (Throwable throwable) {
                            Object var8_13 = null;
                            if (hasSaved) throw throwable;
                            originalBuffer.setContents(originalContents);
                            throw throwable;
                        }
                        Object var8_14 = null;
                        if (!hasSaved) {
                            originalBuffer.setContents(originalContents);
                        }
                        copy.updateTimeStamp((CompilationUnit)original);
                        copy.makeConsistent(this);
                        this.worked(1);
                        if (deltaBuilder != null) {
                            deltaBuilder.buildDeltas();
                            if (deltaBuilder.delta != null) {
                                this.addDelta(deltaBuilder.delta);
                            }
                        }
                        this.worked(1);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var10_7 = null;
                        this.done();
                        throw throwable;
                    }
                }
                this.done();
                return;
            }
            Object var10_6 = null;
            this.done();
            return;
        }
        Object var10_8 = null;
        this.done();
    }

    protected ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getElementToProcess();
    }

    public IJavaModelStatus verify() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (!cu.isWorkingCopy()) {
            return new JavaModelStatus(967, cu);
        }
        ICompilationUnit original = (ICompilationUnit)cu.getOriginalElement();
        IResource resource = original.getResource();
        if (!cu.isBasedOn(resource) && !this.fForce) {
            return new JavaModelStatus(981);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

