/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities {
    public boolean noWarn = false;
    public PrintWriter out;
    public PrintWriter err;
    public boolean systemExitWhenFinished = true;
    public boolean proceedOnError = false;
    public boolean verbose = false;
    public boolean produceRefInfo = false;
    public boolean timer = false;
    public boolean showProgress = false;
    public long time = 0L;
    public long lineCount;
    public boolean generatePackagesStructure;
    public Map options;
    public String[] filenames;
    public String[] encodings;
    public String[] classpaths;
    public String destinationPath;
    public String log;
    public int repetitions;
    public int globalProblemsCount;
    public int globalErrorsCount;
    public int globalWarningsCount;
    public int exportedClassFilesCounter;
    public static final char[] CLASS_FILE_EXTENSION = ".class".toCharArray();
    public static final char[] DOUBLE_QUOTES = "''".toCharArray();
    public static final char[] SINGLE_QUOTE = "'".toCharArray();
    public static ResourceBundle bundle;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public boolean proceed = true;

    static {
        Main.relocalize();
    }

    public Main(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished) {
        this.out = outWriter;
        this.err = errWriter;
        this.systemExitWhenFinished = systemExitWhenFinished;
        this.exportedClassFilesCounter = 0;
        this.options = Main.getDefaultOptions();
    }

    public boolean compile(String[] argv) {
        try {
            try {
                this.configure(argv);
                if (this.proceed) {
                    if (this.showProgress) {
                        this.out.println(Main.bind("progress.compiling"));
                    }
                    int i = 0;
                    while (i < this.repetitions) {
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.lineCount = 0L;
                        if (this.repetitions > 1) {
                            this.out.flush();
                            this.out.println(Main.bind("compile.repetition", String.valueOf(i + 1), String.valueOf(this.repetitions)));
                        }
                        long startTime = System.currentTimeMillis();
                        this.performCompilation();
                        if (this.timer) {
                            this.time = System.currentTimeMillis() - startTime;
                            if (this.lineCount != 0L) {
                                this.out.println(Main.bind("compile.instantTime", new String[]{String.valueOf(this.lineCount), String.valueOf(this.time), String.valueOf((double)((int)((double)this.lineCount * 10000.0 / (double)this.time)) / 10.0)}));
                            } else {
                                this.out.println(Main.bind("compile.totalTime", String.valueOf(this.time)));
                            }
                        }
                        if (this.globalProblemsCount > 0) {
                            if (this.globalProblemsCount == 1) {
                                this.err.print(Main.bind("compile.oneProblem"));
                            } else {
                                this.err.print(Main.bind("compile.severalProblems", String.valueOf(this.globalProblemsCount)));
                            }
                            this.err.print(" (");
                            if (this.globalErrorsCount > 0) {
                                if (this.globalErrorsCount == 1) {
                                    this.err.print(Main.bind("compile.oneError"));
                                } else {
                                    this.err.print(Main.bind("compile.severalErrors", String.valueOf(this.globalErrorsCount)));
                                }
                            }
                            if (this.globalWarningsCount > 0) {
                                if (this.globalErrorsCount > 0) {
                                    this.err.print(", ");
                                }
                                if (this.globalWarningsCount == 1) {
                                    this.err.print(Main.bind("compile.oneWarning"));
                                } else {
                                    this.err.print(Main.bind("compile.severalWarnings", String.valueOf(this.globalWarningsCount)));
                                }
                            }
                            this.err.println(")");
                        }
                        if (this.exportedClassFilesCounter != 0 && (this.showProgress || this.timer || this.verbose)) {
                            if (this.exportedClassFilesCounter == 1) {
                                this.out.println(Main.bind("compile.oneClassFileGenerated"));
                            } else {
                                this.out.println(Main.bind("compile.severalClassFilesGenerated", String.valueOf(this.exportedClassFilesCounter)));
                            }
                        }
                        ++i;
                    }
                    if (this.showProgress) {
                        this.out.println();
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.out.flush();
                    this.err.flush();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (InvalidInputException e) {
                this.err.println(e.getMessage());
                this.err.println("------------------------");
                this.printUsage();
                if (this.systemExitWhenFinished) {
                    System.exit(-1);
                }
                Object var5_6 = null;
                this.out.flush();
                this.err.flush();
                if (this.log != null) {
                    this.err.close();
                }
                return false;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable throwable) {
                if (this.systemExitWhenFinished) {
                    this.out.flush();
                    this.err.flush();
                    if (this.log != null) {
                        this.err.close();
                    }
                    System.exit(-1);
                }
                Object var5_7 = null;
                this.out.flush();
                this.err.flush();
                if (this.log != null) {
                    this.err.close();
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.err.close();
            }
            throw throwable;
        }
        Object var5_9 = null;
        this.out.flush();
        this.err.flush();
        if (this.log != null) {
            this.err.close();
        }
        return this.globalErrorsCount == 0;
    }

    public static boolean compile(String commandLine) {
        return Main.compile(commandLine, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String commandLine, PrintWriter outWriter, PrintWriter errWriter) {
        return new Main(outWriter, errWriter, false).compile(Main.tokenize(commandLine));
    }

    public static String[] tokenize(String commandLine) {
        int count = 0;
        String[] arguments = new String[10];
        StringTokenizer tokenizer = new StringTokenizer(commandLine, " \"", true);
        String token = "";
        boolean insideQuotes = false;
        boolean startNewToken = true;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.equals(" ")) {
                if (insideQuotes) {
                    int n = count - 1;
                    arguments[n] = String.valueOf(arguments[n]) + token;
                    startNewToken = false;
                    continue;
                }
                startNewToken = true;
                continue;
            }
            if (token.equals("\"")) {
                if (!insideQuotes && startNewToken) {
                    if (count == arguments.length) {
                        String[] stringArray = arguments;
                        arguments = new String[count * 2];
                        System.arraycopy(stringArray, 0, arguments, 0, count);
                    }
                    arguments[count++] = "";
                }
                insideQuotes = !insideQuotes;
                startNewToken = false;
                continue;
            }
            if (insideQuotes) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else if (token.length() > 0 && !startNewToken) {
                int n = count - 1;
                arguments[n] = String.valueOf(arguments[n]) + token;
            } else {
                String trimmedToken;
                if (count == arguments.length) {
                    String[] stringArray = arguments;
                    arguments = new String[count * 2];
                    System.arraycopy(stringArray, 0, arguments, 0, count);
                }
                if ((trimmedToken = token.trim()).length() != 0) {
                    arguments[count++] = trimmedToken;
                }
            }
            startNewToken = false;
        }
        String[] stringArray = arguments;
        arguments = new String[count];
        System.arraycopy(stringArray, 0, arguments, 0, count);
        return arguments;
    }

    public void configure(String[] argv) throws InvalidInputException {
        int i;
        if (argv == null || argv.length == 0) {
            this.printUsage();
            return;
        }
        String[] bootclasspaths = null;
        int DEFAULT_SIZE_CLASSPATH = 4;
        int pathCount = 0;
        int bootclasspathCount = 0;
        int index = -1;
        int filesCount = 0;
        int argCount = argv.length;
        int mode = 0;
        this.repetitions = 0;
        boolean versionIDRequired = false;
        boolean printUsageRequired = false;
        boolean didSpecifyCompliance = false;
        boolean didSpecifyDefaultEncoding = false;
        boolean didSpecifyTarget = false;
        String customEncoding = null;
        String currentArg = "";
        boolean needExpansion = false;
        int i2 = 0;
        while (i2 < argCount) {
            if (argv[i2].startsWith("@")) {
                needExpansion = true;
                break;
            }
            ++i2;
        }
        String[] newCommandLineArgs = null;
        if (needExpansion) {
            newCommandLineArgs = new String[argCount];
            index = 0;
            i = 0;
            while (i < argCount) {
                String[] newArgs = null;
                String arg = argv[i].trim();
                if (arg.startsWith("@")) {
                    try {
                        String line;
                        LineNumberReader reader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(arg.substring(1)), null))));
                        StringBuffer buffer = new StringBuffer();
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line).append(" ");
                        }
                        newArgs = Main.tokenize(buffer.toString());
                    }
                    catch (IOException iOException) {
                        throw new InvalidInputException(Main.bind("configure.invalidexpansionargumentname", arg));
                    }
                }
                if (newArgs != null) {
                    int newCommandLineArgsLength = newCommandLineArgs.length;
                    int newArgsLength = newArgs.length;
                    String[] stringArray = newCommandLineArgs;
                    newCommandLineArgs = new String[newCommandLineArgsLength + newArgsLength - 1];
                    System.arraycopy(stringArray, 0, newCommandLineArgs, 0, index);
                    System.arraycopy(newArgs, 0, newCommandLineArgs, index, newArgsLength);
                    index += newArgsLength;
                } else {
                    newCommandLineArgs[index++] = arg;
                }
                ++i;
            }
            index = -1;
        } else {
            newCommandLineArgs = argv;
            i = 0;
            while (i < argCount) {
                newCommandLineArgs[i] = newCommandLineArgs[i].trim();
                ++i;
            }
        }
        argCount = newCommandLineArgs.length;
        while (++index < argCount) {
            File dir;
            if (customEncoding != null) {
                throw new InvalidInputException(Main.bind("configure.unexpectedCustomEncoding", currentArg, customEncoding));
            }
            currentArg = newCommandLineArgs[index];
            customEncoding = null;
            if (currentArg.endsWith("]")) {
                int encodingStart = currentArg.indexOf(91) + 1;
                int encodingEnd = currentArg.length() - 1;
                if (encodingStart >= 1) {
                    if (encodingStart < encodingEnd) {
                        customEncoding = currentArg.substring(encodingStart, encodingEnd);
                        try {
                            new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), customEncoding);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", customEncoding));
                        }
                    }
                    currentArg = currentArg.substring(0, encodingStart - 1);
                }
            }
            if (currentArg.endsWith(".java")) {
                if (this.filenames == null) {
                    this.filenames = new String[argCount - index];
                    this.encodings = new String[argCount - index];
                } else if (filesCount == this.filenames.length) {
                    int length = this.filenames.length;
                    this.filenames = new String[length + argCount - index];
                    System.arraycopy(this.filenames, 0, this.filenames, 0, length);
                    this.encodings = new String[length + argCount - index];
                    System.arraycopy(this.encodings, 0, this.encodings, 0, length);
                }
                this.filenames[filesCount] = currentArg;
                this.encodings[filesCount++] = customEncoding;
                customEncoding = null;
                mode = 0;
                continue;
            }
            if (currentArg.equals("-log")) {
                if (this.log != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateLog", currentArg));
                }
                mode = 8;
                continue;
            }
            if (currentArg.equals("-repeat")) {
                if (this.repetitions > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateRepeat", currentArg));
                }
                mode = 16;
                continue;
            }
            if (currentArg.equals("-source")) {
                mode = 32;
                continue;
            }
            if (currentArg.equals("-encoding")) {
                mode = 64;
                continue;
            }
            if (currentArg.equals("-1.3")) {
                if (didSpecifyCompliance) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                }
                didSpecifyCompliance = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                mode = 0;
                continue;
            }
            if (currentArg.equals("-1.4")) {
                if (didSpecifyCompliance) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", currentArg));
                }
                didSpecifyCompliance = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                mode = 0;
                continue;
            }
            if (currentArg.equals("-d")) {
                if (this.destinationPath != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateOutputPath", currentArg));
                }
                mode = 2;
                this.generatePackagesStructure = true;
                continue;
            }
            if (currentArg.equals("-classpath") || currentArg.equals("-cp")) {
                if (pathCount == 0) {
                    this.classpaths = new String[DEFAULT_SIZE_CLASSPATH];
                }
                mode = 1;
                continue;
            }
            if (currentArg.equals("-bootclasspath")) {
                if (bootclasspathCount > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateBootClasspath", currentArg));
                }
                bootclasspaths = new String[DEFAULT_SIZE_CLASSPATH];
                mode = 128;
                continue;
            }
            if (currentArg.equals("-progress")) {
                mode = 0;
                this.showProgress = true;
                continue;
            }
            if (currentArg.equals("-proceedOnError")) {
                mode = 0;
                this.proceedOnError = true;
                continue;
            }
            if (currentArg.equals("-time")) {
                mode = 0;
                this.timer = true;
                continue;
            }
            if (currentArg.equals("-version") || currentArg.equals("-v")) {
                versionIDRequired = true;
                continue;
            }
            if ("-deprecation".equals(currentArg)) {
                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                continue;
            }
            if (currentArg.equals("-help")) {
                printUsageRequired = true;
                continue;
            }
            if (currentArg.equals("-noImportError")) {
                mode = 0;
                this.options.put("org.eclipse.jdt.core.compiler.problem.invalidImport", "warning");
                continue;
            }
            if (currentArg.equals("-noExit")) {
                mode = 0;
                this.systemExitWhenFinished = false;
                continue;
            }
            if (currentArg.equals("-verbose")) {
                mode = 0;
                this.verbose = true;
                continue;
            }
            if (currentArg.equals("-referenceInfo")) {
                mode = 0;
                this.produceRefInfo = true;
                continue;
            }
            if (currentArg.startsWith("-g")) {
                mode = 0;
                String debugOption = currentArg;
                int length = currentArg.length();
                if (length == 2) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                    continue;
                }
                if (length > 3) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                    if (length == 7 && debugOption.equals("-g:none")) continue;
                    StringTokenizer tokenizer = new StringTokenizer(debugOption.substring(3, debugOption.length()), ",");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("vars")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            continue;
                        }
                        if (token.equals("lines")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            continue;
                        }
                        if (token.equals("source")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            continue;
                        }
                        throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
                    }
                    continue;
                }
                throw new InvalidInputException(Main.bind("configure.invalidDebugOption", debugOption));
            }
            if (currentArg.startsWith("-nowarn")) {
                Object[] entries = this.options.entrySet().toArray();
                int i3 = 0;
                int max = entries.length;
                while (i3 < max) {
                    Map.Entry entry = (Map.Entry)entries[i3];
                    if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                        this.options.put((String)entry.getKey(), "ignore");
                    }
                    ++i3;
                }
                mode = 0;
                continue;
            }
            if (currentArg.startsWith("-warn")) {
                mode = 0;
                String warningOption = currentArg;
                int length = currentArg.length();
                if (length == 10 && warningOption.equals("-warn:none")) {
                    Object[] entries = this.options.entrySet().toArray();
                    int i4 = 0;
                    int max = entries.length;
                    while (i4 < max) {
                        Map.Entry entry = (Map.Entry)entries[i4];
                        if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                            this.options.put((String)entry.getKey(), "ignore");
                        }
                        ++i4;
                    }
                    continue;
                }
                if (length < 6) {
                    throw new InvalidInputException(Main.bind("configure.invalidWarningConfiguration", warningOption));
                }
                StringTokenizer tokenizer = new StringTokenizer(warningOption.substring(6, warningOption.length()), ",");
                int tokenCounter = 0;
                this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "ignore");
                this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "disabled");
                this.options.put("org.eclipse.jdt.core.compiler.taskTags", "");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    ++tokenCounter;
                    if (token.equals("constructorName")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "warning");
                        continue;
                    }
                    if (token.equals("packageDefaultMethod")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "warning");
                        continue;
                    }
                    if (token.equals("maskedCatchBlock") || token.equals("maskedCatchBlocks")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
                        continue;
                    }
                    if (token.equals("deprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                        continue;
                    }
                    if (token.equals("allDeprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
                        continue;
                    }
                    if (token.equals("unusedLocal") || token.equals("unusedLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "warning");
                        continue;
                    }
                    if (token.equals("unusedArgument") || token.equals("unusedArguments")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "warning");
                        continue;
                    }
                    if (token.equals("unusedImport") || token.equals("unusedImports")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
                        continue;
                    }
                    if (token.equals("unusedPrivate")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "warning");
                        continue;
                    }
                    if (token.equals("localHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
                        continue;
                    }
                    if (token.equals("fieldHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
                        continue;
                    }
                    if (token.equals("specialParamHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "enabled");
                        continue;
                    }
                    if (token.equals("syntheticAccess")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "warning");
                        continue;
                    }
                    if (token.equals("nls")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "warning");
                        continue;
                    }
                    if (token.equals("staticReceiver")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
                        continue;
                    }
                    if (token.equals("noEffectAssign")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "warning");
                        continue;
                    }
                    if (token.equals("interfaceNonInherited")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", "warning");
                        continue;
                    }
                    if (token.equals("noImplicitStringConversion")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", "warning");
                        continue;
                    }
                    if (token.startsWith("tasks")) {
                        String taskTags = "";
                        int start = token.indexOf(40);
                        int end = token.indexOf(41);
                        if (start >= 0 && end >= 0 && start < end) {
                            taskTags = token.substring(start + 1, end).trim();
                            taskTags = taskTags.replace('|', ',');
                        }
                        if (taskTags.length() == 0) {
                            throw new InvalidInputException(Main.bind("configure.invalidTaskTag", token));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.taskTags", taskTags);
                        continue;
                    }
                    if (token.equals("assertIdentifier")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
                        continue;
                    }
                    throw new InvalidInputException(Main.bind("configure.invalidWarning", token));
                }
                if (tokenCounter != 0) continue;
                throw new InvalidInputException(Main.bind("configure.invalidWarningOption", currentArg));
            }
            if (currentArg.equals("-target")) {
                mode = 4;
                continue;
            }
            if (currentArg.equals("-preserveAllLocals")) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                continue;
            }
            if (mode == 4) {
                didSpecifyTarget = true;
                if (currentArg.equals("1.1")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                } else if (currentArg.equals("1.2")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (currentArg.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                } else if (currentArg.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    if (didSpecifyCompliance && this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.3")) {
                        throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget14", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance")));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                } else {
                    throw new InvalidInputException(Main.bind("configure.targetJDK", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 8) {
                this.log = currentArg;
                mode = 0;
                continue;
            }
            if (mode == 16) {
                try {
                    this.repetitions = Integer.parseInt(currentArg);
                    if (this.repetitions <= 0) {
                        throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(Main.bind("configure.repetition", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 32) {
                if (currentArg.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                } else if (currentArg.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                } else {
                    throw new InvalidInputException(Main.bind("configure.source", currentArg));
                }
                mode = 0;
                continue;
            }
            if (mode == 64) {
                if (didSpecifyDefaultEncoding) {
                    throw new InvalidInputException(Main.bind("configure.duplicateDefaultEncoding", currentArg));
                }
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), currentArg);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", currentArg));
                }
                this.options.put("org.eclipse.jdt.core.encoding", currentArg);
                didSpecifyDefaultEncoding = true;
                mode = 0;
                continue;
            }
            if (mode == 2) {
                this.destinationPath = currentArg;
                mode = 0;
                continue;
            }
            if (mode == 1) {
                StringTokenizer tokenizer = new StringTokenizer(currentArg, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    int length = this.classpaths.length;
                    if (length <= pathCount) {
                        this.classpaths = new String[length * 2];
                        System.arraycopy(this.classpaths, 0, this.classpaths, 0, length);
                    }
                    this.classpaths[pathCount++] = tokenizer.nextToken();
                }
                mode = 0;
                continue;
            }
            if (mode == 128) {
                StringTokenizer tokenizer = new StringTokenizer(currentArg, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    int length = bootclasspaths.length;
                    if (length <= bootclasspathCount) {
                        String[] stringArray = bootclasspaths;
                        bootclasspaths = new String[length * 2];
                        System.arraycopy(stringArray, 0, bootclasspaths, 0, length);
                    }
                    bootclasspaths[bootclasspathCount++] = tokenizer.nextToken();
                }
                mode = 0;
                continue;
            }
            if ((currentArg = currentArg.replace('/', File.separatorChar)).endsWith(File.separator)) {
                currentArg = currentArg.substring(0, currentArg.length() - File.separator.length());
            }
            if (!(dir = new File(currentArg)).isDirectory()) {
                throw new InvalidInputException(Main.bind("configure.directoryNotExist", currentArg));
            }
            FileFinder finder = new FileFinder();
            try {
                finder.find(dir, ".JAVA", this.verbose);
            }
            catch (Exception exception) {
                throw new InvalidInputException(Main.bind("configure.IOError", currentArg));
            }
            if (this.filenames != null) {
                String[] results = finder.resultFiles;
                int length = results.length;
                this.filenames = new String[length + filesCount];
                System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
                this.encodings = new String[length + filesCount];
                System.arraycopy(this.encodings, 0, this.encodings, 0, filesCount);
                System.arraycopy(results, 0, this.filenames, filesCount, length);
                int i5 = 0;
                while (i5 < length) {
                    this.encodings[filesCount + i5] = customEncoding;
                    ++i5;
                }
                filesCount += length;
                customEncoding = null;
            } else {
                this.filenames = finder.resultFiles;
                filesCount = this.filenames.length;
                this.encodings = new String[filesCount];
                int i6 = 0;
                while (i6 < filesCount) {
                    this.encodings[i6] = customEncoding;
                    ++i6;
                }
                customEncoding = null;
            }
            mode = 0;
        }
        if (versionIDRequired) {
            this.out.println(Main.bind("configure.version", Main.bind("compiler.version")));
            this.out.println();
            this.proceed = false;
            return;
        }
        if (printUsageRequired) {
            this.printUsage();
            this.proceed = false;
            return;
        }
        if (filesCount != 0) {
            this.filenames = new String[filesCount];
            System.arraycopy(this.filenames, 0, this.filenames, 0, filesCount);
        }
        if (pathCount == 0) {
            String classProp = System.getProperty("java.class.path");
            if (classProp == null || classProp.length() == 0) {
                this.err.println(Main.bind("configure.noClasspath"));
                classProp = System.getProperty("user.dir");
            }
            StringTokenizer tokenizer = new StringTokenizer(classProp, File.pathSeparator);
            this.classpaths = new String[tokenizer.countTokens() + 1];
            while (tokenizer.hasMoreTokens()) {
                this.classpaths[pathCount++] = tokenizer.nextToken();
            }
            this.classpaths[pathCount++] = System.getProperty("user.dir");
        }
        if (bootclasspathCount == 0) {
            String javaversion = System.getProperty("java.version");
            if (javaversion != null && javaversion.equalsIgnoreCase("1.1.8")) {
                this.err.println(Main.bind("configure.requiresJDK1.2orAbove"));
                this.proceed = false;
                return;
            }
            String javaVMName = System.getProperty("java.vm.name");
            if (javaVMName != null && javaVMName.equalsIgnoreCase("J9")) {
                File javaHomeFile;
                String javaHome = System.getProperty("java.home");
                if (javaHome != null && (javaHomeFile = new File(javaHome)).exists()) {
                    try {
                        javaHomeFile = new File(javaHomeFile.getCanonicalPath());
                        File defaultLibrary = new File(javaHomeFile, "lib" + File.separator + "jclMax" + File.separator + "classes.zip");
                        File locales = new File(javaHomeFile, "lib" + File.separator + "jclMax" + File.separator + "locale.zip");
                        File charconv = new File(javaHomeFile, "lib" + File.separator + "charconv.zip");
                        bootclasspaths = new String[]{defaultLibrary.getAbsolutePath(), locales.getAbsolutePath(), charconv.getAbsolutePath()};
                        bootclasspathCount = 3;
                    }
                    catch (IOException iOException) {}
                }
            } else {
                File javaHomeFile;
                String javaHome = System.getProperty("java.home");
                if (javaHome != null && (javaHomeFile = new File(javaHome)).exists()) {
                    try {
                        javaHomeFile = new File(javaHomeFile.getCanonicalPath());
                        File[] systemLibrariesJars = this.getFilesFrom(new File(javaHomeFile, "lib"), ".jar");
                        int length = systemLibrariesJars.length;
                        bootclasspaths = new String[length];
                        int i7 = 0;
                        while (i7 < length) {
                            bootclasspaths[bootclasspathCount++] = systemLibrariesJars[i7].getAbsolutePath();
                            ++i7;
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (this.classpaths == null) {
            this.classpaths = new String[0];
        }
        String[] newclasspaths = null;
        newclasspaths = pathCount + bootclasspathCount != this.classpaths.length ? new String[pathCount + bootclasspathCount] : this.classpaths;
        System.arraycopy(this.classpaths, 0, newclasspaths, bootclasspathCount, pathCount);
        if (bootclasspathCount != 0) {
            System.arraycopy(bootclasspaths, 0, newclasspaths, 0, bootclasspathCount);
        }
        this.classpaths = newclasspaths;
        int i8 = 0;
        int max = this.classpaths.length;
        while (i8 < max) {
            File file = new File(this.classpaths[i8]);
            if (!file.exists()) {
                this.err.println(Main.bind("configure.incorrectClasspath", this.classpaths[i8]));
            }
            ++i8;
        }
        if (this.destinationPath == null) {
            this.generatePackagesStructure = false;
        } else if ("none".equals(this.destinationPath)) {
            this.destinationPath = null;
        }
        if (this.filenames == null) {
            this.printUsage();
            return;
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4") && !this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform").equals("1.4") && didSpecifyTarget) {
            throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource14", (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")));
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform").equals("1.4") && !this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.4") && didSpecifyTarget) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget14", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance")));
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4")) {
            this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        } else if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.4") && this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform").equals("1.1")) {
            if (didSpecifyTarget) {
                throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget11", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance")));
            }
            this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4") && !this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.4")) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource14", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance")));
        }
        if (this.log != null) {
            try {
                this.err = new PrintWriter(new FileOutputStream(this.log, false));
            }
            catch (IOException iOException) {
                throw new InvalidInputException(Main.bind("configure.cannotOpenLog"));
            }
        } else {
            this.showProgress = false;
        }
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
    }

    private File[] getFilesFrom(File f, final String extension) {
        return f.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(extension);
            }
        });
    }

    public static Map getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>();
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "optimize out");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unreachableCode", "error");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.invalidImport", "error");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
        defaultOptions.put("org.eclipse.jdt.core.compiler.source", "1.3");
        defaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", "disabled");
        return defaultOptions;
    }

    public Map getOptions() {
        return this.options;
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (compilationResult.lineSeparatorPositions != null) {
                    int unitLineCount = compilationResult.lineSeparatorPositions.length;
                    Main.this.lineCount += (long)unitLineCount;
                    this.lineDelta += unitLineCount;
                    if (Main.this.showProgress && this.lineDelta > 2000) {
                        Main.this.out.print('.');
                        this.lineDelta = 0;
                    }
                }
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    IProblem[] problems = compilationResult.getAllProblems();
                    int count = problems.length;
                    int localErrorCount = 0;
                    int i = 0;
                    while (i < count) {
                        if (problems[i] != null) {
                            ++Main.this.globalProblemsCount;
                            if (localErrorCount == 0) {
                                Main.this.err.println("----------");
                            }
                            Main.this.err.print(String.valueOf(Main.this.globalProblemsCount) + ". " + (problems[i].isError() ? Main.bind("requestor.error") : Main.bind("requestor.warning")));
                            if (problems[i].isError()) {
                                ++Main.this.globalErrorsCount;
                            } else {
                                ++Main.this.globalWarningsCount;
                            }
                            Main.this.err.print(" ");
                            Main.this.err.print(Main.bind("requestor.in", new String(problems[i].getOriginatingFileName())));
                            try {
                                Main.this.err.println(((DefaultProblem)problems[i]).errorReportSource(compilationResult.compilationUnit));
                                Main.this.err.println(problems[i].getMessage());
                            }
                            catch (Exception exception) {
                                Main.this.err.println(Main.bind("requestor.notRetrieveErrorMessage", problems[i].toString()));
                            }
                            Main.this.err.println("----------");
                            if (problems[i].isError()) {
                                ++localErrorCount;
                            }
                        }
                        ++i;
                    }
                    if (Main.this.systemExitWhenFinished && !Main.this.proceedOnError && localErrorCount > 0) {
                        Main.this.err.flush();
                        Main.this.out.flush();
                        System.exit(-1);
                    }
                }
                Main.this.outputClassFiles(compilationResult);
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int fileCount = this.filenames.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        HashtableOfObject knownFileNames = new HashtableOfObject(fileCount);
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        int i = 0;
        while (i < fileCount) {
            char[] charName = this.filenames[i].toCharArray();
            if (knownFileNames.get(charName) != null) {
                throw new InvalidInputException(Main.bind("unit.more", this.filenames[i]));
            }
            knownFileNames.put(charName, charName);
            File file = new File(this.filenames[i]);
            if (!file.exists()) {
                throw new InvalidInputException(Main.bind("unit.missing", this.filenames[i]));
            }
            String encoding = this.encodings[i];
            if (encoding == null) {
                encoding = defaultEncoding;
            }
            units[i] = new CompilationUnit(null, this.filenames[i], encoding);
            ++i;
        }
        return units;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return Main.this.proceedOnError;
            }
        };
    }

    public FileSystem getLibraryAccess() {
        String defaultEncoding = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        return new FileSystem(this.classpaths, this.filenames, defaultEncoding);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public static void main(String[] argv) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(argv);
    }

    public void outputClassFiles(CompilationResult unitResult) {
        block6: {
            Enumeration classFiles;
            block7: {
                if (unitResult == null || unitResult.hasErrors() && !this.proceedOnError) break block6;
                classFiles = unitResult.compiledTypes.elements();
                if (this.generatePackagesStructure) break block7;
                while (classFiles.hasMoreElements()) {
                    this.destinationPath = this.extractDestinationPathFromSourceFile(unitResult);
                    ClassFile classFile = (ClassFile)classFiles.nextElement();
                    char[] filename = classFile.fileName();
                    int length = filename.length;
                    char[] relativeName = new char[length + 6];
                    System.arraycopy(filename, 0, relativeName, 0, length);
                    System.arraycopy(CLASS_FILE_EXTENSION, 0, relativeName, length, 6);
                    CharOperation.replace(relativeName, '/', File.separatorChar);
                    try {
                        ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, new String(relativeName), classFile.getBytes());
                    }
                    catch (IOException e) {
                        String fileName = String.valueOf(this.destinationPath) + new String(relativeName);
                        e.printStackTrace();
                        this.err.println(Main.bind("output.noClassFileCreated", fileName));
                    }
                    ++this.exportedClassFilesCounter;
                }
                break block6;
            }
            if (this.destinationPath == null) break block6;
            while (classFiles.hasMoreElements()) {
                ClassFile classFile = (ClassFile)classFiles.nextElement();
                char[] filename = classFile.fileName();
                int length = filename.length;
                char[] relativeName = new char[length + 6];
                System.arraycopy(filename, 0, relativeName, 0, length);
                System.arraycopy(CLASS_FILE_EXTENSION, 0, relativeName, length, 6);
                CharOperation.replace(relativeName, '/', File.separatorChar);
                try {
                    ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, new String(relativeName), classFile.getBytes());
                }
                catch (IOException e) {
                    String fileName = String.valueOf(this.destinationPath) + new String(relativeName);
                    e.printStackTrace();
                    this.err.println(Main.bind("output.noClassFileCreated", fileName));
                }
                ++this.exportedClassFilesCounter;
            }
        }
    }

    public void performCompilation() throws InvalidInputException {
        FileSystem environment = this.getLibraryAccess();
        Compiler batchCompiler = new Compiler(environment, this.getHandlingPolicy(), this.getOptions(), this.getBatchRequestor(), this.getProblemFactory());
        CompilerOptions compilerOptions = batchCompiler.options;
        compilerOptions.setVerboseMode(this.verbose);
        compilerOptions.produceReferenceInfo(this.produceRefInfo);
        batchCompiler.compile(this.getCompilationUnits());
        environment.cleanup();
    }

    public void printUsage() {
        this.out.println(Main.bind("misc.usage", Main.bind("compiler.version")));
        this.out.flush();
        this.err.flush();
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static String bind(String id) {
        return Main.bind(id, null);
    }

    public static String bind(String id, String[] bindings) {
        StringBuffer output;
        block9: {
            if (id == null) {
                return "No message available";
            }
            String message = null;
            try {
                message = bundle.getString(id);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + id + " in: " + bundleName;
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            message = new String(messageWithNoDoubleQuotes);
            if (bindings == null) {
                return message;
            }
            int length = message.length();
            int start = -1;
            int end = length;
            output = new StringBuffer(80);
            while ((end = message.indexOf(123, start)) > -1) {
                output.append(message.substring(start + 1, end));
                start = message.indexOf(125, end);
                if (start > -1) {
                    int index = -1;
                    try {
                        index = Integer.parseInt(message.substring(end + 1, start));
                        output.append(bindings[index]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        output.append(message.substring(end + 1, start + 1));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        output.append("{missing " + Integer.toString(index) + "}");
                    }
                    continue;
                }
                output.append(message.substring(end, length));
                break block9;
            }
            output.append(message.substring(start + 1, length));
        }
        return output.toString();
    }

    public static String bind(String id, String binding) {
        return Main.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Main.bind(id, new String[]{binding1, binding2});
    }

    public String extractDestinationPathFromSourceFile(CompilationResult result) {
        ICompilationUnit compilationUnit = result.compilationUnit;
        if (compilationUnit != null) {
            char[] fileName = compilationUnit.getFileName();
            int lastIndex = CharOperation.lastIndexOf(File.separatorChar, fileName);
            if (lastIndex == -1) {
                return System.getProperty("user.dir");
            }
            return new String(CharOperation.subarray(fileName, 0, lastIndex));
        }
        return System.getProperty("user.dir");
    }
}

