/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.BiDirPolicy;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.AOM;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.POAManager;
import org.jacorb.poa.POAMonitor;
import org.jacorb.poa.POAMonitorLightImpl;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ApplicationError;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.policy.IdAssignmentPolicy;
import org.jacorb.poa.policy.IdUniquenessPolicy;
import org.jacorb.poa.policy.ImplicitActivationPolicy;
import org.jacorb.poa.policy.LifespanPolicy;
import org.jacorb.poa.policy.RequestProcessingPolicy;
import org.jacorb.poa.policy.ServantRetentionPolicy;
import org.jacorb.poa.policy.ThreadPolicy;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.IdUtil;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.ssl.SSLPolicy;
import org.jacorb.ssl.SSLPolicyValue;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;
import org.omg.PortableServer._POALocalBase;

public class POA
extends _POALocalBase
implements Configurable {
    private ORB orb;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private byte[] implName = null;
    private byte[] serverId = null;
    private String logPrefix = "<unset>";
    private POAListener poaListener;
    private POAMonitor monitor;
    private POAManager poaManager;
    private POA parent;
    private String name;
    private String qualifiedName;
    private Hashtable childs = new Hashtable();
    Servant defaultServant;
    ServantManager servantManager;
    private AdapterActivator adapterActivator;
    private AOM aom;
    private RequestController requestController;
    private byte[] poaId;
    private byte[] watermark;
    private long objectIdCount;
    protected org.omg.PortableServer.ThreadPolicy threadPolicy;
    protected org.omg.PortableServer.LifespanPolicy lifespanPolicy;
    protected org.omg.PortableServer.IdUniquenessPolicy idUniquenessPolicy;
    protected org.omg.PortableServer.IdAssignmentPolicy idAssignmentPolicy;
    protected org.omg.PortableServer.ServantRetentionPolicy servantRetentionPolicy;
    protected org.omg.PortableServer.RequestProcessingPolicy requestProcessingPolicy;
    protected org.omg.PortableServer.ImplicitActivationPolicy implicitActivationPolicy;
    protected BidirectionalPolicy bidirectionalPolicy;
    protected SSLPolicy sslPolicy;
    private Hashtable all_policies = null;
    private Hashtable createdReferences;
    private boolean etherealize;
    private int shutdownState = 0;
    private java.lang.Object poaCreationLog = new java.lang.Object();
    private java.lang.Object poaDestructionLog = new java.lang.Object();
    private java.lang.Object unknownAdapterLog = new java.lang.Object();
    private boolean unknownAdapterCalled;
    private boolean configured = false;

    private POA(ORB oRB, String string, POA pOA, POAManager pOAManager, Policy[] policyArray) {
        BiDirPolicy biDirPolicy;
        this.orb = oRB;
        this.name = string;
        this.parent = pOA;
        this.poaManager = pOAManager;
        this.logPrefix = "POA " + this.name;
        this.all_policies = new Hashtable();
        this.createdReferences = new Hashtable();
        if (policyArray != null) {
            block11: for (int i = 0; i < policyArray.length; ++i) {
                this.all_policies.put(new Integer(policyArray[i].policy_type()), policyArray[i]);
                switch (policyArray[i].policy_type()) {
                    case 16: {
                        this.threadPolicy = (org.omg.PortableServer.ThreadPolicy)policyArray[i];
                        continue block11;
                    }
                    case 17: {
                        this.lifespanPolicy = (org.omg.PortableServer.LifespanPolicy)policyArray[i];
                        continue block11;
                    }
                    case 18: {
                        this.idUniquenessPolicy = (org.omg.PortableServer.IdUniquenessPolicy)policyArray[i];
                        continue block11;
                    }
                    case 19: {
                        this.idAssignmentPolicy = (org.omg.PortableServer.IdAssignmentPolicy)policyArray[i];
                        continue block11;
                    }
                    case 21: {
                        this.servantRetentionPolicy = (org.omg.PortableServer.ServantRetentionPolicy)policyArray[i];
                        continue block11;
                    }
                    case 22: {
                        this.requestProcessingPolicy = (org.omg.PortableServer.RequestProcessingPolicy)policyArray[i];
                        continue block11;
                    }
                    case 20: {
                        this.implicitActivationPolicy = (org.omg.PortableServer.ImplicitActivationPolicy)policyArray[i];
                        continue block11;
                    }
                    case 37: {
                        this.bidirectionalPolicy = (BidirectionalPolicy)policyArray[i];
                        continue block11;
                    }
                    case 101: {
                        this.sslPolicy = (SSLPolicy)policyArray[i];
                    }
                }
            }
        }
        if (this.bidirectionalPolicy != null && (biDirPolicy = (BiDirPolicy)this.bidirectionalPolicy).useBiDirGIOP()) {
            oRB.turnOnBiDirGIOP();
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.poa");
        this.implName = this.configuration.getAttribute("jacorb.implname", "standardImplName").getBytes();
        this.serverId = String.valueOf((long)(Math.random() * 9.999999999E9)).getBytes();
        this.watermark = this.generateWatermark();
        this.aom = this.isRetain() ? new AOM(this.isUniqueId(), this.isSingleThreadModel(), this.logger) : null;
        this.requestController = new RequestController(this, this.orb, this.aom);
        this.requestController.configure((Configuration)this.configuration);
        this.poaManager.registerPOA(this);
        this.monitor = new POAMonitorLightImpl();
        this.monitor.init(this, this.aom, this.requestController.getRequestQueue(), this.requestController.getPoolManager(), "POA " + this.name);
        this.monitor.openMonitor();
        if (this.poaListener != null) {
            this.poaListener.poaCreated(this);
        }
        this.monitor.configure((Configuration)this.configuration);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POA " + this.name + " ready");
        }
        this.configured = true;
    }

    public void _addPOAEventListener(EventListener eventListener) {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        if (eventListener instanceof POAListener) {
            this.addPOAListener((POAListener)eventListener);
        }
        if (eventListener instanceof AOMListener && this.aom != null) {
            this.aom.addAOMListener((AOMListener)eventListener);
        }
        if (eventListener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().addRequestQueueListener((RequestQueueListener)eventListener);
        }
        if (eventListener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().addRPPoolManagerListener((RPPoolManagerListener)eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA _getChildPOA(String string) throws ParentIsHolding {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        POA pOA = (POA)this.childs.get(string);
        if (pOA == null || pOA.isDestructionApparent()) {
            if (this.adapterActivator == null) {
                throw new OBJECT_NOT_EXIST("no adapter activator exists for " + string);
            }
            if (this.isHolding()) {
                throw new ParentIsHolding();
            }
            if (this.isDiscarding()) {
                throw new TRANSIENT("a parent poa is in discarding state");
            }
            if (this.isInactive()) {
                throw new OBJ_ADAPTER("a parent poa is in inactive state");
            }
            boolean bl = false;
            if (this.isSingleThreadModel()) {
                java.lang.Object object = this.unknownAdapterLog;
                synchronized (object) {
                    while (this.unknownAdapterCalled) {
                        try {
                            this.unknownAdapterLog.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.unknownAdapterCalled = true;
                    try {
                        bl = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(string));
                    }
                    finally {
                        this.unknownAdapterCalled = false;
                        this.unknownAdapterLog.notifyAll();
                    }
                }
            }
            bl = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(string));
            if (bl) {
                pOA = (POA)this.childs.get(string);
                if (pOA == null) {
                    throw new POAInternalError("error: unknown_adapter returns true, but the child poa doesn't extist");
                }
            } else {
                throw new OBJECT_NOT_EXIST("poa activation is failed");
            }
        }
        return pOA;
    }

    public String _getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.parent == null ? "" : (this.parent.the_parent() == null ? this.name : this.parent._getQualifiedName() + '/' + this.name);
        }
        return this.qualifiedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _invoke(ServerRequest serverRequest) throws WrongAdapter {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            this.checkDestructionApparent();
            if (serverRequest.remainingPOAName() == null) {
                if (!this.previouslyGeneratedObjectKey(serverRequest.objectKey())) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn(this.logPrefix + " rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " _invoke: object key not previously generated!");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(this.logPrefix + " ObjectKey : " + CorbaLoc.parseKey(serverRequest.objectKey()) + " to POA Id : " + CorbaLoc.parseKey(this.getPOAId()) + " mismatch.");
                        }
                    }
                    throw new WrongAdapter();
                }
                if (this.isSystemId() && !this.previouslyGeneratedObjectId(serverRequest.objectId())) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn(this.logPrefix + " rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " _invoke: object id not previously generated!");
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(this.logPrefix + " ObjectId : " + CorbaLoc.parseKey(serverRequest.objectId()) + " to POA watermark : " + CorbaLoc.parseKey(this.watermark) + " mismatch.");
                        }
                    }
                    throw new WrongAdapter();
                }
            }
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + " rid: " + serverRequest.requestId() + " opname: " + serverRequest.operation() + " _invoke: queuing request");
                }
                this.requestController.queueRequest(serverRequest);
            }
            catch (ResourceLimitReachedException resourceLimitReachedException) {
                throw new TRANSIENT("resource limit reached");
            }
        }
    }

    public static POA _POA_init(ORB oRB) {
        POAManager pOAManager = new POAManager(oRB);
        Policy[] policyArray = null;
        policyArray = new Policy[]{new ImplicitActivationPolicy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        POA pOA = new POA(oRB, "RootPOA", null, pOAManager, policyArray);
        return pOA;
    }

    public void _removePOAEventListener(EventListener eventListener) {
        if (eventListener instanceof POAListener) {
            this.removePOAListener((POAListener)eventListener);
        }
        if (eventListener instanceof AOMListener && this.aom != null) {
            this.aom.removeAOMListener((AOMListener)eventListener);
        }
        if (eventListener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().removeRequestQueueListener((RequestQueueListener)eventListener);
        }
        if (eventListener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().removeRPPoolManagerListener((RPPoolManagerListener)eventListener);
        }
    }

    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        if (!this.isRetain() || !this.isSystemId()) {
            throw new WrongPolicy();
        }
        byte[] byArray = this.generateObjectId();
        try {
            this.aom.add(byArray, servant);
            this.orb.set_delegate(servant);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            throw new POAInternalError("error: object already active (activate_object)");
        }
        return byArray;
    }

    public void activate_object_with_id(byte[] byArray, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        if (byArray == null) {
            throw new BAD_PARAM("Cannot activate_object_with_id with null ID.");
        }
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(byArray) + " - activate_object_with_id: oid not previously generated!");
            }
            throw new BAD_PARAM();
        }
        this.aom.add(byArray, servant);
        this.orb.set_delegate(servant);
    }

    protected synchronized void addPOAListener(POAListener pOAListener) {
        this.poaListener = EventMulticaster.add(this.poaListener, pOAListener);
    }

    protected void changeToActive() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 0);
        }
        this.monitor.changeState("changed to active...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.monitor.changeState("active");
    }

    protected void changeToDiscarding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 2);
        }
        this.monitor.changeState("changed to discarding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        this.monitor.changeState("discarding");
    }

    protected void changeToHolding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 1);
        }
        this.monitor.changeState("changed to holding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.waitForCompletion();
        this.monitor.changeState("holding");
    }

    protected void changeToInactive(boolean bl) {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, 3);
        }
        this.monitor.changeState("changed to inactive ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        if (this.etherealize && this.isRetain() && this.useServantManager()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + "etherialize all servants ...");
            }
            this.aom.removeAll((ServantActivator)this.servantManager, this, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + "etherialize all servants ...");
            }
            if (this.monitor != null) {
                this.monitor.changeState("inactive (etherialization completed)");
            }
        } else if (this.monitor != null) {
            this.monitor.changeState("inactive (no etherialization)");
        }
    }

    public org.omg.PortableServer.IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue idAssignmentPolicyValue) {
        this.checkDestructionApparent();
        return new IdAssignmentPolicy(idAssignmentPolicyValue);
    }

    public org.omg.PortableServer.IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue idUniquenessPolicyValue) {
        this.checkDestructionApparent();
        return new IdUniquenessPolicy(idUniquenessPolicyValue);
    }

    public org.omg.PortableServer.ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue implicitActivationPolicyValue) {
        this.checkDestructionApparent();
        return new ImplicitActivationPolicy(implicitActivationPolicyValue);
    }

    public org.omg.PortableServer.LifespanPolicy create_lifespan_policy(LifespanPolicyValue lifespanPolicyValue) {
        this.checkDestructionApparent();
        return new LifespanPolicy(lifespanPolicyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA create_POA(String string, org.omg.PortableServer.POAManager pOAManager, Policy[] policyArray) throws AdapterAlreadyExists, InvalidPolicy {
        POA pOA;
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        String string2 = POAUtil.maskStr(string);
        if (pOAManager != null && !(pOAManager instanceof POAManager)) {
            throw new ApplicationError("error: the POAManager is incompatible with type \"jacorb.poa.POAManager\"!");
        }
        Policy[] policyArray2 = null;
        if (policyArray != null) {
            short s = this.verifyPolicyList(policyArray);
            if (s != -1) {
                throw new InvalidPolicy(s);
            }
            policyArray2 = new Policy[policyArray.length];
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray2[i] = policyArray[i].copy();
            }
        }
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            LocalObject localObject;
            pOA = (POA)this.childs.get(string2);
            if (pOA != null && !pOA.isDestructionApparent()) {
                throw new AdapterAlreadyExists();
            }
            if (pOA != null) {
                while ((localObject = (POA)this.childs.get(string2)) != null) {
                    try {
                        this.poaCreationLog.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (pOA == localObject) continue;
                    throw new AdapterAlreadyExists();
                }
            }
            if (this.isShutdownInProgress()) {
                throw new BAD_INV_ORDER();
            }
            localObject = pOAManager == null ? new POAManager(this.orb) : (POAManager)pOAManager;
            pOA = new POA(this.orb, string2, this, (POAManager)localObject, policyArray2);
            try {
                pOA.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                throw new INTERNAL(configurationException.getMessage());
            }
            try {
                if (this.poaListener != null) {
                    this.poaListener.poaCreated(pOA);
                }
            }
            catch (INTERNAL iNTERNAL) {
                ((POAManager)localObject).poaCreationFailed = true;
                throw iNTERNAL;
            }
            this.childs.put(string2, pOA);
        }
        return pOA;
    }

    public Object create_reference(String string) throws WrongPolicy {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        if (!this.isSystemId()) {
            throw new WrongPolicy();
        }
        return this.getReference(this.generateObjectId(), string, false);
    }

    public Object create_reference_with_id(byte[] byArray, String string) throws WrongPolicy {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(byArray) + "create_reference_with_id : object key not previously generated!");
            }
            throw new BAD_PARAM();
        }
        return this.getReference(byArray, string, false);
    }

    public org.omg.PortableServer.RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue requestProcessingPolicyValue) {
        this.checkDestructionApparent();
        return new RequestProcessingPolicy(requestProcessingPolicyValue);
    }

    public org.omg.PortableServer.ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue servantRetentionPolicyValue) {
        this.checkDestructionApparent();
        return new ServantRetentionPolicy(servantRetentionPolicyValue);
    }

    public org.omg.PortableServer.ThreadPolicy create_thread_policy(ThreadPolicyValue threadPolicyValue) {
        this.checkDestructionApparent();
        return new ThreadPolicy(threadPolicyValue);
    }

    public synchronized void deactivate_object(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        this.aom.remove(byArray, this.requestController, this.useServantManager() ? (ServantActivator)this.servantManager : null, this, false);
        this.createdReferences.remove(new ByteArrayKey(byArray));
    }

    public void destroy(boolean bl, boolean bl2) {
        java.lang.Object object;
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        if (bl2 && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        this.makeShutdownInProgress(bl);
        Enumeration enumeration = this.childs.elements();
        while (enumeration.hasMoreElements()) {
            object = (POA)enumeration.nextElement();
            ((POA)object).destroy(this.etherealize, bl2);
        }
        object = new Thread(){

            public void run() {
                POA.this.requestController.waitForShutdown();
                POA.this.makeDestructionApparent();
                POA.this.makeDestructionComplete();
            }
        };
        ((Thread)object).start();
        if (bl2) {
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private byte[] extractWatermark(byte[] byArray) {
        if (byArray.length < this.watermark.length) {
            return new byte[0];
        }
        return IdUtil.extract(byArray, byArray.length - this.watermark.length, this.watermark.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA find_POA(String string, boolean bl) throws AdapterNonExistent {
        this.checkDestructionApparent();
        String string2 = POAUtil.maskStr(string);
        POA pOA = (POA)this.childs.get(string2);
        if (pOA == null || pOA.isDestructionApparent()) {
            boolean bl2 = false;
            if (bl && this.the_activator() != null) {
                if (this.isSingleThreadModel()) {
                    java.lang.Object object = this.unknownAdapterLog;
                    synchronized (object) {
                        while (this.unknownAdapterCalled) {
                            try {
                                this.unknownAdapterLog.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.unknownAdapterCalled = true;
                        try {
                            bl2 = this.the_activator().unknown_adapter(this, string);
                        }
                        finally {
                            this.unknownAdapterCalled = false;
                            this.unknownAdapterLog.notifyAll();
                        }
                    }
                }
                bl2 = this.the_activator().unknown_adapter(this, string);
            }
            if (bl2) {
                pOA = (POA)this.childs.get(string2);
                if (pOA == null) {
                    throw new POAInternalError("error: unknown_adapter returns true, but the child poa does'n extist");
                }
            } else {
                throw new AdapterNonExistent();
            }
        }
        return pOA;
    }

    private synchronized byte[] generateObjectId() {
        if (this.isPersistent()) {
            return IdUtil.concat(IdUtil.createId(4), this.watermark);
        }
        return IdUtil.concat(IdUtil.toId(this.objectIdCount++), this.watermark);
    }

    private byte[] generateWatermark() {
        if (this.watermark == null) {
            this.watermark = this.isPersistent() ? IdUtil.toId(new String(this.getPOAId()).hashCode()) : IdUtil.createId(4);
        }
        return this.watermark;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        if (this.defaultServant == null) {
            throw new NoServant();
        }
        return this.defaultServant;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        if (!this.configured) {
            throw new Error("POA: not configured!");
        }
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        return this.servantManager;
    }

    protected POAMonitor getMonitor() {
        return this.monitor;
    }

    protected ORB getORB() {
        return this.orb;
    }

    public byte[] getPOAId() {
        if (this.poaId == null) {
            byte[] byArray = POAUtil.maskId(this.implName != null ? this.implName : this.serverId);
            int n = byArray.length;
            byte[] byArray2 = this._getQualifiedName().getBytes();
            int n2 = byArray2.length;
            int n3 = 0;
            if (n2 == 0) {
                this.poaId = new byte[n];
                System.arraycopy(byArray, 0, this.poaId, 0, n);
            } else {
                this.poaId = new byte[n + n2 + 1];
                System.arraycopy(byArray, 0, this.poaId, 0, n);
                this.poaId[n3 += n] = 47;
                System.arraycopy(byArray2, 0, this.poaId, ++n3, n2);
            }
        }
        return this.poaId;
    }

    protected Object getReference(byte[] byArray, String string, boolean bl) {
        byte[] byArray2 = POAUtil.maskId(byArray);
        int n = this.getPOAId().length;
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + n2 + 1];
        int n3 = 0;
        System.arraycopy(this.getPOAId(), 0, byArray3, n3, n);
        byArray3[n3 += n] = 47;
        System.arraycopy(byArray2, 0, byArray3, ++n3, n2);
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        Object object = (Object)this.createdReferences.get(byteArrayKey);
        if (object == null) {
            object = this.orb.getReference(this, byArray3, string, !this.isPersistent());
            if (bl) {
                this.createdReferences.put(byteArrayKey, object);
            }
            if (this.poaListener != null) {
                this.poaListener.referenceCreated(object);
            }
        }
        return object;
    }

    protected RequestController getRequestController() {
        return this.requestController;
    }

    protected State getState() {
        return this.poaManager.get_state();
    }

    public Object id_to_reference(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        servant = this.aom.getServant(byArray);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
    }

    public Servant id_to_servant(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(byArray)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected boolean isActive() {
        return this.poaManager.get_state().value() == 1;
    }

    protected void checkDestructionApparent() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("POA destroyed");
        }
    }

    protected static void checkNotLocal(Object object) throws WrongAdapter {
        if (object instanceof LocalObject) {
            throw new WrongAdapter("Local object");
        }
    }

    protected boolean isDestructionApparent() {
        return this.shutdownState >= 2;
    }

    protected boolean isDestructionComplete() {
        return this.shutdownState >= 3;
    }

    protected boolean isDiscarding() {
        return this.poaManager.get_state().value() == 2;
    }

    protected boolean isHolding() {
        return this.poaManager.get_state().value() == 0;
    }

    protected boolean isImplicitActivation() {
        return this.implicitActivationPolicy != null && this.implicitActivationPolicy.value() == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION;
    }

    protected boolean isInactive() {
        return this.poaManager.get_state().value() == 3;
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    private boolean isInInvocationContext(Servant servant) {
        try {
            if (this.orb.getPOACurrent().get_POA() == this && (servant == null || this.orb.getPOACurrent().getServant() == servant)) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    protected boolean isMultipleId() {
        return this.idUniquenessPolicy != null && this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.MULTIPLE_ID;
    }

    public boolean isPersistent() {
        return this.lifespanPolicy != null && this.lifespanPolicy.value() == LifespanPolicyValue.PERSISTENT;
    }

    public boolean isRetain() {
        return this.servantRetentionPolicy == null || this.servantRetentionPolicy.value() == ServantRetentionPolicyValue.RETAIN;
    }

    protected boolean isShutdownInProgress() {
        return this.shutdownState >= 1;
    }

    protected boolean isSingleThreadModel() {
        return this.threadPolicy != null && this.threadPolicy.value() == ThreadPolicyValue.SINGLE_THREAD_MODEL;
    }

    public boolean isSystemId() {
        return this.idAssignmentPolicy == null || this.idAssignmentPolicy.value() == IdAssignmentPolicyValue.SYSTEM_ID;
    }

    protected boolean isUniqueId() {
        return this.idUniquenessPolicy == null || this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.UNIQUE_ID;
    }

    protected boolean isUseDefaultServant() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT;
    }

    public boolean isUseServantManager() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER;
    }

    public boolean isSSLRequired() {
        return this.sslPolicy != null && this.sslPolicy.value() == SSLPolicyValue.SSL_REQUIRED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDestructionApparent() {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            if (this.shutdownState < 2) {
                this.poaManager.unregisterPOA(this);
                this.shutdownState = 2;
                if (this.poaListener != null) {
                    this.poaListener.poaStateChanged(this, 4);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "destruction is apparent");
                }
                this.monitor.changeState("destruction is apparent ...");
            }
        }
    }

    private void makeDestructionComplete() {
        if (this.shutdownState < 3) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "clear up the queue ...");
            }
            this.requestController.clearUpQueue(new OBJECT_NOT_EXIST("adapter destroyed"));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "... done");
            }
            if (this.etherealize && this.isRetain() && this.useServantManager()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "etherialize all servants ...");
                }
                this.aom.removeAll((ServantActivator)this.servantManager, this, true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "... done");
                }
            }
            if (!this.isSingleThreadModel()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "remove all processors from the pool ...");
                }
                this.requestController.clearUpPool();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "... done");
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "stop the request controller ...");
            }
            this.requestController.end();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.logPrefix + "... done");
            }
            this.shutdownState = 3;
            if (this.parent != null) {
                this.parent.unregisterChild(this.name);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.logPrefix + " destroyed");
            }
            this.monitor.changeState("destroyed");
            this.createdReferences.clear();
            this.all_policies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeShutdownInProgress(boolean bl) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            if (this.shutdownState < 1) {
                this.etherealize = bl;
                this.shutdownState = 1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.logPrefix + "shutdown is in progress");
                }
                this.monitor.changeState("shutdown is in progress ...");
            }
        }
    }

    public boolean previouslyGeneratedObjectId(byte[] byArray) {
        return IdUtil.equals(this.watermark, this.extractWatermark(byArray));
    }

    public boolean previouslyGeneratedObjectKey(byte[] byArray) {
        return IdUtil.equals(byArray, this.getPOAId(), this.getPOAId().length);
    }

    public byte[] reference_to_id(Object object) throws WrongAdapter, WrongPolicy {
        this.checkDestructionApparent();
        POA.checkNotLocal(object);
        byte[] byArray = POAUtil.extractOID(object);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(byArray) + "reference_to_id: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        return byArray;
    }

    public Servant reference_to_servant(Object object) throws ObjectNotActive, WrongAdapter, WrongPolicy {
        this.checkDestructionApparent();
        POA.checkNotLocal(object);
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        byte[] byArray = POAUtil.extractOID(object);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(byArray) + "reference_to_servant: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        if (this.aom != null && this.aom.isDeactivating(byteArrayKey) || this.requestController.isDeactivating(byteArrayKey)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn(this.logPrefix + "oid: " + POAUtil.convert(byArray) + "cannot process request, because object is already in the deactivation process");
            }
            throw new OBJECT_NOT_EXIST();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(byArray)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected synchronized void removePOAListener(POAListener pOAListener) {
        this.poaListener = EventMulticaster.remove(this.poaListener, pOAListener);
    }

    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!(this.isUseDefaultServant() || this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation())) {
            throw new WrongPolicy();
        }
        byte[] byArray = null;
        if (this.isRetain()) {
            if (this.isUniqueId() && (byArray = this.aom.getObjectId(servant)) != null) {
                return byArray;
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                byArray = this.generateObjectId();
                try {
                    this.aom.add(byArray, servant);
                }
                catch (ObjectAlreadyActive objectAlreadyActive) {
                    throw new POAInternalError("error: object already active (servant_to_id)");
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    byArray = this.aom.getObjectId(servant);
                }
                return byArray;
            }
        }
        if (this.isUseDefaultServant() && servant == this.defaultServant && this.isInInvocationContext(servant)) {
            try {
                byArray = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext noContext) {
                throw new POAInternalError("error: not in invocation context (servant_to_id)");
            }
            return byArray;
        }
        throw new ServantNotActive();
    }

    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        boolean bl = this.isInInvocationContext(servant);
        if (!(this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation() || bl)) {
            throw new WrongPolicy();
        }
        byte[] byArray = null;
        if (bl) {
            try {
                byArray = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext noContext) {
                throw new POAInternalError("error: not in invocation context (servant_to_reference)");
            }
            return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
        }
        if (this.isRetain()) {
            if (this.isUniqueId() && (byArray = this.aom.getObjectId(servant)) != null) {
                return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                byArray = this.generateObjectId();
                try {
                    this.aom.add(byArray, servant);
                }
                catch (ObjectAlreadyActive objectAlreadyActive) {
                    throw new POAInternalError("error: object already active (servant_to_reference)");
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    byArray = this.aom.getObjectId(servant);
                }
                this.orb.set_delegate(servant);
                return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
            }
        }
        throw new ServantNotActive();
    }

    public void set_servant(Servant servant) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        this.defaultServant = servant;
        if (this.defaultServant != null) {
            this.orb.set_delegate(this.defaultServant);
        }
    }

    public void set_servant_manager(ServantManager servantManager) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        if (this.servantManager != null) {
            throw new BAD_INV_ORDER();
        }
        if (this.isRetain() && !(servantManager instanceof ServantActivator)) {
            throw new WrongPolicy();
        }
        if (!this.isRetain() && !(servantManager instanceof ServantLocator)) {
            throw new WrongPolicy();
        }
        this.servantManager = servantManager;
    }

    protected void setMonitor(POAMonitor pOAMonitor) {
        this.monitor = pOAMonitor;
    }

    public AdapterActivator the_activator() {
        this.checkDestructionApparent();
        return this.adapterActivator;
    }

    public void the_activator(AdapterActivator adapterActivator) {
        this.checkDestructionApparent();
        this.adapterActivator = adapterActivator;
    }

    public String the_name() {
        this.checkDestructionApparent();
        return POAUtil.unmaskStr(this.name);
    }

    public org.omg.PortableServer.POA the_parent() {
        this.checkDestructionApparent();
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.PortableServer.POA[] the_children() {
        org.omg.PortableServer.POA[] pOAArray;
        this.checkDestructionApparent();
        int n = 0;
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            pOAArray = new org.omg.PortableServer.POA[this.childs.size()];
            Enumeration enumeration = this.childs.elements();
            while (enumeration.hasMoreElements()) {
                pOAArray[n] = (org.omg.PortableServer.POA)enumeration.nextElement();
                ++n;
            }
        }
        return pOAArray;
    }

    public org.omg.PortableServer.POAManager the_POAManager() {
        this.checkDestructionApparent();
        return this.poaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterChild(String string) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            this.childs.remove(string);
            this.poaCreationLog.notifyAll();
        }
    }

    public boolean useDefaultServant() {
        return this.isUseDefaultServant() && this.defaultServant != null;
    }

    protected boolean useServantManager() {
        return this.isUseServantManager() && this.servantManager != null;
    }

    private short verifyPolicyList(Policy[] policyArray) {
        block9: for (short s = 0; s < policyArray.length; s = (short)((short)(s + 1))) {
            switch (policyArray[s].policy_type()) {
                case 16: {
                    continue block9;
                }
                case 17: {
                    if (((org.omg.PortableServer.LifespanPolicy)policyArray[s]).value() != LifespanPolicyValue.PERSISTENT || this.implName != null) continue block9;
                    this.logger.fatalError("cannot create a persistent poa! (implname property is not used)");
                    return s;
                }
                case 18: {
                    continue block9;
                }
                case 19: {
                    continue block9;
                }
                case 21: {
                    if (((org.omg.PortableServer.ServantRetentionPolicy)policyArray[s]).value() != ServantRetentionPolicyValue.NON_RETAIN) continue block9;
                    Policy policy = POAUtil.getPolicy(policyArray, 22);
                    if (policy != null) {
                        if (((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT || ((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) continue block9;
                        return s;
                    }
                    return s;
                }
                case 22: {
                    Policy policy;
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policyArray[s]).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                        policy = POAUtil.getPolicy(policyArray, 21);
                        if (policy == null || ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) continue block9;
                        return s;
                    }
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policyArray[s]).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) continue block9;
                    policy = POAUtil.getPolicy(policyArray, 18);
                    Policy policy2 = POAUtil.getPolicy(policyArray, 21);
                    if (policy == null && policy2 == null) {
                        return s;
                    }
                    if (!(policy != null && policy2 == null ? ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID : (policy == null && policy2 != null ? ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN : policy != null && policy2 != null && ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID && ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN))) continue block9;
                    return s;
                }
                case 20: {
                    if (((org.omg.PortableServer.ImplicitActivationPolicy)policyArray[s]).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) continue block9;
                    Policy policy = POAUtil.getPolicy(policyArray, 21);
                    if (policy != null && ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.RETAIN) {
                        return s;
                    }
                    policy = POAUtil.getPolicy(policyArray, 19);
                    if (policy == null || ((org.omg.PortableServer.IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) continue block9;
                    return s;
                }
            }
        }
        return -1;
    }

    public Policy getPolicy(int n) {
        return (Policy)this.all_policies.get(new Integer(n));
    }

    public void addLocalRequest() {
        this.requestController.addLocalRequest();
    }

    public void removeLocalRequest() {
        this.requestController.removeLocalRequest();
    }

    public int getNumberOfObjects() {
        return this.aom.size();
    }
}

