/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractEventChannel;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.ChannelManager;
import org.jacorb.notification.EventChannelFactoryImpl;
import org.jacorb.notification.FilterFactoryImpl;
import org.jacorb.notification.TypedEventChannelFactoryImpl;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.queue.EventQueueFactory;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.ChannelNotFound;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.CosNotifyFilter.FilterFactoryHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public abstract class AbstractChannelFactory
implements ManageableServant,
Disposable {
    private static final String STANDARD_IMPL_NAME = "JacORB-NotificationService";
    private static final long SHUTDOWN_INTERVAL = 1000L;
    public static final String EVENTCHANNEL_FACTORY_POA_NAME = "EventChannelFactoryPOA";
    protected Object thisRef_;
    protected Logger logger_ = null;
    protected ChannelContext defaultChannelContext_ = new ChannelContext();
    protected POA rootPOA_;
    protected POA eventChannelFactoryPOA_;
    protected ApplicationContext applicationContext_;
    protected final SynchronizedBoolean filterFactoryStarted_ = new SynchronizedBoolean(false);
    private Servant thisServant_;
    private String ior_;
    private String corbaLoc_;
    private ORB orb_;
    private FilterFactory defaultFilterFactory_;
    private FilterFactoryImpl defaultFilterFactoryServant_;
    private ChannelManager channelManager_ = new ChannelManager();
    private Configuration config_;
    private final SynchronizedInt eventChannelIDPool_ = new SynchronizedInt(-1);
    private NameComponent[] registeredName_ = null;
    private NamingContext namingContext_;
    private Runnable destroyMethod_ = new Runnable(){

        public void run() {
            AbstractChannelFactory.this.dispose();
        }
    };
    static /* synthetic */ Class class$org$jacorb$notification$util$PatternWrapper;

    protected abstract AbstractEventChannel newEventChannel();

    protected abstract Object create_abstract_channel(Property[] var1, Property[] var2, IntHolder var3) throws UnsupportedAdmin, UnsupportedQoS;

    protected abstract String getObjectName();

    protected abstract String getShortcut();

    protected abstract Servant getServant();

    protected int getLocalPort() {
        org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)this.getORB();
        return oRB.getBasicAdapter().getPort();
    }

    protected String getLocalAddress() {
        org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)this.getORB();
        return oRB.getBasicAdapter().getAddress();
    }

    private String createCorbaLoc(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("corbaloc::");
        stringBuffer.append(this.getLocalAddress());
        stringBuffer.append(":");
        stringBuffer.append(this.getLocalPort());
        stringBuffer.append("/");
        stringBuffer.append(this.getShortcut());
        return stringBuffer.toString();
    }

    public synchronized Object activate() {
        if (this.thisRef_ == null) {
            try {
                byte[] byArray = this.getObjectName().getBytes();
                this.eventChannelFactoryPOA_.activate_object_with_id(byArray, this.getServant());
                this.thisRef_ = this.eventChannelFactoryPOA_.id_to_reference(byArray);
                if (this.logger_.isDebugEnabled()) {
                    this.logger_.debug("activated EventChannelFactory with OID '" + new String(byArray) + "' on '" + this.eventChannelFactoryPOA_.the_name() + "'");
                }
                this.ior_ = this.getORB().object_to_string(this.eventChannelFactoryPOA_.id_to_reference(byArray));
                this.corbaLoc_ = this.createCorbaLoc(this.eventChannelFactoryPOA_.the_name(), byArray);
                ((org.jacorb.orb.ORB)this.getORB()).addObjectKey(this.getShortcut(), this.ior_);
                this.defaultChannelContext_.setEventChannelFactory(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.getMessage());
            }
        }
        return this.thisRef_;
    }

    public void setDestroyMethod(Runnable runnable) {
        this.destroyMethod_ = runnable;
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
        org.jacorb.orb.ORB oRB2 = (org.jacorb.orb.ORB)this.orb_;
        try {
            Object object = oRB.resolve_initial_references("RootPOA");
            this.rootPOA_ = POAHelper.narrow(object);
            this.applicationContext_ = new ApplicationContext(oRB, this.rootPOA_);
            Policy[] policyArray = new Policy[]{this.rootPOA_.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            this.eventChannelFactoryPOA_ = this.rootPOA_.create_POA(EVENTCHANNEL_FACTORY_POA_NAME, this.rootPOA_.the_POAManager(), policyArray);
            for (int i = 0; i < policyArray.length; ++i) {
                policyArray[i].destroy();
            }
            this.rootPOA_.the_POAManager().activate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setPOA(POA pOA) {
    }

    public final void deactivate() {
        try {
            this.eventChannelFactoryPOA_.deactivate_object(this.eventChannelFactoryPOA_.servant_to_id(this.getServant()));
        }
        catch (Exception exception) {
            this.logger_.fatalError("unable to deactivate object", (Throwable)exception);
            throw new RuntimeException();
        }
    }

    public void preActivate() throws Exception {
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        this.config_ = configuration;
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.defaultChannelContext_.configure(configuration);
        this.applicationContext_.configure(configuration);
        String string = configuration.getAttribute("jacorb.notification.default_filter_factory", "builtin");
        try {
            this.setUpDefaultFilterFactory(string);
        }
        catch (InvalidName invalidName) {
            this.logger_.error("FilterFactory setup failed", (Throwable)invalidName);
            throw new ConfigurationException("jacorb.notification.default_filter_factory");
        }
    }

    private void setUpDefaultFilterFactory(String string) throws InvalidName, ConfigurationException {
        if (!string.equals("builtin")) {
            try {
                if (this.logger_.isInfoEnabled()) {
                    this.logger_.info("try to set default_filter_factory to '" + string + "'");
                }
                this.defaultFilterFactory_ = FilterFactoryHelper.narrow(this.getORB().string_to_object(string));
            }
            catch (Throwable throwable) {
                this.logger_.error("Could not resolve FilterFactory: '" + string + "'. Will default to builtin FilterFactory.", throwable);
            }
        }
        if (this.defaultFilterFactory_ == null) {
            (class$org$jacorb$notification$util$PatternWrapper == null ? (class$org$jacorb$notification$util$PatternWrapper = AbstractChannelFactory.class$("org.jacorb.notification.util.PatternWrapper")) : class$org$jacorb$notification$util$PatternWrapper).getName();
            this.logger_.info("Create FilterFactory");
            this.defaultFilterFactoryServant_ = new FilterFactoryImpl(this.applicationContext_);
            this.defaultFilterFactoryServant_.configure(this.config_);
            this.defaultFilterFactoryServant_.preActivate();
            this.defaultFilterFactory_ = FilterFactoryHelper.narrow(this.defaultFilterFactoryServant_.activate());
            this.filterFactoryStarted_.set(true);
        }
    }

    protected Configuration getConfiguration() {
        return this.config_;
    }

    protected FilterFactory getDefaultFilterFactory() {
        return this.defaultFilterFactory_;
    }

    public void dispose() {
        try {
            this.unregisterName();
        }
        catch (Exception exception) {
            this.logger_.error("unable to unregister NameService registration", (Throwable)exception);
        }
        this.channelManager_.dispose();
        if (this.defaultFilterFactoryServant_ != null) {
            this.defaultFilterFactoryServant_.dispose();
        }
        this.applicationContext_.dispose();
        this.getORB().shutdown(true);
    }

    protected void addToChannels(int n, AbstractEventChannel abstractEventChannel) {
        this.channelManager_.add_channel(n, abstractEventChannel);
    }

    protected int[] getAllChannels() {
        return this.channelManager_.get_all_channels();
    }

    protected AbstractEventChannel get_event_channel_servant(int n) throws ChannelNotFound {
        return this.channelManager_.get_channel_servant(n);
    }

    protected Iterator getChannelIterator() {
        return this.channelManager_.getChannelIterator();
    }

    protected AbstractEventChannel create_channel_servant(IntHolder intHolder, Property[] propertyArray, Property[] propertyArray2) throws UnsupportedAdmin, UnsupportedQoS, ConfigurationException {
        int n;
        intHolder.value = n = this.createChannelIdentifier();
        if (this.logger_.isInfoEnabled()) {
            this.logger_.debug("create channel_servant id=" + n);
        }
        AdminPropertySet adminPropertySet = new AdminPropertySet(this.getConfiguration());
        adminPropertySet.set_admin(propertyArray2);
        QoSPropertySet qoSPropertySet = new QoSPropertySet(this.getConfiguration(), 1);
        qoSPropertySet.set_qos(propertyArray);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("uniqueQoSProps: " + qoSPropertySet);
            this.logger_.debug("uniqueAdminProps: " + adminPropertySet);
        }
        this.checkQoSSettings(qoSPropertySet);
        ChannelContext channelContext = (ChannelContext)this.defaultChannelContext_.clone();
        channelContext.setORB(this.getORB());
        channelContext.setPOA(this.rootPOA_);
        channelContext.setMessageFactory(this.applicationContext_.getMessageFactory());
        channelContext.setTaskProcessor(this.applicationContext_.getTaskProcessor());
        EventQueueFactory eventQueueFactory = new EventQueueFactory();
        eventQueueFactory.configure((Configuration)((org.jacorb.orb.ORB)this.getORB()).getConfiguration());
        channelContext.setEventQueueFactory(eventQueueFactory);
        AbstractEventChannel abstractEventChannel = this.newEventChannel();
        abstractEventChannel.setDefaultFilterFactory(this.getDefaultFilterFactory());
        channelContext.resolveDependencies(abstractEventChannel);
        try {
            org.jacorb.orb.ORB oRB = (org.jacorb.orb.ORB)this.getORB();
            abstractEventChannel.configure((Configuration)oRB.getConfiguration());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable.getMessage());
        }
        abstractEventChannel.setKey(n);
        abstractEventChannel.set_qos(qoSPropertySet.toArray());
        abstractEventChannel.set_admin(adminPropertySet.toArray());
        abstractEventChannel.setORB(this.getORB());
        abstractEventChannel.setPOA(this.rootPOA_);
        return abstractEventChannel;
    }

    private int createChannelIdentifier() {
        return this.eventChannelIDPool_.increment();
    }

    private void checkQoSSettings(PropertySet propertySet) throws UnsupportedQoS {
        short s;
        if (propertySet.containsKey("EventReliability")) {
            s = propertySet.get("EventReliability").extract_short();
            switch (s) {
                case 0: {
                    this.logger_.info("EventReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("EventReliability");
                }
                default: {
                    this.throwBadValue("EventReliability");
                }
            }
        }
        s = 0;
        if (propertySet.containsKey("ConnectionReliability")) {
            s = propertySet.get("ConnectionReliability").extract_short();
            switch (s) {
                case 0: {
                    this.logger_.info("ConnectionReliability=BestEffort");
                    break;
                }
                case 1: {
                    this.throwPersistentNotSupported("ConnectionReliability");
                    break;
                }
                default: {
                    this.throwBadValue("ConnectionReliability");
                }
            }
        }
    }

    private void throwPersistentNotSupported(String string) throws UnsupportedQoS {
        Any any = this.getORB().create_any();
        Any any2 = this.getORB().create_any();
        any.insert_short((short)0);
        any2.insert_short((short)0);
        UnsupportedQoS unsupportedQoS = new UnsupportedQoS(new PropertyError[]{new PropertyError(QoSError_code.UNSUPPORTED_VALUE, string, new PropertyRange(any, any2))});
        throw unsupportedQoS;
    }

    private void throwBadValue(String string) throws UnsupportedQoS {
        Any any = this.getORB().create_any();
        Any any2 = this.getORB().create_any();
        any.insert_short((short)0);
        any2.insert_short((short)0);
        UnsupportedQoS unsupportedQoS = new UnsupportedQoS("The specified Property Value is not supported", new PropertyError[]{new PropertyError(QoSError_code.BAD_VALUE, string, new PropertyRange(any, any2))});
        throw unsupportedQoS;
    }

    public void destroy() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    AbstractChannelFactory.this.logger_.info("Notification Service is going down in 1000 ms");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AbstractChannelFactory.this.destroyMethod_.run();
            }
        };
        thread.start();
    }

    public void shutdown(ShutdownCallback shutdownCallback) {
        int n = 0;
        Iterator iterator = this.getChannelIterator();
        while (iterator.hasNext()) {
            AbstractEventChannel abstractEventChannel = (AbstractEventChannel)((Map.Entry)iterator.next()).getValue();
            n += abstractEventChannel.getNumberOfConnectedClients();
        }
        int n2 = 4000;
        int n3 = n * n2;
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Connected Clients: " + n);
            this.logger_.info("Connection Timeout: " + n2 + " ms");
            this.logger_.info("Estimated Shutdowntime: " + n3 + " ms");
        }
        shutdownCallback.needTime(n3);
        this.logger_.info("NotificationService is going down");
        this.dispose();
        this.logger_.info("NotificationService down");
        shutdownCallback.shutdownComplete();
    }

    public String getIOR() {
        return this.ior_;
    }

    public String getCorbaLoc() {
        return this.corbaLoc_;
    }

    private static AbstractChannelFactory newChannelFactory(boolean bl) {
        if (bl) {
            return new TypedEventChannelFactoryImpl();
        }
        return new EventChannelFactoryImpl();
    }

    public static AbstractChannelFactory newFactory(final ORB oRB, boolean bl, Properties properties) throws Exception {
        AbstractChannelFactory abstractChannelFactory = AbstractChannelFactory.newChannelFactory("on".equals(properties.get("jacorb.notification.enable_typed_channel")));
        abstractChannelFactory.setORB(oRB);
        abstractChannelFactory.configure((Configuration)((org.jacorb.orb.ORB)oRB).getConfiguration());
        abstractChannelFactory.preActivate();
        abstractChannelFactory.activate();
        abstractChannelFactory.printIOR(properties);
        abstractChannelFactory.printCorbaLoc(properties);
        abstractChannelFactory.writeFile(properties);
        abstractChannelFactory.registerName(properties);
        abstractChannelFactory.startChannels(properties);
        if (bl) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    oRB.run();
                }
            });
            thread.setName("Notification ORB Runner Thread");
            thread.setDaemon(false);
            thread.start();
        }
        return abstractChannelFactory;
    }

    public static AbstractChannelFactory newFactory(Properties properties) throws Exception {
        properties.put("jacorb.implname", STANDARD_IMPL_NAME);
        ORB oRB = ORB.init(new String[0], properties);
        return AbstractChannelFactory.newFactory(oRB, true, properties);
    }

    private void registerName(Properties properties) throws Exception {
        this.registerName(properties.getProperty("jacorb.notification.register_name.id"), properties.getProperty("jacorb.notification.register_name.kind", ""));
    }

    private synchronized void registerName(String string, String string2) throws Exception {
        if (string == null) {
            return;
        }
        this.namingContext_ = NamingContextHelper.narrow(this.getORB().resolve_initial_references("NameService"));
        if (this.namingContext_ == null) {
            throw new ConfigurationException("could not resolve initial reference 'NameService'");
        }
        NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent(string, string2)};
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("namingContext.rebind(" + string + (string2 != null && string2.length() > 0 ? "." + string2 : "") + " => " + this.getCorbaLoc() + ")");
        }
        this.namingContext_.rebind(nameComponentArray, this.thisRef_);
        this.registeredName_ = nameComponentArray;
    }

    private synchronized void unregisterName() throws Exception {
        if (this.namingContext_ != null && this.registeredName_ != null) {
            this.namingContext_.unbind(this.registeredName_);
            this.registeredName_ = null;
        }
    }

    private void startChannels(Properties properties) throws UnsupportedQoS, UnsupportedAdmin {
        if (properties.containsKey("jacorb.notification.start_channels")) {
            this.startChannels(Integer.parseInt((String)properties.get("jacorb.notification.start_channels")));
        }
    }

    private void startChannels(int n) throws UnsupportedQoS, UnsupportedAdmin {
        for (int i = 0; i < n; ++i) {
            IntHolder intHolder = new IntHolder();
            this.create_abstract_channel(new Property[0], new Property[0], intHolder);
        }
    }

    private void printIOR(Properties properties) {
        if ("on".equals(properties.get("jacorb.notification.print_ior"))) {
            System.out.println(this.getIOR());
        }
    }

    private void printCorbaLoc(Properties properties) {
        if ("on".equals(properties.get("jacorb.notification.print_corbaloc"))) {
            System.out.println(this.getCorbaLoc());
        }
    }

    private void writeFile(Properties properties) {
        String string = (String)properties.get("jacorb.notification.ior_file");
        if (string != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(string));
                printWriter.println(this.getIOR());
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static interface ShutdownCallback {
        public void needTime(int var1);

        public void shutdownComplete();
    }
}

