/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.util;

import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMUtils {
    private static final Logger log = Logger.getLogger((Class)DOMUtils.class);

    private DOMUtils() {
    }

    public static String getAttributeValue(Element el, String attrName) {
        String attr = el.getAttribute(attrName);
        if ("".equals(attr)) {
            attr = null;
        }
        return attr;
    }

    public static QName getAttributeValueAsQName(Element el, String attrName) {
        QName qname = null;
        String attr = DOMUtils.getAttributeValue(el, attrName);
        if (attr != null) {
            String prefix = "";
            String localPart = attr;
            String namespaceURI = "";
            int colonIndex = attr.indexOf(":");
            if (colonIndex > 0) {
                prefix = attr.substring(0, colonIndex);
                localPart = attr.substring(colonIndex + 1);
                Element nsElement = el;
                while (namespaceURI.equals("") && nsElement != null) {
                    namespaceURI = nsElement.getAttribute("xmlns:" + prefix);
                    if (!namespaceURI.equals("")) continue;
                    nsElement = DOMUtils.getParentElement(nsElement);
                }
                if (namespaceURI.equals("")) {
                    throw new IllegalArgumentException("Cannot find namespace uri for: " + attr);
                }
            }
            qname = new QName(namespaceURI, localPart, prefix);
        }
        return qname;
    }

    public static boolean getAttributeValueAsBoolean(Element el, String attrName) {
        String attrVal = DOMUtils.getAttributeValue(el, attrName);
        boolean ret = "true".equalsIgnoreCase(attrVal) || "1".equalsIgnoreCase(attrVal);
        return ret;
    }

    public static Element getFirstChildElement(Element el) {
        return DOMUtils.getFirstChildElement(el, null);
    }

    public static Element getFirstChildElement(Element el, String tagName) {
        Element childElement = null;
        NodeList nlist = el.getChildNodes();
        for (int i = 0; childElement == null && i < nlist.getLength(); ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() != 1 || tagName != null && !tagName.equals(node.getLocalName())) continue;
            childElement = (Element)node;
        }
        return childElement;
    }

    public static Element getParentElement(Element el) {
        Node parent = el.getParentNode();
        return parent instanceof Element ? (Element)parent : null;
    }
}

