/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Marshaller;
import org.jgroups.util.TimeScheduler;

public class FD
extends Protocol {
    Address ping_dest = null;
    Address local_addr = null;
    long timeout = 3000L;
    long last_ack = System.currentTimeMillis();
    int num_tries = 0;
    int max_tries = 2;
    Vector members = new Vector(11);
    Hashtable invalid_pingers = new Hashtable(7);
    Vector pingable_mbrs = new Vector(11);
    boolean shun = true;
    TimeScheduler timer = null;
    Monitor monitor = null;
    BroadcastTask bcast_task = new BroadcastTask();

    public String getName() {
        return "FD";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("max_tries")) != null) {
            this.max_tries = Integer.parseInt(str);
            props.remove("max_tries");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if (props.size() > 0) {
            System.err.println("FD.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("FD.init(): timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    public void stop() {
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor = null;
        }
    }

    Object getPingDest(Vector mbrs) {
        Object retval = null;
        if (mbrs == null || mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        for (int i = 0; i < mbrs.size(); ++i) {
            Object tmp = mbrs.elementAt(i);
            if (!this.local_addr.equals(tmp)) continue;
            if (i + 1 >= mbrs.size()) {
                retval = mbrs.elementAt(0);
                break;
            }
            retval = mbrs.elementAt(i + 1);
            break;
        }
        return retval;
    }

    void startMonitor() {
        if (this.monitor != null && !this.monitor.started) {
            this.monitor = null;
        }
        if (this.monitor == null) {
            this.monitor = new Monitor();
            this.last_ack = System.currentTimeMillis();
            this.timer.add(this.monitor, true);
            this.num_tries = 0;
        }
    }

    public void up(Event evt) {
        FdHeader hdr = null;
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header tmphdr = msg.getHeader(this.getName());
                if (tmphdr == null || !(tmphdr instanceof FdHeader)) {
                    Address sender;
                    if (this.ping_dest == null || (sender = msg.getSrc()) == null || !this.ping_dest.equals(sender)) break;
                    this.last_ack = System.currentTimeMillis();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("received msg from " + sender + " (counts as ack)"));
                    }
                    this.num_tries = 0;
                    break;
                }
                hdr = (FdHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 0: {
                        Address hb_sender = msg.getSrc();
                        Message hb_ack = new Message(msg.getSrc(), null, null);
                        FdHeader tmp_hdr = new FdHeader(1);
                        tmp_hdr.from = this.local_addr;
                        hb_ack.putHeader(this.getName(), tmp_hdr);
                        this.passDown(new Event(1, hb_ack));
                        if (!this.shun) break;
                        this.shunInvalidHeartbeatSender(hb_sender);
                        break;
                    }
                    case 1: {
                        if (this.ping_dest != null && this.ping_dest.equals(hdr.from)) {
                            this.last_ack = System.currentTimeMillis();
                            this.num_tries = 0;
                            if (!this.log.isDebugEnabled()) break;
                            this.log.debug((Object)("received ack from " + hdr.from));
                            break;
                        }
                        this.stop();
                        this.ping_dest = (Address)this.getPingDest(this.members);
                        if (this.ping_dest == null) break;
                        try {
                            this.startMonitor();
                        }
                        catch (Exception ex) {
                            if (!this.log.isWarnEnabled()) break;
                            this.log.warn((Object)("exception when calling startMonitor(): " + ex));
                        }
                        break;
                    }
                    case 2: {
                        if (hdr.mbrs == null) break;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("[SUSPECT] suspect hdr is " + hdr));
                        }
                        for (int i = 0; i < hdr.mbrs.size(); ++i) {
                            Address m = (Address)hdr.mbrs.elementAt(i);
                            if (this.local_addr != null && m.equals(this.local_addr)) {
                                if (this.log.isWarnEnabled()) {
                                    this.log.warn((Object)"I was suspected, but will not remove myself from membership (waiting for EXIT message)");
                                }
                            } else {
                                this.pingable_mbrs.remove(m);
                                this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
                            }
                            this.passUp(new Event(9, m));
                            this.passDown(new Event(9, m));
                        }
                        break;
                    }
                    case 3: {
                        if (!this.shun) break;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"[NOT_MEMBER] I'm being shunned; exiting");
                        }
                        this.passUp(new Event(46));
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                FD fD = this;
                synchronized (fD) {
                    this.stop();
                    View v = (View)evt.getArg();
                    this.members.removeAllElements();
                    this.members.addAll(v.getMembers());
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    this.pingable_mbrs.removeAllElements();
                    this.pingable_mbrs.addAll(this.members);
                    this.passDown(evt);
                    this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
                    if (this.ping_dest == null) break;
                    try {
                        this.startMonitor();
                    }
                    catch (Exception ex) {
                        if (!this.log.isWarnEnabled()) break;
                        this.log.warn((Object)("exception when calling startMonitor(): " + ex));
                    }
                    break;
                }
            }
            case 51: {
                this.unsuspect((Address)evt.getArg());
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    void unsuspect(Address mbr) {
        this.bcast_task.removeSuspectedMember(mbr);
        this.pingable_mbrs.removeAllElements();
        this.pingable_mbrs.addAll(this.members);
        this.pingable_mbrs.removeAll(this.bcast_task.getSuspectedMembers());
        this.ping_dest = (Address)this.getPingDest(this.pingable_mbrs);
    }

    void shunInvalidHeartbeatSender(Address hb_sender) {
        int num_pings = 0;
        if (hb_sender != null && this.members != null && !this.members.contains(hb_sender)) {
            if (this.invalid_pingers.containsKey(hb_sender)) {
                num_pings = (Integer)this.invalid_pingers.get(hb_sender);
                if (num_pings >= this.max_tries) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(hb_sender + " is not in " + this.members + " ! Telling it to leave group"));
                    }
                    Message shun_msg = new Message(hb_sender, null, null);
                    shun_msg.putHeader(this.getName(), new FdHeader(3));
                    this.passDown(new Event(1, shun_msg));
                    this.invalid_pingers.remove(hb_sender);
                } else {
                    this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
                }
            } else {
                this.invalid_pingers.put(hb_sender, new Integer(++num_pings));
            }
        }
    }

    private class BroadcastTask
    implements TimeScheduler.Task {
        Vector suspected_mbrs = new Vector(7);
        boolean stopped = false;

        private BroadcastTask() {
        }

        Vector getSuspectedMembers() {
            return this.suspected_mbrs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            if (!FD.this.members.contains(mbr)) {
                return;
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (!this.suspected_mbrs.contains(mbr)) {
                    this.suspected_mbrs.addElement(mbr);
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)("mbr=" + mbr + " (size=" + this.suspected_mbrs.size() + ')'));
                    }
                }
                if (this.stopped && this.suspected_mbrs.size() > 0) {
                    this.stopped = false;
                    FD.this.timer.add(this, true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeSuspectedMember(Address suspected_mbr) {
            if (suspected_mbr == null) {
                return;
            }
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("member is " + suspected_mbr));
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeElement(suspected_mbr);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
                this.stopped = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void adjustSuspectedMembers(Vector new_mbrship) {
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                sb.append("suspected_mbrs: ").append(this.suspected_mbrs);
                this.suspected_mbrs.retainAll(new_mbrship);
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
                sb.append(", after adjustment: ").append(this.suspected_mbrs).append(", stopped: ").append(this.stopped);
                FD.this.log.debug((Object)sb.toString());
            }
        }

        public boolean cancelled() {
            return this.stopped;
        }

        public long nextInterval() {
            return FD.this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FdHeader hdr;
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)"task done (no suspected members)");
                    }
                    return;
                }
                hdr = new FdHeader(2);
                hdr.mbrs = (Vector)this.suspected_mbrs.clone();
                hdr.from = FD.this.local_addr;
            }
            Message suspect_msg = new Message();
            suspect_msg.putHeader(FD.this.getName(), hdr);
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("broadcasting SUSPECT message [suspected_mbrs=" + this.suspected_mbrs + "] to group"));
            }
            FD.this.passDown(new Event(1, suspect_msg));
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)"task done");
            }
        }
    }

    private class Monitor
    implements TimeScheduler.Task {
        boolean started = true;

        private Monitor() {
        }

        public void stop() {
            this.started = false;
        }

        public boolean cancelled() {
            return !this.started;
        }

        public long nextInterval() {
            return FD.this.timeout;
        }

        public void run() {
            long not_heard_from = 0L;
            if (FD.this.ping_dest == null) {
                if (FD.this.log.isWarnEnabled()) {
                    FD.this.log.warn((Object)("ping_dest is null: members=" + FD.this.members + ", pingable_mbrs=" + FD.this.pingable_mbrs + ", local_addr=" + FD.this.local_addr));
                }
                return;
            }
            Message hb_req = new Message(FD.this.ping_dest, null, null);
            hb_req.putHeader(FD.this.getName(), new FdHeader(0));
            if (FD.this.log.isDebugEnabled()) {
                FD.this.log.debug((Object)("sending are-you-alive msg to " + FD.this.ping_dest + " (own address=" + FD.this.local_addr + ')'));
            }
            FD.this.passDown(new Event(1, hb_req));
            not_heard_from = System.currentTimeMillis() - FD.this.last_ack;
            if (not_heard_from > FD.this.timeout + 500L) {
                if (FD.this.num_tries >= FD.this.max_tries) {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)("[" + FD.this.local_addr + "]: received no heartbeat ack from " + FD.this.ping_dest + " for " + (FD.this.num_tries + 1) + " times (" + (long)(FD.this.num_tries + 1) * FD.this.timeout + " milliseconds), suspecting it"));
                    }
                    FD.this.bcast_task.addSuspectedMember(FD.this.ping_dest);
                    FD.this.num_tries = 0;
                } else {
                    if (FD.this.log.isDebugEnabled()) {
                        FD.this.log.debug((Object)("heartbeat missing from " + FD.this.ping_dest + " (number=" + FD.this.num_tries + ')'));
                    }
                    ++FD.this.num_tries;
                }
            }
        }

        public String toString() {
            return "" + this.started;
        }
    }

    public static class FdHeader
    extends Header {
        static final int HEARTBEAT = 0;
        static final int HEARTBEAT_ACK = 1;
        static final int SUSPECT = 2;
        static final int NOT_MEMBER = 3;
        int type = 0;
        Vector mbrs = null;
        Address from = null;

        public FdHeader() {
        }

        FdHeader(int type) {
            this.type = type;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "[FD: heartbeat]";
                }
                case 1: {
                    return "[FD: heartbeat ack]";
                }
                case 2: {
                    return "[FD: SUSPECT (suspected_mbrs=" + this.mbrs + ", from=" + this.from + ")]";
                }
                case 3: {
                    return "[FD: NOT_MEMBER]";
                }
            }
            return "[FD: unknown type (" + this.type + ")]";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            if (this.mbrs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeInt(this.mbrs.size());
                Iterator it = this.mbrs.iterator();
                while (it.hasNext()) {
                    Address addr = (Address)it.next();
                    Marshaller.write(addr, out);
                }
            }
            Marshaller.write(this.from, out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            boolean mbrs_not_null = in.readBoolean();
            if (mbrs_not_null) {
                int len = in.readInt();
                this.mbrs = new Vector(11);
                for (int i = 0; i < len; ++i) {
                    Address addr = (Address)Marshaller.read(in);
                    this.mbrs.add(addr);
                }
            }
            this.from = (Address)Marshaller.read(in);
        }
    }
}

