/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit._SharedRendererUtils;
import org.apache.myfaces.util.HashMapUtils;

public class RendererUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$RendererUtils == null ? (class$org$apache$myfaces$renderkit$RendererUtils = RendererUtils.class$("org.apache.myfaces.renderkit.RendererUtils")) : class$org$apache$myfaces$renderkit$RendererUtils));
    public static final String SELECT_ITEM_LIST_ATTR = (class$org$apache$myfaces$renderkit$RendererUtils == null ? (class$org$apache$myfaces$renderkit$RendererUtils = RendererUtils.class$("org.apache.myfaces.renderkit.RendererUtils")) : class$org$apache$myfaces$renderkit$RendererUtils).getName() + ".LIST";
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$RendererUtils;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        RendererUtils.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, (Object)intBuf);
        if (component != null) {
            RendererUtils.getPathToComponent(component.getParent(), buf);
        }
    }

    public static String getConcatenatedId(FacesContext context, UIComponent container, String clientId) {
        UIComponent child = container.findComponent(clientId);
        if (child == null) {
            return clientId;
        }
        return RendererUtils.getConcatenatedId(context, child);
    }

    public static String getConcatenatedId(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(component.getId());
        UIComponent parent = null;
        while ((parent = component.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, ':');
            idBuf.insert(0, parent.getId());
        }
        return idBuf.toString();
    }

    public static Boolean getBooleanValue(UIComponent component) {
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            if (submittedValue instanceof Boolean) {
                return (Boolean)submittedValue;
            }
            throw new IllegalArgumentException("Expected submitted value of type Boolean for component : " + RendererUtils.getPathToComponent(component));
        }
        Object value = ((ValueHolder)component).getValue();
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Boolean for Component : " + RendererUtils.getPathToComponent(component));
    }

    public static Date getDateValue(UIComponent component) {
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            if (submittedValue instanceof Date) {
                return (Date)submittedValue;
            }
            throw new IllegalArgumentException("Expected submitted value of type Date for component : " + RendererUtils.getPathToComponent(component));
        }
        Object value = ((ValueHolder)component).getValue();
        if (value == null || value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Date for component : " + RendererUtils.getPathToComponent(component));
    }

    public static String getStringValue(FacesContext facesContext, UIComponent component) {
        try {
            Object submittedValue;
            if (!(component instanceof ValueHolder)) {
                throw new IllegalArgumentException("Component : " + RendererUtils.getPathToComponent(component) + "is not a ValueHolder");
            }
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                if (submittedValue instanceof String) {
                    return (String)submittedValue;
                }
                throw new IllegalArgumentException("Expected submitted value of type String for component : " + RendererUtils.getPathToComponent(component));
            }
            Object value = ((ValueHolder)component).getValue();
            Converter converter = ((ValueHolder)component).getConverter();
            if (converter == null && value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                try {
                    converter = facesContext.getApplication().createConverter(value.getClass());
                }
                catch (FacesException e) {
                    log.error((Object)("No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ")."));
                }
            }
            if (converter == null) {
                if (value == null) {
                    return "";
                }
                return value.toString();
            }
            return converter.getAsString(facesContext, component, value);
        }
        catch (PropertyNotFoundException ex) {
            log.error((Object)("Property not found - called by component : " + RendererUtils.getPathToComponent(component)));
            throw ex;
        }
    }

    public static boolean isDefaultAttributeValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() == Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return ((Number)value).doubleValue() == Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return ((Number)value).longValue() == Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return ((Number)value).byteValue() == -128;
            }
            if (value instanceof Float) {
                return ((Number)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return ((Number)value).shortValue() == Short.MIN_VALUE;
            }
        }
        return false;
    }

    public static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) throws FacesException {
        return _SharedRendererUtils.findUIOutputConverter(facesContext, component);
    }

    public static Converter findUISelectManyConverter(FacesContext facesContext, UISelectMany component) {
        Class<?> arrayComponentType;
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if ((class$java$util$List == null ? (class$java$util$List = RendererUtils.class$("java.util.List")) : class$java$util$List).isAssignableFrom(valueType)) {
            return null;
        }
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany : " + RendererUtils.getPathToComponent((UIComponent)component) + " must be of type List or Array");
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = RendererUtils.class$("java.lang.String")) : class$java$lang$String).equals(arrayComponentType = valueType.getComponentType())) {
            return null;
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = RendererUtils.class$("java.lang.Object")) : class$java$lang$Object).equals(arrayComponentType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(arrayComponentType);
        }
        catch (FacesException e) {
            log.error((Object)("No Converter for type " + arrayComponentType.getName() + " found"), (Throwable)e);
            return null;
        }
    }

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext may not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent may not be null");
        }
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent : " + RendererUtils.getPathToComponent(uiComponent) + " is not instance of " + compClass.getName() + " as it should be");
        }
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                RendererUtils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            RendererUtils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static List getSelectItemList(UISelectOne uiSelectOne) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectOne);
    }

    public static List getSelectItemList(UISelectMany uiSelectMany) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectMany);
    }

    private static List internalGetSelectItemList(UIComponent uiComponent) {
        ArrayList<Object> list = new ArrayList<Object>(uiComponent.getChildCount());
        Iterator children = uiComponent.getChildren().iterator();
        while (children.hasNext()) {
            Iterator<Object> it;
            UIComponent child = (UIComponent)children.next();
            if (child instanceof UISelectItem) {
                Object value = ((UISelectItem)child).getValue();
                if (value != null) {
                    if (!(value instanceof SelectItem)) {
                        ValueBinding binding = ((UISelectItem)child).getValueBinding("value");
                        throw new IllegalArgumentException("Value binding '" + (binding == null ? null : binding.getExpressionString()) + "' of UISelectItem : " + RendererUtils.getPathToComponent(child) + " does not reference an Object of type SelectItem");
                    }
                    list.add(value);
                    continue;
                }
                Object itemValue = ((UISelectItem)child).getItemValue();
                String label = ((UISelectItem)child).getItemLabel();
                String description = ((UISelectItem)child).getItemDescription();
                boolean disabled = ((UISelectItem)child).isItemDisabled();
                if (label == null) {
                    list.add(new SelectItem(itemValue, itemValue.toString(), description, disabled));
                    continue;
                }
                list.add(new SelectItem(itemValue, label, description, disabled));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            UISelectItems items = (UISelectItems)child;
            Object value = items.getValue();
            if (value instanceof SelectItem) {
                list.add(value);
                continue;
            }
            if (value instanceof SelectItem[]) {
                for (int i = 0; i < ((SelectItem[])value).length; ++i) {
                    list.add(((SelectItem[])value)[i]);
                }
                continue;
            }
            if (value instanceof Collection) {
                it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    Object item = it.next();
                    if (!(item instanceof SelectItem)) {
                        ValueBinding binding = items.getValueBinding("value");
                        throw new IllegalArgumentException("Collection referenced by UISelectItems with binding '" + binding.getExpressionString() + "' and Component-Path : " + RendererUtils.getPathToComponent(child) + " does not contain Objects of type SelectItem");
                    }
                    list.add(item);
                }
                continue;
            }
            if (value instanceof Map) {
                it = ((Map)value).entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    list.add(new SelectItem(entry.getValue(), entry.getKey().toString()));
                }
                continue;
            }
            ValueBinding binding = items.getValueBinding("value");
            throw new IllegalArgumentException("Value binding '" + (binding == null ? null : binding.getExpressionString()) + "'of UISelectItems with component-path " + RendererUtils.getPathToComponent(child) + " does not reference an Object of type SelectItem, SelectItem[], Collection or Map but of type : " + (value == null ? null : value.getClass().getName()));
        }
        return list;
    }

    public static Set getSubmittedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, submittedValues);
    }

    public static Set getSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object selectedValues = uiSelectMany.getValue();
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, selectedValues);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, Object value) {
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("Value is no String and component " + component.getClientId(context) + " does not have a Converter");
        }
        return converter.getAsString(context, component, value);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, SelectItem selectItem) {
        return RendererUtils.getConvertedStringValue(context, component, converter, selectItem.getValue());
    }

    private static Set internalSubmittedOrSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany, Object values) {
        if (values == null || values == EMPTY_STRING) {
            return Collections.EMPTY_SET;
        }
        if (values instanceof Object[]) {
            Object[] ar = (Object[])values;
            if (ar.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(ar.length));
            for (int i = 0; i < ar.length; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, ar[i]));
            }
            return set;
        }
        if (values.getClass().isArray()) {
            int len = Array.getLength(values);
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(len));
            for (int i = 0; i < len; ++i) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, Array.get(values, i)));
            }
            return set;
        }
        if (values instanceof List) {
            List lst = (List)values;
            if (lst.size() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(lst.size()));
            Iterator i = lst.iterator();
            while (i.hasNext()) {
                set.add(RendererUtils.getConvertedStringValue(context, component, converter, i.next()));
            }
            return set;
        }
        throw new IllegalArgumentException("Value of UISelectMany component with path : " + RendererUtils.getPathToComponent((UIComponent)uiSelectMany) + " is not of type Array or List");
    }

    public static Object getConvertedUIOutputValue(FacesContext facesContext, UIOutput output, Object submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String for component : " + RendererUtils.getPathToComponent((UIComponent)output) + "expected");
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, output);
        }
        catch (FacesException e) {
            throw new ConverterException((Throwable)e);
        }
        if (converter == null) {
            return submittedValue;
        }
        return converter.getAsObject(facesContext, (UIComponent)output, (String)submittedValue);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value of type String[] for component : " + RendererUtils.getPathToComponent((UIComponent)selectMany) + "expected");
        }
        return _SharedRendererUtils.getConvertedUISelectManyValue(facesContext, selectMany, (String[])submittedValue);
    }

    public static boolean getBooleanAttribute(UIComponent component, String attrName, boolean defaultValue) {
        Boolean b = (Boolean)component.getAttributes().get(attrName);
        return b != null ? b : defaultValue;
    }

    public static int getIntegerAttribute(UIComponent component, String attrName, int defaultValue) {
        Integer i = (Integer)component.getAttributes().get(attrName);
        return i != null ? i : defaultValue;
    }

    public static UIForm findParentForm(UIComponentBase comp) {
        for (UIComponent parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIForm)) continue;
            return (UIForm)parent;
        }
        return null;
    }

    public static void copyHtmlInputTextAttributes(HtmlInputText src, HtmlInputText dest) {
        dest.setId(src.getId());
        dest.setImmediate(src.isImmediate());
        dest.setTransient(src.isTransient());
        dest.setAccesskey(src.getAccesskey());
        dest.setAlt(src.getAlt());
        dest.setConverter(src.getConverter());
        dest.setDir(src.getDir());
        dest.setDisabled(src.isDisabled());
        dest.setLang(src.getLang());
        dest.setLocalValueSet(src.isLocalValueSet());
        dest.setMaxlength(src.getMaxlength());
        dest.setOnblur(src.getOnblur());
        dest.setOnchange(src.getOnchange());
        dest.setOnclick(src.getOnclick());
        dest.setOndblclick(src.getOndblclick());
        dest.setOnfocus(src.getOnfocus());
        dest.setOnkeydown(src.getOnkeydown());
        dest.setOnkeypress(src.getOnkeypress());
        dest.setOnkeyup(src.getOnkeyup());
        dest.setOnmousedown(src.getOnmousedown());
        dest.setOnmousemove(src.getOnmousemove());
        dest.setOnmouseout(src.getOnmouseout());
        dest.setOnmouseover(src.getOnmouseover());
        dest.setOnmouseup(src.getOnmouseup());
        dest.setOnselect(src.getOnselect());
        dest.setReadonly(src.isReadonly());
        dest.setRendered(src.isRendered());
        dest.setRequired(src.isRequired());
        dest.setSize(src.getSize());
        dest.setStyle(src.getStyle());
        dest.setStyleClass(src.getStyleClass());
        dest.setTabindex(src.getTabindex());
        dest.setTitle(src.getTitle());
        dest.setValidator(src.getValidator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

