/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.NullArgumentException;
import org.jboss.varia.process.ChildProcessServiceMBean;

public class ChildProcessService
extends ServiceMBeanSupport
implements ChildProcessServiceMBean {
    protected String commandLine;
    protected Properties env;
    protected File workingDir;
    protected Process childProcess;
    protected String loggerAdapterName = this.getClass().getName();
    protected ReaderLoggerAdapter inputAdapter;
    protected ReaderLoggerAdapter errorAdapter;

    public void setCommandLine(String commandLine) {
        if (commandLine == null) {
            throw new NullArgumentException("commandLine");
        }
        this.commandLine = commandLine;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setEnvironment(Properties env) {
        this.env = env;
    }

    public Properties getEnvironment() {
        return this.env;
    }

    public void setWorkingDirectory(File dir) {
        if (dir != null && dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("Directory argument does not point to a directory: " + dir);
        }
        this.workingDir = dir;
    }

    public File getWorkingDirectory() {
        return this.workingDir;
    }

    public Integer getExitValue() {
        if (this.childProcess != null) {
            return new Integer(this.childProcess.exitValue());
        }
        return null;
    }

    public void setLoggerAdapterName(String name) {
        this.loggerAdapterName = name;
    }

    public String getLoggerAdapterName() {
        return this.loggerAdapterName;
    }

    protected String[] makeEnvArray(Properties props) {
        if (props == null) {
            return new String[0];
        }
        String[] envArray = new String[props.keySet().size()];
        Iterator<Object> iter = props.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            envArray[i++] = name + "=" + props.getProperty(name);
        }
        return envArray;
    }

    protected void startService() throws Exception {
        Runtime rt = Runtime.getRuntime();
        this.childProcess = rt.exec(this.commandLine, this.makeEnvArray(this.env), this.workingDir);
        this.log.info((Object)("Spawned child process: " + this.commandLine));
        Logger logger = Logger.getLogger((String)this.loggerAdapterName);
        InputStream input = this.childProcess.getInputStream();
        this.inputAdapter = new ReaderLoggerAdapter(input, logger, Level.INFO);
        new Thread(this.inputAdapter).start();
        InputStream error = this.childProcess.getErrorStream();
        this.errorAdapter = new ReaderLoggerAdapter(error, logger, Level.ERROR);
        new Thread(this.errorAdapter).start();
    }

    protected void stopService() throws Exception {
        this.childProcess.destroy();
        this.log.debug((Object)"Child process destroyed; waiting for process to exit");
        this.childProcess.waitFor();
        this.log.info((Object)("Child exited with code: " + this.getExitValue()));
        this.inputAdapter.shutdown();
        this.errorAdapter.shutdown();
        this.childProcess = null;
        this.inputAdapter = null;
        this.errorAdapter = null;
    }

    protected static class ReaderLoggerAdapter
    implements Runnable {
        protected BufferedReader reader;
        protected boolean shutdown;
        protected Logger log;
        protected Level level;

        public ReaderLoggerAdapter(Reader reader, Logger log, Level level) {
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.log = log;
            this.level = level;
        }

        public ReaderLoggerAdapter(InputStream input, Logger log, Level level) {
            this(new InputStreamReader(input), log, level);
        }

        public void shutdown() {
            this.shutdown = true;
        }

        public void run() {
            while (!this.shutdown) {
                try {
                    String data = this.reader.readLine();
                    if (data == null) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.log.log((Priority)this.level, (Object)data);
                }
                catch (IOException e) {
                    this.log.error((Object)"Failed to read data from reader", (Throwable)e);
                }
            }
        }
    }
}

