/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.mail.inflow;

import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.jboss.resource.adapter.mail.inflow.MailActivationSpec;

public class MailFolder {
    private Session session;
    private Store store;
    private Folder folder;
    private String mailServer;
    private String folderName;
    private String userName;
    private String password;
    private Properties sessionProps;

    public MailFolder(MailActivationSpec spec) throws Exception {
        this.mailServer = spec.getMailServer();
        String protocol = spec.getStoreProtocol();
        this.folderName = spec.getMailFolder();
        this.userName = spec.getUserName();
        this.password = spec.getPassword();
        this.sessionProps = new Properties();
        this.sessionProps.setProperty("mail.transport.protocol", "smtp");
        this.sessionProps.setProperty("mail.store.protocol", protocol);
        this.sessionProps.setProperty("mail.smtp.host", this.mailServer);
    }

    public void open() throws Exception {
        this.session = Session.getDefaultInstance((Properties)this.sessionProps);
        this.store = this.session.getStore();
        this.store.connect(this.mailServer, this.userName, this.password);
        this.folder = this.store.getFolder(this.folderName);
        if (this.folder == null || !this.folder.exists()) {
            MessagingException e = new MessagingException("Failed to find folder: " + this.folderName);
            throw e;
        }
        this.folder.open(2);
    }

    public Message[] getNewMessages() throws Exception {
        Message[] msgs = new Message[]{};
        if (this.folder.hasNewMessages()) {
            int newCount = this.folder.getNewMessageCount();
            int msgCount = this.folder.getMessageCount();
            msgs = this.folder.getMessages(msgCount - newCount + 1, msgCount);
            return msgs;
        }
        return msgs;
    }

    public void close() throws MessagingException {
        this.folder.close(true);
        this.store.close();
        this.folder = null;
        this.store = null;
        this.session = null;
    }
}

