/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.threadpool;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import org.jboss.mq.threadpool.Work;

public class ThreadPool {
    private String name;
    private boolean daemon;
    private ThreadGroup threadGroup;
    private ArrayList workers;
    private int maxWorkers;
    private int idleWorkers;
    private volatile boolean stopping;
    private LinkedList queue;

    public ThreadPool(String name, ThreadGroup threadGroup, int maxWorkers, boolean daemon) {
        if (name == null || threadGroup == null || maxWorkers <= 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.daemon = daemon;
        this.threadGroup = threadGroup;
        this.workers = new ArrayList();
        this.maxWorkers = maxWorkers;
        this.idleWorkers = 0;
        this.stopping = false;
        this.queue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stopping = true;
        AbstractList abstractList = this.queue;
        synchronized (abstractList) {
            this.queue.clear();
            this.queue.notifyAll();
        }
        abstractList = this.workers;
        synchronized (abstractList) {
            while (this.workers.size() > 0) {
                try {
                    this.workers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(Work work) {
        AbstractList abstractList = this.workers;
        synchronized (abstractList) {
            if (this.idleWorkers == 0 && !this.stopping && this.workers.size() < this.maxWorkers) {
                new WorkerThread(this.name + "-" + (this.workers.size() + 1)).start();
            }
        }
        abstractList = this.queue;
        synchronized (abstractList) {
            if (this.stopping) {
                return;
            }
            this.queue.addLast(work);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelWork(Work work) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            while (this.queue.remove(work)) {
            }
        }
    }

    private class WorkerThread
    extends Thread {
        WorkerThread(String name) {
            super(ThreadPool.this.threadGroup, name);
            this.setDaemon(ThreadPool.this.daemon);
            ThreadPool.this.workers.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void idle() {
            ArrayList arrayList;
            try {
                arrayList = ThreadPool.this.workers;
                synchronized (arrayList) {
                    ++ThreadPool.this.idleWorkers;
                }
                ThreadPool.this.queue.wait();
            }
            catch (InterruptedException interruptedException) {
                ArrayList arrayList2 = ThreadPool.this.workers;
                synchronized (arrayList2) {
                    --ThreadPool.this.idleWorkers;
                }
            }
            finally {
                arrayList = ThreadPool.this.workers;
                synchronized (arrayList) {
                    --ThreadPool.this.idleWorkers;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ThreadPool.this.stopping) {
                Work work = null;
                LinkedList linkedList = ThreadPool.this.queue;
                synchronized (linkedList) {
                    if (ThreadPool.this.queue.size() == 0) {
                        this.idle();
                    }
                    if (!ThreadPool.this.stopping && ThreadPool.this.queue.size() > 0) {
                        work = (Work)ThreadPool.this.queue.removeFirst();
                    }
                }
                if (work == null) continue;
                work.doWork();
            }
            ArrayList arrayList = ThreadPool.this.workers;
            synchronized (arrayList) {
                ThreadPool.this.workers.remove(this);
                ThreadPool.this.workers.notify();
            }
        }
    }
}

