/*
 * Decompiled with CFR 0.152.
 */
package components.renderkit;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import components.model.ChartItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class ChartServlet
extends HttpServlet {
    private ServletConfig servletConfig = null;

    public void destroy() {
        this.servletConfig = null;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String type = request.getParameter("type");
        if (type == null || !type.equals("bar") && !type.equals("pie")) {
            type = "bar";
        }
        if (type.equals("bar")) {
            this.generateBarChart(request, response);
        } else {
            this.generatePieChart(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    private void generateBarChart(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int cy;
        int cx;
        HttpSession session;
        ChartItem[] chartItems;
        boolean VERTICAL = false;
        boolean HORIZONTAL = true;
        response.setContentType("image/jpeg");
        String id = request.getParameter("chartId");
        String title = request.getParameter("title");
        if (title == null) {
            title = "Chart";
        }
        int orientation = 0;
        String orientationStr = request.getParameter("orientation");
        orientation = orientationStr == null || !orientationStr.equals("horizontal") && !orientationStr.equals("vertical") ? 0 : (orientationStr.equals("vertical") ? 0 : 1);
        String xLabel = request.getParameter("xlabel");
        String yLabel = request.getParameter("ylabel");
        int width = 400;
        int height = 300;
        String widthStr = request.getParameter("width");
        String heightStr = request.getParameter("height");
        if (widthStr != null) {
            width = Integer.parseInt(widthStr);
        }
        if (heightStr != null) {
            height = Integer.parseInt(heightStr);
        }
        if ((chartItems = (ChartItem[])(session = request.getSession(true)).getAttribute(id)) == null) {
            System.out.println("No data items specified...");
            throw new ServletException("No data items specified...");
        }
        session.removeAttribute(id);
        int maxDataValue = 0;
        int maxLabelWidth = 0;
        int barSpacing = 10;
        int barWidth = 0;
        int columns = chartItems.length;
        int scale = 10;
        ChartItem chartItem = null;
        String label = null;
        int value = 0;
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        Font titleFont = new Font("Courier", 1, 12);
        FontMetrics titleFontMetrics = g2d.getFontMetrics(titleFont);
        int i = 0;
        while (i < columns) {
            chartItem = chartItems[i];
            label = chartItem.getLabel();
            value = chartItem.getValue();
            if (value > maxDataValue) {
                maxDataValue = value;
            }
            maxLabelWidth = Math.max(titleFontMetrics.stringWidth(label), maxLabelWidth);
            ++i;
        }
        int[] xcoords = new int[columns];
        int[] ycoords = new int[columns];
        int totalWidth = 0;
        int totalHeight = 0;
        int i2 = 0;
        while (i2 < columns) {
            switch (orientation) {
                default: {
                    barWidth = maxLabelWidth;
                    cx = Math.max(barWidth + barSpacing, maxLabelWidth) * i2 + barSpacing;
                    totalWidth = cx + 4 * titleFont.getSize();
                    break;
                }
                case 1: {
                    barWidth = titleFont.getSize();
                    cy = (barWidth + barSpacing) * i2 + barSpacing;
                    totalHeight = cy + 4 * titleFont.getSize();
                }
            }
            ++i2;
        }
        if (orientation == 0) {
            totalHeight = maxDataValue + 8 * titleFont.getSize();
            totalWidth += 50;
        } else {
            totalWidth = maxDataValue + (4 * titleFont.getSize() + Integer.toString(maxDataValue).length() * titleFont.getSize() + 50);
        }
        int yLabelHeight = 0;
        int i3 = 0;
        while (i3 < yLabel.length()) {
            yLabelHeight += titleFontMetrics.getAscent();
            ++i3;
        }
        if (yLabelHeight + 12 * titleFontMetrics.getDescent() > totalHeight) {
            totalHeight = yLabelHeight + 8 * titleFont.getSize();
        }
        bi = new BufferedImage(totalWidth, totalHeight, 1);
        g2d = bi.createGraphics();
        titleFontMetrics = g2d.getFontMetrics(titleFont);
        Dimension graphDim = new Dimension(totalWidth, totalHeight);
        Rectangle graphRect = new Rectangle(graphDim);
        Dimension borderDim = new Dimension(totalWidth - 2, totalHeight - 2);
        Rectangle borderRect = new Rectangle(borderDim);
        g2d.setColor(Color.white);
        g2d.fill(graphRect);
        g2d.setColor(Color.black);
        borderRect.setLocation(1, 1);
        g2d.draw(borderRect);
        int i4 = titleFontMetrics.stringWidth(title);
        g2d.setFont(titleFont);
        g2d.setColor(Color.black);
        g2d.drawString(title, Math.max((totalWidth - i4) / 2, 0), totalHeight - titleFontMetrics.getDescent());
        i4 = titleFontMetrics.stringWidth(xLabel);
        g2d.drawString(xLabel, Math.max((totalWidth - i4) / 2, 0), totalHeight - 6 * titleFontMetrics.getDescent());
        i4 = titleFontMetrics.stringWidth(yLabel);
        cx = totalWidth - (totalWidth - 6);
        cy = totalHeight - 12 * titleFontMetrics.getDescent();
        int j = yLabel.length();
        while (j > 0) {
            g2d.drawString(yLabel.substring(j - 1, j), cx, cy);
            cy -= titleFontMetrics.getAscent();
            --j;
        }
        i4 = 0;
        while (i4 < columns) {
            chartItem = chartItems[i4];
            label = chartItem.getLabel();
            value = chartItem.getValue();
            String colorStr = chartItem.getColor();
            Color color = this.getColor(colorStr);
            switch (orientation) {
                default: {
                    barWidth = maxLabelWidth;
                    cx = Math.max(barWidth + barSpacing, maxLabelWidth) * i4 + barSpacing + 12;
                    cy = totalHeight - value - 1 - 2 * titleFont.getSize();
                    g2d.setColor(Color.black);
                    g2d.drawString(label, cx += Math.max((totalWidth - columns * (barWidth + 2 * barSpacing)) / 2, 0), totalHeight - titleFont.getSize() - 8 * titleFontMetrics.getDescent());
                    if (color == Color.black) {
                        g2d.setColor(Color.gray);
                    }
                    g2d.fillRect(cx + 5, cy - 28, barWidth, value);
                    g2d.setColor(color);
                    g2d.fillRect(cx, cy - 30, barWidth, value);
                    g2d.drawString("" + value, cx, cy - 30 - titleFontMetrics.getDescent());
                    break;
                }
                case 1: {
                    barWidth = titleFont.getSize();
                    cy = totalHeight - ((barWidth + barSpacing) * i4 + barSpacing + 12 * titleFontMetrics.getDescent());
                    cx = maxLabelWidth + 1;
                    g2d.setColor(Color.black);
                    g2d.drawString(label, (cx += Math.max((totalWidth - (maxLabelWidth + 1 + titleFontMetrics.stringWidth("" + maxDataValue) + maxDataValue)) / 2, 0)) - maxLabelWidth - 1, cy + titleFontMetrics.getAscent());
                    if (color == Color.black) {
                        g2d.setColor(Color.gray);
                    }
                    g2d.fillRect(cx + 3, cy + 5, value, barWidth);
                    g2d.setColor(color);
                    g2d.fillRect(cx, cy, value, barWidth);
                    g2d.drawString("" + value, cx + value + 3, cy + titleFontMetrics.getAscent());
                }
            }
            ++i4;
        }
        ServletOutputStream output = response.getOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)output);
        encoder.encode(bi);
        output.close();
    }

    private void generatePieChart(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int pieHeight;
        HttpSession session;
        ChartItem[] chartItems;
        response.setContentType("image/jpeg");
        String id = request.getParameter("chartId");
        String title = request.getParameter("title");
        if (title == null) {
            title = "Chart";
        }
        String xLabel = request.getParameter("xlabel");
        String yLabel = request.getParameter("ylabel");
        int width = 400;
        int height = 200;
        String widthStr = request.getParameter("width");
        String heightStr = request.getParameter("height");
        if (widthStr != null) {
            width = Integer.parseInt(widthStr);
        }
        if (heightStr != null) {
            height = Integer.parseInt(heightStr);
        }
        if ((chartItems = (ChartItem[])(session = request.getSession()).getAttribute(id)) == null) {
            System.out.println("No data items specified...");
            throw new ServletException("No data items specified...");
        }
        session.removeAttribute(id);
        Color dropShadow = new Color(240, 240, 240);
        int innerOffset = 20;
        int pieWidth = pieHeight = height - innerOffset * 2;
        int halfWidth = width / 2;
        int innerWidth = width - innerOffset * 2;
        Dimension graphDim = new Dimension(width, height);
        Rectangle graphRect = new Rectangle(graphDim);
        Dimension borderDim = new Dimension(halfWidth - 2, height - 2);
        Rectangle borderRect = new Rectangle(borderDim);
        response.setContentType("image/jpeg");
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2d = bi.createGraphics();
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHints(renderHints);
        g2d.setColor(Color.white);
        g2d.fill(graphRect);
        g2d.setColor(Color.black);
        borderRect.setLocation(1, 1);
        g2d.draw(borderRect);
        borderRect.setLocation(width / 2 + 1, 1);
        g2d.draw(borderRect);
        int x_pie = innerOffset;
        int y_pie = innerOffset;
        int border = 20;
        Ellipse2D.Double elb = new Ellipse2D.Double(x_pie - border / 2, y_pie - border / 2, pieWidth + border, pieHeight + border);
        g2d.setColor(dropShadow);
        g2d.fill(elb);
        g2d.setColor(Color.black);
        g2d.draw(elb);
        float yTotal = 0.0f;
        int lastElement = 0;
        int i = 0;
        while (i < chartItems.length) {
            int ycoord = chartItems[i].getValue();
            if ((float)ycoord > 0.0f) {
                yTotal += (float)ycoord;
                lastElement = i;
            }
            ++i;
        }
        int startAngle = 0;
        int legendWidth = 20;
        int x_legendText = halfWidth + innerOffset / 2 + legendWidth + 5;
        int x_legendBar = halfWidth + innerOffset / 2;
        int textHeight = 20;
        int curElement = 0;
        int y_legend = 0;
        Dimension legendDim = new Dimension(legendWidth, textHeight / 2);
        Rectangle legendRect = new Rectangle(legendDim);
        int i2 = 0;
        while (i2 < chartItems.length) {
            int ycoord = chartItems[i2].getValue();
            if ((float)ycoord > 0.0f) {
                float perc = (float)ycoord / yTotal;
                int sweepAngle = (int)(perc * 360.0f);
                if (i2 == lastElement) {
                    sweepAngle = 360 - startAngle;
                }
                g2d.setColor(this.getColor(chartItems[i2].getColor()));
                g2d.fillArc(x_pie, y_pie, pieWidth, pieHeight, startAngle, sweepAngle);
                startAngle += sweepAngle;
                y_legend = curElement * textHeight + innerOffset;
                String display = chartItems[i2].getLabel();
                g2d.setColor(Color.black);
                g2d.drawString(display, x_legendText, y_legend);
                display = "" + ycoord;
                g2d.setColor(Color.black);
                g2d.drawString(display, x_legendText + 80, y_legend);
                display = "  (" + (int)(perc * 100.0f) + "%)";
                g2d.setColor(Color.red);
                g2d.drawString(display, x_legendText + 110, y_legend);
                g2d.setColor(this.getColor(chartItems[i2].getColor()));
                legendRect.setLocation(x_legendBar, y_legend - textHeight / 2);
                g2d.fill(legendRect);
                ++curElement;
            }
            ++i2;
        }
        ServletOutputStream output = response.getOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)output);
        encoder.encode(bi);
        output.close();
    }

    protected Color getColor(String colorStr) {
        Color color = null;
        if (colorStr == null) {
            color = Color.gray;
        }
        color = colorStr.equals("red") ? Color.red : (colorStr.equals("green") ? Color.green : (colorStr.equals("blue") ? Color.blue : (colorStr.equals("pink") ? Color.pink : (colorStr.equals("orange") ? Color.orange : (colorStr.equals("magenta") ? Color.magenta : (colorStr.equals("cyan") ? Color.cyan : (colorStr.equals("white") ? Color.white : (colorStr.equals("yellow") ? Color.yellow : (colorStr.equals("gray") ? Color.gray : (colorStr.equals("darkGray") ? Color.darkGray : Color.gray))))))))));
        return color;
    }
}

