/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.xa;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.sql.XADataSource;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.xa.XAManagedConnectionFactory;

public class HAXAManagedConnectionFactory
extends XAManagedConnectionFactory {
    private String urlProperty;
    private String urlDelimeter;
    private XADataSelector xadsSelector;
    static /* synthetic */ Class class$java$lang$String;

    public String getURLProperty() {
        return this.urlProperty;
    }

    public void setURLProperty(String urlProperty) throws ResourceException {
        this.urlProperty = urlProperty;
        this.initSelector();
    }

    public String getURLDelimeter() {
        return this.urlDelimeter;
    }

    public void setURLDelimeter(String urlDelimeter) throws ResourceException {
        this.urlDelimeter = urlDelimeter;
        this.initSelector();
    }

    public void setXADataSourceProperties(String xaDataSourceProperties) throws ResourceException {
        super.setXADataSourceProperties(xaDataSourceProperties);
        this.initSelector();
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.xadsSelector == null) {
            throw new JBossResourceException("Datasource selector is not initialized!");
        }
        for (int i = 0; i < this.xadsSelector.getXADataSourceList().size(); ++i) {
            XAData xaData = this.xadsSelector.getXAData();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Trying to create an XA connection to " + xaData.url));
            }
            try {
                return super.createManagedConnection(subject, cri);
            }
            catch (ResourceException e) {
                this.log.warn((Object)("Failed to create an XA connection to " + xaData.url + ": " + e.getMessage()));
                this.xadsSelector.failedXAData(xaData);
                continue;
            }
        }
        throw new JBossResourceException("Could not create connection using any of the URLs: " + this.xadsSelector.getXADataSourceList());
    }

    protected synchronized XADataSource getXADataSource() throws ResourceException {
        return this.xadsSelector.getXAData().xads;
    }

    private XADataSource createXaDataSource(Properties xaProps) throws JBossResourceException {
        XADataSource xads;
        if (this.getXADataSourceClass() == null) {
            throw new JBossResourceException("No XADataSourceClass supplied!");
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.getXADataSourceClass());
            xads = (XADataSource)clazz.newInstance();
            Class[] NOCLASSES = new Class[]{};
            Iterator<Object> i = xaProps.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = xaProps.getProperty(name);
                Class<?> type = null;
                try {
                    Method getter = clazz.getMethod("get" + name, NOCLASSES);
                    type = getter.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    type = class$java$lang$String == null ? HAXAManagedConnectionFactory.class$("java.lang.String") : class$java$lang$String;
                }
                Method setter = clazz.getMethod("set" + name, type);
                PropertyEditor editor = PropertyEditorManager.findEditor(type);
                if (editor == null) {
                    throw new JBossResourceException("No property editor found for type: " + type);
                }
                editor.setAsText(value);
                setter.invoke((Object)xads, editor.getValue());
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new JBossResourceException("Class not found for XADataSource " + this.getXADataSourceClass(), (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new JBossResourceException("Could not create an XADataSource: ", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new JBossResourceException("Could not set a property: ", (Throwable)iae);
        }
        catch (IllegalArgumentException iae) {
            throw new JBossResourceException("Could not set a property: ", (Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new JBossResourceException("Could not invoke setter on XADataSource: ", (Throwable)ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new JBossResourceException("Could not find accessor on XADataSource: ", (Throwable)nsme);
        }
        return xads;
    }

    private void initSelector() throws JBossResourceException {
        String urlsStr;
        if (this.urlProperty != null && this.urlProperty.length() > 0 && (urlsStr = this.xaProps.getProperty(this.urlProperty)) != null && urlsStr.trim().length() > 0 && this.urlDelimeter != null && this.urlDelimeter.trim().length() > 0) {
            XADataSource xads;
            String url;
            ArrayList<XAData> xaDataList = new ArrayList<XAData>();
            Properties xaPropsCopy = new Properties();
            Iterator<Object> i = this.xaProps.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                xaPropsCopy.put(key, this.xaProps.get(key));
            }
            int urlStart = 0;
            int urlEnd = urlsStr.indexOf(this.urlDelimeter);
            while (urlEnd > 0) {
                url = urlsStr.substring(urlStart, urlEnd);
                xaPropsCopy.setProperty(this.urlProperty, url);
                xads = this.createXaDataSource(xaPropsCopy);
                xaDataList.add(new XAData(xads, url));
                urlStart = ++urlEnd;
                urlEnd = urlsStr.indexOf(this.urlDelimeter, urlEnd);
                this.log.debug((Object)("added XA HA connection url: " + url));
            }
            if (urlStart != urlsStr.length()) {
                url = urlsStr.substring(urlStart, urlsStr.length());
                xaPropsCopy.setProperty(this.urlProperty, url);
                xads = this.createXaDataSource(xaPropsCopy);
                xaDataList.add(new XAData(xads, url));
                this.log.debug((Object)("added XA HA connection url: " + url));
            }
            this.xadsSelector = new XADataSelector(xaDataList);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class XAData {
        public final XADataSource xads;
        public final String url;

        public XAData(XADataSource xads, String url) {
            this.xads = xads;
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof XAData)) {
                return false;
            }
            XAData xaData = (XAData)o;
            return this.url.equals(xaData.url);
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public String toString() {
            return "[XA URL=" + this.url + "]";
        }
    }

    public static class XADataSelector {
        private final List xaDataList;
        private int xaDataIndex;
        private XAData xaData;

        public XADataSelector(List xaDataList) {
            if (xaDataList == null || xaDataList.size() == 0) {
                throw new IllegalStateException("Expected non-empty list of XADataSource/URL pairs but got: " + xaDataList);
            }
            this.xaDataList = xaDataList;
        }

        public synchronized XAData getXAData() {
            if (this.xaData == null) {
                if (this.xaDataIndex == this.xaDataList.size()) {
                    this.xaDataIndex = 0;
                }
                this.xaData = (XAData)this.xaDataList.get(this.xaDataIndex++);
            }
            return this.xaData;
        }

        public synchronized void failedXAData(XAData xads) {
            if (xads.equals(this.xaData)) {
                this.xaData = null;
            }
        }

        public List getXADataSourceList() {
            return this.xaDataList;
        }
    }
}

