/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.util.NestedRuntimeException;
import org.jboss.xml.binding.ContentNavigator;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.jboss.xml.binding.JBossXBRuntimeException;
import org.jboss.xml.binding.TypeBinding;
import org.jboss.xml.binding.TypeConverter;
import org.jboss.xml.binding.Util;
import org.xml.sax.Attributes;

public class MappingObjectModelFactory
implements GenericObjectModelFactory {
    private static final Logger log = Logger.getLogger(MappingObjectModelFactory.class);
    private final Map elementToClassMapping = new HashMap();
    private final Map elementToFieldMapping = new HashMap();

    public void mapElementToClass(String element, Class cls) {
        ElementToClassMapping mapping = new ElementToClassMapping(element, cls);
        this.addElementToClassMapping(mapping);
        if (log.isTraceEnabled()) {
            log.trace(mapping);
        }
    }

    public void mapElementToField(String element, Class cls, String field, TypeConverter converter) {
        ElementToFieldMapping mapping = new ElementToFieldMapping(element, cls, field, converter);
        this.addElementToFieldMapping(mapping);
        if (log.isTraceEnabled()) {
            log.trace(mapping);
        }
    }

    public Object newRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        if (log.isTraceEnabled()) {
            log.trace("newRoot root=" + root + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs);
        }
        if (root == null) {
            ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
            if (mapping != null) {
                if (log.isTraceEnabled()) {
                    log.trace("creating root using " + mapping);
                }
                root = MappingObjectModelFactory.newInstance(mapping.cls);
            } else {
                root = MappingObjectModelFactory.create(namespaceURI, localName, navigator.getType());
            }
            if (root == null) {
                throw new IllegalStateException("Failed to resolve Java type binding for root element: ns=" + namespaceURI + ", local=" + localName);
            }
        }
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                try {
                    if (attrs.getLocalName(i).length() <= 0 || attrs.getQName(i).startsWith("xsi:")) continue;
                    this.setAttribute(root, attrs.getLocalName(i), attrs.getValue(i), navigator.getType());
                    continue;
                }
                catch (Exception e) {
                    String msg = "Failed to set attribute " + attrs.getQName(i) + "=" + attrs.getValue(i);
                    log.error(msg, e);
                    throw new IllegalStateException(msg + ": " + e.getMessage());
                }
            }
        }
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newChild(Object o, ContentNavigator navigator, String namespaceURI, String localName, Attributes attrs) {
        Method getter;
        if (log.isTraceEnabled()) {
            log.trace("newChild object=" + o + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName + " attributes=" + attrs);
        }
        if (o == null) {
            throw new RuntimeException("Attempt to add a new child to a null parent localName=" + localName);
        }
        Object child = null;
        ElementToClassMapping mapping = (ElementToClassMapping)this.elementToClassMapping.get(localName);
        XSTypeDefinition type = navigator.getType();
        if (mapping != null) {
            if (log.isTraceEnabled()) {
                log.trace("newChild using mapping " + mapping);
            }
            try {
                if (!(o instanceof Collection)) {
                    Method getter2;
                    ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
                    if (fieldMapping != null) {
                        getter2 = fieldMapping.getter;
                    } else {
                        String getterStr = Util.xmlNameToGetMethodName(localName, true);
                        getter2 = o.getClass().getMethod(getterStr, null);
                    }
                    child = MappingObjectModelFactory.get(o, localName, getter2);
                }
                if (child == null) {
                    child = MappingObjectModelFactory.newInstance(mapping.cls);
                }
                if (attrs == null) return child;
                int i = 0;
                while (i < attrs.getLength()) {
                    if (attrs.getLocalName(i).length() > 0 && !attrs.getQName(i).startsWith("xsi:")) {
                        this.setAttribute(child, attrs.getLocalName(i), attrs.getValue(i), type);
                    }
                    ++i;
                }
                return child;
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NestedRuntimeException("newChild failed for o=" + o + ", uri=" + namespaceURI + ", local=" + localName + ", attrs=" + attrs, e);
            }
        }
        if (o instanceof Collection) {
            return MappingObjectModelFactory.create(namespaceURI, localName, type);
        }
        Class oCls = o instanceof ImmutableContainer ? ((ImmutableContainer)o).cls : o.getClass();
        String getterStr = Util.xmlNameToGetMethodName(localName, true);
        try {
            getter = oCls.getMethod(getterStr, null);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("newChild failed for o=" + o + ", uri=" + namespaceURI + ", local=" + localName + ", attrs=" + attrs + ": no getter");
        }
        Class<?> childType = getter.getReturnType();
        if (Collection.class.isAssignableFrom(childType)) {
            child = MappingObjectModelFactory.get(o, localName, getter);
            Object item = null;
            if (type == null || type != null && type.getTypeCategory() == 15) {
                item = MappingObjectModelFactory.create(namespaceURI, localName, type);
            }
            if (item != null) {
                if (child != null) return item;
                this.setChild(new ArrayList(), o, localName);
                return item;
            }
            if (child != null) return child;
            return new ArrayList();
        }
        if (Util.isAttributeType(childType)) return child;
        ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
        TypeConverter converter = fieldMapping == null ? null : fieldMapping.converter;
        if (converter != null) return child;
        return MappingObjectModelFactory.newInstance(childType);
    }

    public void addChild(Object parent, Object child, ContentNavigator navigator, String namespaceURI, String localName) {
        if (log.isTraceEnabled()) {
            log.trace("addChild parent=" + parent + " child=" + child + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName);
        }
        if (child instanceof ImmutableContainer) {
            child = ((ImmutableContainer)child).newInstance();
        }
        this.setChild(child, parent, localName);
    }

    public void setValue(Object o, ContentNavigator navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace("setValue object=" + o + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName + " value=" + value);
        }
        this.setAttribute(o, localName, value, navigator.getType());
    }

    public Object completedRoot(Object root, ContentNavigator navigator, String namespaceURI, String localName) {
        if (log.isTraceEnabled()) {
            log.trace("completedRoot root=" + root + " navigator=" + navigator + " namespaceURI=" + namespaceURI + " localName=" + localName);
        }
        if (root instanceof ImmutableContainer) {
            root = ((ImmutableContainer)root).newInstance();
        }
        return root;
    }

    private void addElementToClassMapping(ElementToClassMapping mapping) {
        this.elementToClassMapping.put(mapping.element, mapping);
    }

    private void addElementToFieldMapping(ElementToFieldMapping mapping) {
        this.elementToFieldMapping.put(mapping.key, mapping);
    }

    private void setChild(Object child, Object parent, String localName) {
        boolean trace = log.isTraceEnabled();
        Object value = child;
        if (parent instanceof Collection) {
            if (trace) {
                log.trace("Add " + value + " to collection " + parent);
            }
            ((Collection)parent).add(value);
        } else {
            Method setter = null;
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, parent.getClass()));
            if (fieldMapping != null) {
                if (trace) {
                    log.trace("Add " + value + " to " + parent + " using field mapping " + fieldMapping);
                }
                setter = fieldMapping.setter;
                MappingObjectModelFactory.set(parent, value, localName, setter);
            } else {
                String xmlToCls = Util.xmlNameToClassName(localName, true);
                if (trace) {
                    log.trace("Add " + value + " to xml mapped class " + xmlToCls);
                }
                Method getter = null;
                Class parentCls = parent instanceof ImmutableContainer ? ((ImmutableContainer)parent).cls : parent.getClass();
                try {
                    getter = parentCls.getMethod("get" + xmlToCls, null);
                }
                catch (NoSuchMethodException e) {
                    log.warn("no getter found for " + localName + " in " + parent);
                }
                if (getter != null) {
                    if (!(child instanceof Collection) && Collection.class.isAssignableFrom(getter.getReturnType())) {
                        Object o = MappingObjectModelFactory.get(parent, localName, getter);
                        Collection col = (Collection)o;
                        if (trace) {
                            log.trace("Add " + value + " to collection " + col + " retrieved from getter " + getter);
                        }
                        col.add(child);
                    } else {
                        try {
                            setter = parentCls.getMethod("set" + xmlToCls, getter.getReturnType());
                        }
                        catch (NoSuchMethodException e) {
                            log.warn("No setter for " + localName + " in " + parentCls);
                        }
                        MappingObjectModelFactory.set(parent, value, localName, setter);
                    }
                }
            }
        }
    }

    private void setAttribute(Object o, String localName, String value, XSTypeDefinition type) {
        if (o instanceof Collection) {
            if (type == null) {
                log.warn("Type is not available for collection item " + localName + "=" + value + " -> adding as string.");
                ((Collection)o).add(value);
            } else {
                if (type.getName() == null) {
                    throw new IllegalStateException("Name is null for simple type?!");
                }
                Object trgValue = TypeBinding.unmarshal(type.getName(), value);
                ((Collection)o).add(trgValue);
            }
        } else {
            Method setter = null;
            Object fieldValue = null;
            ElementToFieldMapping fieldMapping = (ElementToFieldMapping)this.elementToFieldMapping.get(new ElementToFieldMappingKey(localName, o.getClass()));
            if (fieldMapping != null) {
                fieldValue = fieldMapping.converter.unmarshal(value);
                setter = fieldMapping.setter;
            } else {
                Class oCls = o instanceof ImmutableContainer ? ((ImmutableContainer)o).cls : o.getClass();
                try {
                    String xmlToCls = Util.xmlNameToClassName(localName, true);
                    Method getter = oCls.getMethod("get" + xmlToCls, null);
                    fieldValue = TypeBinding.unmarshal(value, getter.getReturnType());
                    setter = oCls.getMethod("set" + xmlToCls, getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    log.warn("no setter found for " + localName + " in " + oCls);
                }
            }
            MappingObjectModelFactory.set(o, fieldValue, localName, setter);
        }
    }

    private static Object create(String namespaceURI, String localName, XSTypeDefinition type) {
        Class<?> cls;
        Object o;
        block3: {
            o = null;
            String clsName = type != null && type.getName() != null ? Util.xmlNameToClassName(namespaceURI, type.getName(), true) : Util.xmlNameToClassName(namespaceURI, localName, true);
            cls = null;
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
            }
            catch (ClassNotFoundException e) {
                if (!log.isTraceEnabled()) break block3;
                log.trace("create: failed to load class " + clsName);
            }
        }
        if (cls != null) {
            o = MappingObjectModelFactory.newInstance(cls);
        }
        return o;
    }

    private static Object get(Object o, String localName, Method getter) {
        Object value;
        if (log.isTraceEnabled()) {
            log.trace("get object=" + o + " localName=" + localName + " getter=" + getter);
        }
        if (o instanceof ImmutableContainer) {
            ImmutableContainer con = (ImmutableContainer)o;
            value = con.getChild(localName);
        } else {
            try {
                value = getter.invoke(o, null);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Failed to invoke " + getter + " on " + o, e);
            }
        }
        return value;
    }

    private static void set(Object parent, Object child, String localName, Method setter) {
        if (log.isTraceEnabled()) {
            log.trace("set parent=" + parent + " child=" + child + " localName=" + localName + " setter=" + setter);
        }
        if (setter != null) {
            try {
                setter.invoke(parent, child);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("Failed to set attribute value " + child + " with setter " + setter + " on " + parent + ": ", e);
            }
        } else if (parent instanceof ImmutableContainer) {
            ((ImmutableContainer)parent).addChild(localName, child);
        } else {
            throw new IllegalStateException("setter is null and it's not an immutable container: parent=" + parent.getClass() + ", localName" + localName + ", parent=" + parent + ", child=" + child);
        }
    }

    private static Object newInstance(Class cls) {
        Object instance;
        if (log.isTraceEnabled()) {
            log.trace("new " + cls.getName());
        }
        try {
            Constructor ctor = cls.getConstructor(null);
            instance = ctor.newInstance(null);
        }
        catch (NoSuchMethodException e) {
            log.warn("No no-arg constructor in " + cls);
            instance = new ImmutableContainer(cls);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create an instance of " + cls + " with the no-arg constructor: " + e.getMessage());
        }
        return instance;
    }

    private static class ImmutableContainer {
        private final Class cls;
        private final List names = new ArrayList();
        private final List values = new ArrayList();

        public ImmutableContainer(Class cls) {
            this.cls = cls;
            if (log.isTraceEnabled()) {
                log.trace("created immutable container for " + cls);
            }
        }

        public void addChild(String localName, Object child) {
            if (!this.names.isEmpty() && this.names.get(this.names.size() - 1).equals(localName)) {
                throw new IllegalStateException("Attempt to add duplicate element " + localName);
            }
            this.names.add(localName);
            this.values.add(child);
            if (log.isTraceEnabled()) {
                log.trace("added child " + localName + " for " + this.cls + ": " + child);
            }
        }

        public Object getChild(String localName) {
            return this.names.get(this.names.size() - 1).equals(localName) ? this.values.get(this.values.size() - 1) : null;
        }

        public Object[] getValues() {
            return this.values.toArray();
        }

        public Class[] getValueTypes() {
            Class[] types = new Class[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                types[i] = this.values.get(i).getClass();
            }
            return types;
        }

        public Object newInstance() {
            Constructor<?> ctor = null;
            Constructor<?>[] ctors = this.cls.getConstructors();
            if (ctors == null || ctors.length == 0) {
                throw new JBossXBRuntimeException("The class has no declared constructors: " + this.cls);
            }
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] types = ctors[i].getParameterTypes();
                if (types == null || types.length == 0) {
                    throw new IllegalStateException("Found no-arg constructor for immutable " + this.cls);
                }
                if (types.length != this.values.size()) continue;
                ctor = ctors[i];
                int typeInd = 0;
                while (typeInd < types.length) {
                    if (types[typeInd].isAssignableFrom(this.values.get(typeInd++).getClass())) continue;
                    ctor = null;
                    break;
                }
                if (ctor != null) break;
            }
            if (ctor == null) {
                throw new IllegalStateException("No constructor in " + this.cls + " that would take arguments " + this.values);
            }
            try {
                return ctor.newInstance(this.values.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create immutable instance of " + this.cls + " using arguments: " + this.values + ": " + e.getMessage());
            }
        }
    }

    private class ElementToFieldMapping {
        public final String element;
        public final Class cls;
        public final String field;
        public final TypeConverter converter;
        public final ElementToFieldMappingKey key;
        public final Method getter;
        public final Method setter;

        public ElementToFieldMapping(String element, Class cls, String field, TypeConverter converter) {
            this.element = element;
            this.cls = cls;
            this.field = field;
            this.converter = converter;
            this.key = new ElementToFieldMappingKey(element, cls);
            try {
                this.getter = Classes.getAttributeGetter(cls, field);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Getter not found for " + field + " in class " + cls.getName());
            }
            try {
                this.setter = Classes.getAttributeSetter(cls, field, this.getter.getReturnType());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Setter not found for " + field + " in class " + cls.getName());
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ElementToField@").append(System.identityHashCode(this));
            buffer.append("{element=").append(this.element);
            if (this.cls != null) {
                buffer.append(" class=").append(this.cls.getName());
            }
            buffer.append(" field=").append(this.field);
            buffer.append(" getter=").append(this.getter);
            buffer.append(" setter=").append(this.setter);
            if (this.converter != null) {
                buffer.append(" convertor=").append(this.converter.getClass().getName());
            }
            buffer.append("}");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToFieldMapping)) {
                return false;
            }
            ElementToFieldMapping elementToFieldMapping = (ElementToFieldMapping)o;
            if (this.cls != null ? !this.cls.equals(elementToFieldMapping.cls) : elementToFieldMapping.cls != null) {
                return false;
            }
            if (this.element != null ? !this.element.equals(elementToFieldMapping.element) : elementToFieldMapping.element != null) {
                return false;
            }
            return !(this.field != null ? !this.field.equals(elementToFieldMapping.field) : elementToFieldMapping.field != null);
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
            result = 29 * result + (this.field != null ? this.field.hashCode() : 0);
            return result;
        }
    }

    private class ElementToFieldMappingKey {
        public final String element;
        public final Class cls;

        public ElementToFieldMappingKey(String element, Class cls) {
            this.element = element;
            this.cls = cls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToFieldMappingKey)) {
                return false;
            }
            ElementToFieldMappingKey elementToFieldMappingKey = (ElementToFieldMappingKey)o;
            if (this.cls != null ? !this.cls.equals(elementToFieldMappingKey.cls) : elementToFieldMappingKey.cls != null) {
                return false;
            }
            return !(this.element != null ? !this.element.equals(elementToFieldMappingKey.element) : elementToFieldMappingKey.element != null);
        }

        public int hashCode() {
            int result = this.element != null ? this.element.hashCode() : 0;
            result = 29 * result + (this.cls != null ? this.cls.hashCode() : 0);
            return result;
        }
    }

    private class ElementToClassMapping {
        public final String element;
        public final Class cls;

        public ElementToClassMapping(String element, Class cls) {
            this.element = element;
            this.cls = cls;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ElementToClass@").append(System.identityHashCode(this));
            buffer.append("{element=").append(this.element);
            if (this.cls != null) {
                buffer.append(" class=").append(this.cls.getName());
            }
            buffer.append("}");
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementToClassMapping)) {
                return false;
            }
            ElementToClassMapping classMapping = (ElementToClassMapping)o;
            return !(this.cls != null ? !this.cls.equals(classMapping.cls) : classMapping.cls != null);
        }

        public int hashCode() {
            return this.cls != null ? this.cls.hashCode() : 0;
        }
    }
}

