/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class TCPPING
extends Protocol {
    Vector members = new Vector();
    Vector initial_members = new Vector();
    Set members_set = new HashSet();
    Address local_addr = null;
    String group_addr = null;
    String groupname = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    int port_range = 1;
    ArrayList initial_hosts = null;
    boolean is_server = false;

    public String getName() {
        return "TCPPING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = Integer.parseInt(str);
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        if (props.size() > 0) {
            System.err.println("TCPPING.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("got TCPPING header with unknown type (" + hdr.type + ')'));
                }
                return;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                if (this.initial_hosts == null || this.local_addr == null || this.initial_hosts.contains(this.local_addr)) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[SET_LOCAL_ADDRESS]: adding my own address (" + this.local_addr + ") to initial_hosts; initial_hosts=" + this.initial_hosts));
                }
                this.initial_hosts.add(this.local_addr);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                this.initial_members.removeAllElements();
                Message msg = new Message(null, null, null);
                msg.putHeader(this.getName(), new PingHeader(1, null));
                Vector vector = this.members;
                synchronized (vector) {
                    Iterator it = this.initial_hosts.iterator();
                    while (it.hasNext()) {
                        Address addr = (Address)it.next();
                        if (this.members.contains(addr)) continue;
                        msg.setDest(addr);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
                        }
                        this.passDown(new Event(1, msg.copy()));
                    }
                }
                vector = this.initial_members;
                synchronized (vector) {
                    long start_time = System.currentTimeMillis();
                    for (long time_to_wait = this.timeout; (long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L; time_to_wait -= System.currentTimeMillis() - start_time) {
                        try {
                            this.initial_members.wait(time_to_wait);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("[FIND_INITIAL_MBRS] initial members are " + this.initial_members));
                }
                this.passUp(new Event(13, this.initial_members));
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.clear();
                        this.members.addAll(tmp);
                        this.members_set.clear();
                        this.members_set.addAll(tmp);
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 4: {
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private ArrayList createInitialHosts(String l) {
        StringTokenizer tok = new StringTokenizer(l, ",");
        ArrayList<IpAddress> retval = new ArrayList<IpAddress>();
        while (tok.hasMoreTokens()) {
            try {
                int port;
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                for (int i = port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93))); i < port + this.port_range; ++i) {
                    IpAddress addr = new IpAddress(host, i);
                    retval.add(addr);
                }
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exeption is " + e));
            }
        }
        return retval;
    }
}

