/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolObserver;

public class ENCRYPT1_4KeystoreTest
extends TestCase {
    public void testInitWrongKeystoreProperties() {
        Properties props = new Properties();
        String defaultKeystore = "unkownKeystore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            ENCRYPT1_4KeystoreTest.assertEquals((String)("Unable to load keystore " + defaultKeystore + " ensure file is on classpath"), (String)e.getMessage());
        }
    }

    public void testInitKeystoreProperties() {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        ENCRYPT1_4KeystoreTest.assertNotNull((Object)encrypt.getSymDecodingCipher());
        ENCRYPT1_4KeystoreTest.assertNotNull((Object)encrypt.getSymEncodingCipher());
    }

    public void testMessageDownEncode() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        Properties props2 = new Properties();
        props2.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt2 = new ENCRYPT();
        encrypt2.setProperties(props2);
        try {
            encrypt2.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        String messageText = "hello this is a test message";
        Message msg = new Message(null, null, messageText.getBytes());
        Event event = new Event(1, msg);
        encrypt.down(event);
        Message sentMsg = (Message)((Event)observer.getDownMessages().get("message0")).getArg();
        String encText = new String(sentMsg.getBuffer());
        ENCRYPT1_4KeystoreTest.assertNotSame((Object)encText, (Object)messageText);
        Cipher cipher = encrypt2.getSymDecodingCipher();
        byte[] decodedBytes = cipher.doFinal(sentMsg.getBuffer());
        String temp = new String(decodedBytes);
        System.out.println("decoded text:" + temp);
        ENCRYPT1_4KeystoreTest.assertEquals((String)temp, (String)messageText);
    }

    public void testMessageUpDecode() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        Properties props2 = new Properties();
        props2.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt2 = new ENCRYPT();
        encrypt2.setProperties(props2);
        try {
            encrypt2.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        String messageText = "hello this is a test message";
        Cipher cipher = encrypt2.getSymEncodingCipher();
        byte[] encodedBytes = cipher.doFinal(messageText.getBytes());
        ENCRYPT1_4KeystoreTest.assertNotSame((Object)new String(encodedBytes), (Object)messageText);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(encrypt.getDesKey().getEncoded());
        String symVersion = new String(digest.digest());
        Message msg = new Message(null, null, encodedBytes);
        msg.putHeader("encrypt", new ENCRYPT.EncryptHeader(0, symVersion));
        Event event = new Event(1, msg);
        encrypt.up(event);
        Message rcvdMsg = (Message)((Event)observer.getUpMessages().get("message0")).getArg();
        String decText = new String(rcvdMsg.getBuffer());
        ENCRYPT1_4KeystoreTest.assertEquals((String)decText, (String)messageText);
    }

    public void testMessageUpNoEncryptHeader() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        Properties props2 = new Properties();
        props2.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt2 = new ENCRYPT();
        encrypt2.setProperties(props2);
        try {
            encrypt2.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        String messageText = "hello this is a test message";
        Cipher cipher = encrypt2.getSymEncodingCipher();
        byte[] encodedBytes = cipher.doFinal(messageText.getBytes());
        ENCRYPT1_4KeystoreTest.assertNotSame((Object)new String(encodedBytes), (Object)messageText);
        Message msg = new Message(null, null, encodedBytes);
        Event event = new Event(1, msg);
        encrypt.up(event);
        ENCRYPT1_4KeystoreTest.assertEquals((int)observer.getUpMessages().size(), (int)0);
    }

    public void testEventUpNoMessage() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        Event event = new Event(1, null);
        encrypt.up(event);
        ENCRYPT1_4KeystoreTest.assertEquals((int)observer.getUpMessages().size(), (int)1);
    }

    public void testMessageUpNoBuffer() throws Exception {
        Properties props = new Properties();
        String defaultKeystore = "defaultStore.keystore";
        props.put("key_store_name", defaultKeystore);
        ENCRYPT encrypt = new ENCRYPT();
        encrypt.setProperties(props);
        try {
            encrypt.init();
        }
        catch (Exception e) {
            ENCRYPT1_4KeystoreTest.fail((String)e.getMessage());
        }
        MockObserver observer = new MockObserver();
        encrypt.setObserver(observer);
        encrypt.keyServer = true;
        Message msg = new Message(null, null, null);
        Event event = new Event(1, msg);
        encrypt.up(event);
        ENCRYPT1_4KeystoreTest.assertEquals((int)observer.getUpMessages().size(), (int)1);
    }

    class MockAddress
    implements Address {
        MockAddress() {
        }

        public boolean isMulticastAddress() {
            return false;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int compareTo(Object o) {
            return -1;
        }
    }

    class MockObserver
    implements ProtocolObserver {
        private Map upMessages = new HashMap();
        private Map downMessages = new HashMap();
        private int counter = 0;

        MockObserver() {
        }

        private void storeUp(Event evt) {
            this.upMessages.put("message" + this.counter++, evt);
        }

        private void storeDown(Event evt) {
            this.downMessages.put("message" + this.counter++, evt);
        }

        public void up(Event evt) {
            this.storeUp(evt);
            System.out.println("Up:" + evt.toString());
        }

        public void setProtocol(Protocol prot) {
        }

        public boolean up(Event evt, int num_evts) {
            System.out.println("Up:" + evt.toString());
            return false;
        }

        public boolean passUp(Event evt) {
            this.storeUp(evt);
            System.out.println("PassUp:" + evt.toString());
            return false;
        }

        public boolean down(Event evt, int num_evts) {
            System.out.println("down:" + evt.toString());
            return false;
        }

        public boolean passDown(Event evt) {
            this.storeDown(evt);
            System.out.println("passdown:" + evt.toString());
            return false;
        }

        protected Map getUpMessages() {
            return this.upMessages;
        }

        protected void setUpMessages(Map upMessages) {
            this.upMessages = upMessages;
        }

        protected Map getDownMessages() {
            return this.downMessages;
        }

        protected void setDownMessages(Map downMessages) {
            this.downMessages = downMessages;
        }
    }
}

