/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.buildmagic.task.module;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.tools.buildmagic.task.MissingAttributeException;
import org.jboss.tools.buildmagic.task.MissingElementException;
import org.jboss.tools.buildmagic.task.util.ConditionalExecution;
import org.jboss.tools.buildmagic.task.util.TaskLogger;

public class ModuleConfig
extends Task {
    protected TaskLogger log = new TaskLogger(this);
    protected List modules = new LinkedList();
    protected List groups = new LinkedList();
    protected String property = "modules";
    protected String selected;
    protected ConditionalExecution cond = new ConditionalExecution(this);

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSelected(String selected) {
        this.selected = selected;
    }

    public Module createModule() {
        Module m = new Module(this);
        this.modules.add(m);
        return m;
    }

    public Group createGroup() {
        Group g = new Group(this);
        this.groups.add(g);
        return g;
    }

    public ConditionalExecution.Condition createCondition() {
        return this.cond.createCondition();
    }

    public void execute() throws BuildException {
        if (this.selected == null) {
            throw new MissingAttributeException("name", this);
        }
        if (this.modules.size() == 0) {
            throw new MissingElementException("module", this);
        }
        if (this.groups.size() == 0) {
            throw new MissingElementException("group", this);
        }
        if (!this.cond.canExecute()) {
            return;
        }
        LinkedList list = new LinkedList();
        StringTokenizer stok = new StringTokenizer(this.selected, ",");
        while (stok.hasMoreTokens()) {
            String name = stok.nextToken().trim();
            this.log.verbose("selected group: " + name);
            Group group = this.getGroup(name);
            if (group == null) {
                throw new BuildException("Invalid module group: " + this.selected);
            }
            this.log.debug("group: " + group);
            List allModules = group.getModules();
            if (allModules == null) {
                throw new BuildException("Invalid group: " + name);
            }
            list.addAll(allModules);
        }
        this.log.debug("full module list: " + list);
        String value = this.generatePropertyValue(list);
        this.project.setProperty(this.property, value);
        this.log.verbose("Module list: " + value);
    }

    protected String generatePropertyValue(List list) {
        StringBuffer buff = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Module mod = (Module)iter.next();
            if (mod == null) {
                throw new BuildException("Null module in list: " + list);
            }
            buff.append(mod.getName());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    protected NamedElement getNamedElement(List list, String name) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            NamedElement elem = (NamedElement)iter.next();
            if (!elem.getName().equals(name)) continue;
            return elem;
        }
        return null;
    }

    protected Module getModule(String name) {
        return (Module)this.getNamedElement(this.modules, name);
    }

    protected Group getGroup(String name) {
        return (Group)this.getNamedElement(this.groups, name);
    }

    protected class Group
    extends NamedElement {
        protected List includes = new LinkedList();
        protected ConditionalExecution cond;

        public Group(Task parent) {
            super(parent);
            this.cond = new ConditionalExecution(parent);
        }

        public ConditionalExecution.Condition createCondition() {
            return this.cond.createCondition();
        }

        public Include createInclude() {
            Include inc = new Include(this);
            this.includes.add(inc);
            return inc;
        }

        public void setModules(String modules) {
            Include inc = new Include(this);
            inc.setModules(modules);
            this.includes.add(inc);
        }

        public void setGroups(String groups) {
            Include inc = new Include(this);
            inc.setGroups(groups);
            this.includes.add(inc);
        }

        public List getModules() {
            LinkedList list = new LinkedList();
            if (!this.cond.canExecute()) {
                return list;
            }
            Iterator iter = this.includes.iterator();
            while (iter.hasNext()) {
                Include inc = (Include)iter.next();
                ModuleConfig.this.log.debug("adding modules from include: " + inc);
                list.addAll(inc.getModules());
            }
            return list;
        }

        public String toString() {
            return "{ name=" + this.name + ", includes=" + this.includes + " }";
        }

        protected class Include {
            protected ConditionalExecution cond;
            protected Group parent;
            protected String modules = "";
            protected String groups = "";

            public Include(Group parent) {
                this.parent = parent;
                this.cond = new ConditionalExecution(parent.parent);
            }

            public ConditionalExecution.Condition createCondition() {
                return this.cond.createCondition();
            }

            public void setModules(String modules) {
                this.modules = modules;
            }

            public void setGroups(String groups) {
                this.groups = groups;
            }

            public List getGroups() {
                LinkedList<Group> list = new LinkedList<Group>();
                if (!this.cond.canExecute()) {
                    return list;
                }
                StringTokenizer stok = new StringTokenizer(this.groups, ",");
                while (stok.hasMoreTokens()) {
                    String name = stok.nextToken().trim();
                    Group group = ModuleConfig.this.getGroup(name);
                    if (group == null) {
                        throw new BuildException("Invalid group include: " + name);
                    }
                    list.add(group);
                    ((Group)Group.this).ModuleConfig.this.log.debug("adding group: " + group);
                }
                return list;
            }

            public List getModules() {
                LinkedList<Module> list = new LinkedList<Module>();
                if (!this.cond.canExecute()) {
                    return list;
                }
                StringTokenizer stok = new StringTokenizer(this.modules, ",");
                while (stok.hasMoreTokens()) {
                    String name = stok.nextToken().trim();
                    Module module = ModuleConfig.this.getModule(name);
                    if (module == null) {
                        throw new BuildException("Invalid module include: " + name);
                    }
                    list.add(module);
                    ((Group)Group.this).ModuleConfig.this.log.debug("adding module: " + module);
                }
                List groups = this.getGroups();
                Iterator iter = groups.iterator();
                while (iter.hasNext()) {
                    Group group = (Group)iter.next();
                    list.addAll(group.getModules());
                }
                return list;
            }

            public String toString() {
                return "{ modules=" + this.modules + ", groups=" + this.groups + " }";
            }
        }
    }

    protected class Module
    extends NamedElement {
        protected List depends = new LinkedList();

        public Module(Task parent) {
            super(parent);
        }

        public void addDependency(String name) {
            this.depends.add(name);
        }

        public void setDepends(String depends) {
            StringTokenizer stok = new StringTokenizer(depends, ",", false);
            while (stok.hasMoreTokens()) {
                this.addDependency(stok.nextToken().trim());
            }
        }

        public String toString() {
            return "{ name=" + this.name + ", depends=" + this.depends + " }";
        }
    }

    protected abstract class NamedElement {
        protected Task parent;
        protected String name;

        protected NamedElement(Task parent) {
            this.parent = parent;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

