/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.LocalTransaction;
import org.jboss.resource.adapter.jms.JmsManagedConnection;

public class JmsLocalTransaction
implements LocalTransaction {
    protected JmsManagedConnection mc;

    public JmsLocalTransaction(JmsManagedConnection mc) {
        this.mc = mc;
    }

    public void begin() throws ResourceException {
    }

    public void commit() throws ResourceException {
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().commit();
            }
        }
        catch (JMSException ex) {
            EISSystemException re = new EISSystemException("Could not commit LocalTransaction : " + ex.getMessage());
            re.setLinkedException((Exception)((Object)ex));
            throw re;
        }
    }

    public void rollback() throws ResourceException {
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().rollback();
            }
        }
        catch (JMSException ex) {
            EISSystemException re = new EISSystemException("Could not rollback LocalTransaction : " + ex.getMessage());
            re.setLinkedException((Exception)((Object)ex));
            throw re;
        }
    }
}

