/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.io.IOException;
import java.io.InputStream;
import org.apache.batik.ext.awt.image.codec.PNGDecodeParam;
import org.apache.batik.ext.awt.image.codec.PNGRed;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class PNGRegistryEntry
extends MagicNumberRegistryEntry {
    static final byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public PNGRegistryEntry() {
        super("PNG", "png", "image/png", 0, signature);
    }

    public Filter handleStream(InputStream inIS, ParsedURL origURL, boolean needRawData) {
        Object[] errParam;
        String errCode;
        final DeferRable dr = new DeferRable();
        final InputStream is = inIS;
        final boolean raw = needRawData;
        if (origURL != null) {
            errCode = "url.format.unreadable";
            errParam = new Object[]{"PNG", origURL};
        } else {
            errCode = "stream.format.unreadable";
            errParam = new Object[]{"PNG"};
        }
        Thread t = new Thread(){

            public void run() {
                Filter filt;
                try {
                    PNGDecodeParam param = new PNGDecodeParam();
                    param.setExpandPalette(true);
                    if (raw) {
                        param.setPerformGammaCorrection(false);
                    } else {
                        param.setPerformGammaCorrection(true);
                        param.setDisplayExponent(2.2f);
                    }
                    AbstractRed cr = new PNGRed(is, param);
                    cr = new Any2sRGBRed(cr);
                    filt = new RedRable(cr);
                }
                catch (IOException ioe) {
                    filt = ImageTagRegistry.getBrokenLinkImage(this, errCode, errParam);
                }
                catch (Throwable t) {
                    filt = ImageTagRegistry.getBrokenLinkImage(this, errCode, errParam);
                }
                dr.setSource(filt);
            }
        };
        t.start();
        return dr;
    }
}

