/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.client;

import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class Main
implements Runnable {
    org.jnp.server.Main remoteServer;

    public static void main(String[] args) throws Exception {
        System.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.jnp.interfaces");
        System.setProperty("java.naming.provider.url", "localhost");
        System.setErr(System.out);
        new Main().run();
    }

    public void printName(String name) throws NamingException {
        Context ctx = (Context)new InitialContext().lookup("");
        Name n = ctx.getNameParser("").parse(name);
        System.out.println("'" + name + "'.size = " + n.size());
        for (int i = 0; i < n.size(); ++i) {
            System.out.println("  [" + i + "]" + n.get(i));
        }
    }

    public void showTree(Context ctx) throws NamingException {
        this.showTree(ctx, Integer.MAX_VALUE);
    }

    public void showTree(Context ctx, int maxDepth) throws NamingException {
        System.out.println("----------------------------");
        this.showTree("/", ctx, 0, maxDepth);
        System.out.println("----------------------------");
    }

    public void run() {
        try {
            this.printName("jnp://localhost/");
            this.printName("jnp://localhost:1099/");
            this.printName("jnp://localhost:1099/root");
            this.printName("jnp://localhost");
            this.printName("jnp:/localhost/");
            this.printName("jnp:localhost/");
            InitialContext iniCtx = new InitialContext();
            Context ctx = iniCtx;
            Context java = (Context)iniCtx.lookup("java:");
            System.out.println("java: " + java);
            Context test = ctx.createSubcontext("test");
            System.out.println("test created:" + test);
            String hello1 = "Hello1";
            System.out.println((Object)hello1);
            String hello2 = "Hello2";
            System.out.println((Object)hello2);
            ctx.bind("/test/server", (Object)hello1);
            System.out.println("test/server bound");
            test.bind("server2", (Object)hello2);
            System.out.println("test/server2 bound");
            Object server = ctx.lookup("test/server2");
            System.out.println("test/server2 lookup:" + server);
            server = ctx.lookup("jnp://localhost/test/server2");
            System.out.println("jnp://localhost/test/server2 lookup:" + server);
            test = (Context)ctx.lookup("test");
            Object server2 = test.lookup("server");
            iniCtx.rebind("test/server2", (Object)hello2);
            System.out.println("test/server2 rebound");
            this.showTree(ctx);
            test.rename("/test/server2", "server3");
            System.out.println("test/server2 renamed to test/server3");
            try {
                test.lookup("server2");
            }
            catch (NameNotFoundException e) {
                System.out.println("Server2 was not found (which is OK)");
            }
            Object server3 = test.lookup("server3");
            System.out.println("Server3:" + server3);
            this.showTree(ctx);
            ctx = (Context)iniCtx.lookup("jnp://localhost/");
            System.out.println("Looked up URL context");
            this.showTree(ctx);
            System.out.println("Looked up using URL: " + iniCtx.lookup("jnp://localhost:1099/test/server3"));
            iniCtx.bind("jnp://localhost/helloserver", (Object)hello2);
            System.out.println("Bound helloserver");
            iniCtx.rename("helloserver", "jnp://localhost/test/helloserver");
            System.out.println("Renamed helloserver to test/helloserver");
            test.bind("/helloserver2", test.lookup("helloserver"));
            System.out.println("Bound test/helloserver to /helloserver2");
            test.bind("/helloserver3", (Object)new LinkRef("/test/server3"));
            test.bind("helloserver4", (Object)new LinkRef("server3"));
            System.out.println("test/helloserver3=" + ctx.lookup("helloserver3"));
            ctx.createSubcontext("test2");
            ctx.bind("test2/helloworld", ctx.lookup("test/server3"));
            test.bind("test2link", (Object)new LinkRef("/test2"));
            System.out.println("test2/helloworld=" + ctx.lookup("test2/helloworld"));
            System.out.println("test/test2link/helloworld=" + ctx.lookup("test/test2link/helloworld"));
            System.out.println();
            System.out.println("Show root bindings");
            ctx = iniCtx;
            NamingEnumeration<Binding> namingEnumeration = ctx.listBindings("");
            while (namingEnumeration.hasMoreElements()) {
                Binding b = namingEnumeration.next();
                System.out.println(b);
            }
            this.showTree(ctx);
            StringRefAddr addr = new StringRefAddr("URL", "file:/tmp");
            Reference fsRef = new Reference("javax.naming.Context", addr);
            ctx.bind("external", (Object)fsRef);
            Context tmpfs = (Context)ctx.lookup("external");
            System.out.println("+++ tmp filesystem context:");
            this.showTree(tmpfs, 2);
            Properties env = new Properties();
            env.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.setProperty("java.naming.factory.url.pkgs", "org.jnp.interfaces");
            env.setProperty("java.naming.provider.url", "jnp://localhost/test");
            System.out.println("+++ Test jnp URL passed as PROVIDER_URL");
            ctx = new InitialContext(env);
            server = ctx.lookup("server");
            System.out.println("+ PROVIDER_URL=jnp://localhost/test lookup(server):" + server);
            env.setProperty("java.naming.provider.url", "jnp://localhost:1099/test");
            ctx = new InitialContext(env);
            server = ctx.lookup("server");
            System.out.println("+ PROVIDER_URL=jnp://localhost:1099/test lookup(server):" + server);
            env.setProperty("java.naming.provider.url", "jnp://localhost");
            ctx = new InitialContext(env);
            server = ctx.lookup("test/server");
            System.out.println("+ PROVIDER_URL=jnp://localhost lookup(test/server):" + server);
            env.setProperty("java.naming.provider.url", "jnp://localhost:1099/");
            ctx = new InitialContext(env);
            server = ctx.lookup("test/server");
            System.out.println("+ PROVIDER_URL=jnp://localhost:1099/ lookup(test/server):" + server);
            this.runRemoteServer();
            System.out.println("+++ Started second jnp server on port 10099");
            test = (Context)iniCtx.lookup("test");
            this.showTree(test);
            env = new Properties();
            env.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            env.setProperty("java.naming.factory.url.pkgs", "org.jnp.interfaces");
            ctx = (Context)new InitialContext(env).lookup("jnp://localhost:10099/");
            System.out.println(ctx.getEnvironment());
            test = ctx.createSubcontext("test2");
            System.out.println("10099 test2 created:" + test);
            System.out.println("10099 test2.env:" + test.getEnvironment());
            test.bind("external", (Object)new LinkRef("jnp://localhost:1099/test"));
            Context external = (Context)new InitialContext(env).lookup("jnp://localhost:10099/test2/external");
            System.out.println("jnp://localhost:10099/test2 = " + external);
            System.out.println("jnp://localhost:10099/test2.env = " + external.getEnvironment());
            this.remoteServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void runRemoteServer() throws Exception {
        this.remoteServer = new org.jnp.server.Main();
        this.remoteServer.setPort(10099);
        this.remoteServer.start();
    }

    private void showTree(String indent, Context ctx, int depth, int maxDepth) throws NamingException {
        if (depth == maxDepth) {
            return;
        }
        NamingEnumeration<NameClassPair> namingEnumeration = ctx.list("");
        while (namingEnumeration.hasMoreElements()) {
            NameClassPair ncp = namingEnumeration.next();
            System.out.println(indent + ncp);
            if (ncp.getClassName().indexOf("Context") == -1) continue;
            this.showTree(indent + ncp.getName() + "/", (Context)ctx.lookup(ncp.getName()), depth + 1, maxDepth);
        }
    }
}

