/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.deployment;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.services.deployment.DeploymentManager;
import org.jboss.services.deployment.DeploymentServiceMBean;
import org.jboss.services.deployment.LibraryManager;
import org.jboss.system.ListenerServiceMBeanSupport;

public class DeploymentService
extends ListenerServiceMBeanSupport
implements DeploymentServiceMBean {
    public static final String DEFAULT_TEMPLATE_DIR = "conf/templates";
    public static final String DEFAULT_UNDEPLOY_DIR = "undeploy";
    public static final String DEFAULT_DEPLOY_DIR = "deploy";
    private DeploymentManager manager;
    private String templateDir = "conf/templates";
    private String undeployDir = "undeploy";
    private String deployDir = "deploy";

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public String getUndeployDir() {
        return this.undeployDir;
    }

    public void setUndeployDir(String undeployDir) {
        this.undeployDir = undeployDir;
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public Set listModuleTemplates() {
        return this.manager.listModuleTemplates();
    }

    public List getTemplatePropertyInfo(String template) throws Exception {
        return this.manager.getTemplatePropertyInfo(template);
    }

    public String createModule(String module, String template, HashMap properties) throws Exception {
        return this.manager.createModule(module, template, properties);
    }

    public String createModule(String module, String template, String[] properties) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < properties.length; ++i) {
            StringTokenizer st = new StringTokenizer(properties[i], "=");
            String key = st.nextToken();
            String value = st.nextToken();
            if (value.indexOf(124) >= 0) {
                StringTokenizer st2 = new StringTokenizer(value, "|");
                int tokens = st2.countTokens();
                String[] array = new String[tokens];
                for (int j = 0; j < tokens; ++j) {
                    array[j] = st2.nextToken();
                }
                map.put(key, array);
                continue;
            }
            map.put(key, value);
        }
        return this.manager.createModule(module, template, map);
    }

    public boolean removeModule(String module) {
        return this.manager.removeModule(module);
    }

    public void deployModuleAsynch(String module) throws Exception {
        this.manager.moveToDeployDir(module);
    }

    public URL getDeployedURL(String module) throws Exception {
        return this.manager.getDeployedURL(module);
    }

    public void undeployModuleAsynch(String module) throws Exception {
        this.manager.moveToModuleDir(module);
    }

    public URL getUndeployedURL(String module) throws Exception {
        return this.manager.getUndeployedURL(module);
    }

    public boolean uploadLibrary(URL src, String filename) {
        return LibraryManager.getInstance().uploadLibrary(src, filename);
    }

    public void startService() throws Exception {
        this.manager = new DeploymentManager(this.templateDir, this.undeployDir, this.deployDir, this.log);
    }

    public void stopService() {
        this.manager = null;
    }
}

