/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import org.hibernate.loader.EntityAliases;
import org.hibernate.persister.entity.Loadable;

public class GeneratedEntityAliases
implements EntityAliases {
    private final String[] suffixedKeyColumns;
    private final String[] suffixedVersionColumn;
    private final String[][] suffixedPropertyColumns;
    private final String suffixedDiscriminatorColumn;
    private final String suffix;
    private final String rowIdAlias;

    public GeneratedEntityAliases(Loadable persister, String suffix) {
        this.suffix = suffix;
        this.suffixedKeyColumns = persister.getIdentifierAliases(suffix);
        GeneratedEntityAliases.intern(this.suffixedKeyColumns);
        this.suffixedPropertyColumns = this.getSuffixedPropertyAliases(persister);
        this.suffixedDiscriminatorColumn = persister.getDiscriminatorAlias(suffix);
        this.suffixedVersionColumn = persister.isVersioned() ? this.suffixedPropertyColumns[persister.getVersionProperty()] : null;
        this.rowIdAlias = "rowid_" + suffix;
    }

    public String[][] getSuffixedPropertyAliases(Loadable persister) {
        int size = persister.getPropertyNames().length;
        String[][] suffixedPropertyAliases = new String[size][];
        for (int j = 0; j < size; ++j) {
            suffixedPropertyAliases[j] = persister.getPropertyAliases(this.suffix, j);
            GeneratedEntityAliases.intern(suffixedPropertyAliases[j]);
        }
        return suffixedPropertyAliases;
    }

    public String[] getSuffixedVersionAliases() {
        return this.suffixedVersionColumn;
    }

    public String[][] getSuffixedPropertyAliases() {
        return this.suffixedPropertyColumns;
    }

    public String getSuffixedDiscriminatorAlias() {
        return this.suffixedDiscriminatorColumn;
    }

    public String[] getSuffixedKeyAliases() {
        return this.suffixedKeyColumns;
    }

    public String getRowIdAlias() {
        return this.rowIdAlias;
    }

    private static void intern(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].intern();
        }
    }
}

