/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Batcher;
import org.hibernate.transaction.CacheSynchronization;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JDBCContext
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$jdbc$JDBCContext == null ? (class$org$hibernate$jdbc$JDBCContext = JDBCContext.class$("org.hibernate.jdbc.JDBCContext")) : class$org$hibernate$jdbc$JDBCContext));
    private Context owner;
    private transient Batcher batcher;
    private transient Connection connection;
    private boolean autoClose;
    private transient boolean connect;
    private boolean isTransactionCallbackRegistered;
    private boolean isHibernateTransactionActive;
    static /* synthetic */ Class class$org$hibernate$jdbc$JDBCContext;

    public JDBCContext(Context owner, Connection connection, boolean autoClose) {
        boolean registerSynchronization;
        this.owner = owner;
        this.connection = connection;
        this.connect = connection == null;
        this.autoClose = autoClose;
        this.batcher = owner.getFactory().getSettings().getBatcherFactory().createBatcher(this);
        boolean bl = registerSynchronization = owner.isAutoCloseSessionEnabled() || owner.isFlushBeforeCompletionEnabled();
        if (registerSynchronization) {
            this.registerSynchronizationIfPossible();
        }
    }

    public SessionFactoryImplementor getFactory() {
        return this.owner.getFactory();
    }

    public Batcher getBatcher() {
        return this.batcher;
    }

    void aggressiveRelease() {
        if (this.owner.isAggressiveReleaseEnabled()) {
            this.batcher.closeConnection(this.connection);
            this.connection = null;
            this.connect = true;
        }
    }

    public boolean isConnected() {
        return this.connection != null || this.connect;
    }

    public Connection release() {
        if (this.connection == null) {
            this.connect = false;
            return null;
        }
        return this.disconnect();
    }

    public Connection connection() throws HibernateException {
        if (this.connection == null) {
            if (this.connect) {
                this.connect();
            } else {
                if (this.owner.isOpen()) {
                    throw new HibernateException("Session is currently disconnected");
                }
                throw new HibernateException("Session is closed");
            }
        }
        return this.connection;
    }

    public boolean registerCallbackIfNecessary() {
        if (this.isTransactionCallbackRegistered) {
            return false;
        }
        this.isTransactionCallbackRegistered = true;
        return true;
    }

    public boolean registerSynchronizationIfPossible() {
        if (this.isTransactionCallbackRegistered) {
            return true;
        }
        TransactionManager tm = this.owner.getFactory().getTransactionManager();
        if (tm == null) {
            return false;
        }
        try {
            javax.transaction.Transaction tx = tm.getTransaction();
            if (this.isJTATransactionInProgress(tx)) {
                tx.registerSynchronization((Synchronization)new CacheSynchronization(this.owner, this, tx, null));
                this.isTransactionCallbackRegistered = true;
                log.debug((Object)"successfully registered Synchronization");
                return true;
            }
            log.debug((Object)"no active transaction, could not register Synchronization");
            return false;
        }
        catch (Exception e) {
            throw new TransactionException("could not register synchronization with JTA TransactionManager", e);
        }
    }

    private boolean isJTATransactionInProgress(javax.transaction.Transaction tx) throws SystemException {
        return tx != null && JTAHelper.isInProgress(tx.getStatus());
    }

    public boolean isTransactionInProgress() {
        TransactionManager tm = this.owner.getFactory().getTransactionManager();
        try {
            return this.isHibernateTransactionActive || tm != null && this.isJTATransactionInProgress(tm.getTransaction());
        }
        catch (SystemException se) {
            throw new TransactionException("could not obtain JTA Transaction", (Exception)((Object)se));
        }
    }

    private void connect() throws HibernateException {
        this.connection = this.batcher.openConnection();
        this.connect = false;
        if (!this.isTransactionCallbackRegistered) {
            this.registerSynchronizationIfPossible();
        }
        if (this.owner.getFactory().getStatistics().isStatisticsEnabled()) {
            this.owner.getFactory().getStatisticsImplementor().connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection disconnect() throws HibernateException {
        try {
            if (this.connect) {
                this.connect = false;
                Connection connection = null;
                return connection;
            }
            if (this.connection == null) {
                throw new HibernateException("Already disconnected");
            }
            this.batcher.closeStatements();
            Connection c = this.connection;
            this.connection = null;
            if (this.autoClose) {
                this.batcher.closeConnection(c);
                Connection connection = null;
                return connection;
            }
            Connection connection = c;
            return connection;
        }
        finally {
            if (!this.isTransactionCallbackRegistered) {
                this.afterTransactionCompletion(false, null);
            }
        }
    }

    public void reconnect() throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Already connected");
        }
        if (!this.owner.isOpen()) {
            throw new HibernateException("Session is closed");
        }
        log.debug((Object)"reconnecting session");
        this.connect = true;
    }

    public void reconnect(Connection conn) throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Already connected");
        }
        this.connection = conn;
    }

    public Transaction beginTransaction() throws HibernateException {
        Transaction tx = this.owner.getFactory().getSettings().getTransactionFactory().beginTransaction(this, this.owner);
        this.isHibernateTransactionActive = true;
        return tx;
    }

    public void beforeTransactionCompletion(Transaction tx) {
        log.trace((Object)"before transaction completion");
        this.owner.beforeTransactionCompletion(tx);
    }

    public void afterTransactionCompletion(boolean success, Transaction tx) {
        log.trace((Object)"after transaction completion");
        if (this.getFactory().getStatistics().isStatisticsEnabled()) {
            this.getFactory().getStatisticsImplementor().endTransaction(success);
        }
        this.isTransactionCallbackRegistered = false;
        this.isHibernateTransactionActive = false;
        this.owner.afterTransactionCompletion(success, tx);
    }

    public void afterNontransactionalQuery(boolean success) {
        log.trace((Object)"after autocommit");
        try {
            boolean isAutocommit;
            boolean bl = isAutocommit = this.connection == null || this.connection.getAutoCommit();
            if (isAutocommit) {
                this.owner.afterTransactionCompletion(success, null);
            }
        }
        catch (SQLException sqle) {
            success = false;
            throw JDBCExceptionHelper.convert(this.owner.getFactory().getSQLExceptionConverter(), sqle, "could not inspect JDBC autocommit mode");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot serialize a JDBCContext while connected");
        }
        log.trace((Object)"Serializing JDBCContext");
        oos.writeObject(this.owner);
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        log.trace((Object)"Deserializing JDBCContext");
        this.owner = (Context)ois.readObject();
        ois.defaultReadObject();
        this.batcher = this.owner.getFactory().getSettings().getBatcherFactory().createBatcher(this);
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"running Session.finalize()");
        if (this.isTransactionCallbackRegistered) {
            log.warn((Object)"afterTransactionCompletion() was never called");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                log.warn((Object)"finalizing unclosed session with closed connection");
            } else {
                log.warn((Object)"unclosed connection, forgot to call close() on your session?");
                if (this.autoClose) {
                    this.connection.close();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Context
    extends TransactionFactory.Context {
        public void beforeTransactionCompletion(Transaction var1);

        public void afterTransactionCompletion(boolean var1, Transaction var2);

        public boolean isAggressiveReleaseEnabled();

        public boolean isAutoCloseSessionEnabled();
    }
}

