/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SequenceType;
import org.jacorb.idl.TemplateTypeSpec;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.UnionType;
import org.jacorb.idl.parser;

class ElementSpec
extends IdlSymbol {
    public TypeSpec t = new TypeSpec(ElementSpec.new_num());
    public Declarator d = null;
    private UnionType containingUnion;

    public ElementSpec(int num) {
        super(num);
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.t.setPackage(s);
        this.d.setPackage(s);
    }

    public void setUnion(UnionType ut) {
        this.containingUnion = ut;
        if (this.t.typeSpec() instanceof ConstrTypeSpec) {
            String tmpRef = ((ConstrTypeSpec)this.t.typeSpec()).c_type_spec.pack_name;
            if (tmpRef.endsWith("PackagePackage") || !tmpRef.startsWith("_") && tmpRef.endsWith("Package")) {
                tmpRef = tmpRef.substring(0, tmpRef.lastIndexOf("Package"));
            }
            if (ScopedName.isPseudoScope(tmpRef)) {
                ((ConstrTypeSpec)this.t.typeSpec()).c_type_spec.pack_name = ((ConstrTypeSpec)this.t.typeSpec()).c_type_spec.pack_name + "." + ut.name + "Package";
            }
        }
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        this.t.setEnclosingSymbol(s);
        this.d.setEnclosingSymbol(s);
    }

    public void parse() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("EelementSpec.parse(): element_spec is " + this.t.typeSpec().getClass().getName());
        }
        if (this.t.typeSpec() instanceof TemplateTypeSpec || this.t.typeSpec() instanceof ConstrTypeSpec) {
            this.t.parse();
            if (this.t.typeSpec() instanceof SequenceType) {
                TypeSpec ts = ((SequenceType)this.t.typeSpec()).elementTypeSpec().typeSpec();
                SequenceType seqTs = (SequenceType)this.t.typeSpec();
                while (ts instanceof SequenceType) {
                    seqTs = (SequenceType)ts;
                    ts = ((SequenceType)ts.typeSpec()).elementTypeSpec().typeSpec();
                }
                if (ScopedName.isRecursionScope(ts.typeName())) {
                    ((SequenceType)seqTs.typeSpec()).setRecursive();
                }
            }
        } else if (this.t.typeSpec() instanceof ScopedName) {
            TypeSpec ts = ((ScopedName)this.t.typeSpec()).resolvedTypeSpec();
            if (ts.typeName().equals(this.containingUnion.typeName())) {
                parser.error("Illegal recursion in union " + this.containingUnion.full_name(), this.token);
            }
            this.containingUnion.addImportedName(ts.typeName());
            if (!(ts instanceof ConstrTypeSpec) || !(((ConstrTypeSpec)ts).declaration() instanceof Interface)) {
                this.t = ts;
            }
        }
        try {
            NameTable.define(this.containingUnion.full_name() + "." + this.d.name(), "declarator");
        }
        catch (NameAlreadyDefined nad) {
            parser.error("Declarator " + this.d.name() + " already defined in union " + this.containingUnion.full_name(), this.token);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ElementSpec.parse-end(): element_spec is " + this.t.typeSpec().getClass().getName());
        }
    }

    public void print(PrintWriter ps) {
        if (this.t.typeSpec() instanceof TemplateTypeSpec || this.t.typeSpec() instanceof ConstrTypeSpec) {
            this.t.print(ps);
        }
    }
}

