/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import org.jacorb.idl.BaseType;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeSpec;

class CharType
extends BaseType
implements SwitchTypeSpec {
    private boolean wide = false;

    public CharType(int num) {
        super(num);
    }

    public Object clone() {
        CharType s = new CharType(CharType.new_num());
        if (this.wide) {
            s.setWide();
        }
        return s;
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide() {
        this.wide = true;
    }

    public String typeName() {
        return "char";
    }

    public String getIDLTypeName() {
        return this.wide ? "wchar" : "char";
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public String toString() {
        return this.typeName();
    }

    public boolean basic() {
        return true;
    }

    public int getTCKind() {
        if (this.wide) {
            return 26;
        }
        return 9;
    }

    public String holderName() {
        return "org.omg.CORBA.CharHolder";
    }

    public String printReadExpression(String strname) {
        if (this.wide) {
            return strname + ".read_wchar()";
        }
        return strname + ".read_char()";
    }

    public String printWriteStatement(String var_name, String strname) {
        if (this.wide) {
            return strname + ".write_wchar(" + var_name + ");";
        }
        return strname + ".write_char(" + var_name + ");";
    }

    public String printInsertExpression() {
        if (this.wide) {
            return "insert_wchar";
        }
        return "insert_char";
    }

    public String printExtractExpression() {
        if (this.wide) {
            return "extract_wchar";
        }
        return "extract_char";
    }

    public boolean isSwitchable() {
        return !this.wide;
    }
}

