/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats.report;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.varia.stats.StatisticalItem;
import org.jboss.varia.stats.TxReport;
import org.jboss.varia.stats.report.ReportGenerator;

public class TableReportGenerator
extends ReportGenerator {
    protected void content(String reportName, StringBuffer content) throws Exception {
        boolean select;
        StringBuffer reportsTable = new StringBuffer();
        reportsTable.append("<table><tr><th>Transaction started by</th><th>Total</th></tr>");
        HashMap tables = new HashMap();
        HashMap sqls = new HashMap();
        int txTotal = 0;
        Iterator reports = this.getReportsIterator();
        while (reports.hasNext()) {
            TxReport report = (TxReport)reports.next();
            txTotal += report.getCount();
            reportsTable.append("<tr><td>");
            boolean selected = report.getName().equals(reportName);
            if (!selected) {
                reportsTable.append("<a href='HtmlAdaptor?").append("action=invokeOpByName&name=").append(this.getServiceName()).append("&methodName=generate&").append("argType=java.lang.String&arg0=").append(report.getName()).append("'>");
            }
            reportsTable.append(report.getName());
            if (!selected) {
                reportsTable.append("</a>");
            }
            reportsTable.append("</td><td>").append(report.getCount()).append("</td></tr>");
            if (!selected && reportName != null && reportName.trim().length() != 0) continue;
            this.generateReport(report, sqls, tables);
        }
        reportsTable.append("<tr><td>");
        boolean bl = select = reportName != null && reportName.trim().length() > 0;
        if (select) {
            reportsTable.append("<a href='HtmlAdaptor?").append("action=invokeOpByName&name=").append(this.getServiceName()).append("&methodName=generate&").append("argType=java.lang.String&arg0=").append("'>");
        }
        reportsTable.append("all transactions");
        if (select) {
            reportsTable.append("</a>");
        }
        reportsTable.append("</td><td>").append(txTotal).append("</td></tr></table>");
        StringBuffer tablesBuf = new StringBuffer();
        tablesBuf.append("<table><tr><th>Table</th><th>selects</th><th>updates</th><th>inserts</th><th>deletes</th></tr>");
        int totalSelects = 0;
        int totalUpdates = 0;
        int totalInserts = 0;
        int totalDeletes = 0;
        Iterator tableIter = tables.values().iterator();
        while (tableIter.hasNext()) {
            TableStats table = (TableStats)tableIter.next();
            tablesBuf.append("<tr><td>").append(table.name).append("</td><td>").append(table.selects).append("</td><td>").append(table.updates).append("</td><td>").append(table.inserts).append("</td><td>").append(table.deletes).append("</td></tr>");
            totalSelects += table.selects;
            totalUpdates += table.updates;
            totalInserts += table.inserts;
            totalDeletes += table.deletes;
        }
        tablesBuf.append("<tr><td><font color='red'>total</font></td><td><font color='red'>").append(totalSelects).append("</font></td><td><font color='red'>").append(totalUpdates).append("</font></td><td><font color='red'>").append(totalInserts).append("</font></td><td><font color='red'>").append(totalDeletes).append("</font></td></tr>").append("</table>");
        StringBuffer itemsTable = new StringBuffer();
        itemsTable.append("<table><tr><th>SQL</th><th>Total</th></tr>");
        int totalStmt = 0;
        Iterator itemIter = sqls.values().iterator();
        while (itemIter.hasNext()) {
            SqlStats sql = (SqlStats)itemIter.next();
            itemsTable.append("<tr><td>").append(sql.sql).append("</td><td>").append(sql.total).append("</td></tr>");
            totalStmt += sql.total;
        }
        itemsTable.append("<tr><td><font color='red'>total</font></td><td><font color='red'>").append(totalStmt).append("</font></td></tr></table>");
        content.append("<table><tr valign='top'><td>").append(reportsTable).append("</td><td>").append(tablesBuf).append("</td><td>").append(itemsTable).append("</td></tr></table>");
    }

    private void generateReport(TxReport report, Map sqls, Map tables) {
        Map itemMap = (Map)report.getStats().get("SQL Statistics Per Transaction");
        if (itemMap != null) {
            Iterator items = itemMap.values().iterator();
            while (items.hasNext()) {
                StatisticalItem item = (StatisticalItem)items.next();
                String sql = item.getValue().toLowerCase();
                SqlStats sqlStats = (SqlStats)sqls.get(sql);
                if (sqlStats == null) {
                    sqlStats = new SqlStats(sql);
                    sqls.put(sql, sqlStats);
                }
                sqlStats.total += item.getCount();
                if (sql.startsWith("select ")) {
                    TableStats tableStats;
                    int fromStart = sql.indexOf("from ");
                    if (fromStart == -1) {
                        throw new IllegalStateException("FROM not found in: " + sql);
                    }
                    String table = sql.substring(fromStart + "from ".length());
                    int tableEnd = table.indexOf(32);
                    if (tableEnd != -1) {
                        table = table.substring(0, tableEnd);
                    }
                    if ((tableStats = (TableStats)tables.get(table)) == null) {
                        tableStats = new TableStats(table);
                        tables.put(table, tableStats);
                    }
                    tableStats.selects += item.getCount();
                    continue;
                }
                if (sql.startsWith("update ")) {
                    String table = sql.substring("update ".length());
                    int tableEnd = table.indexOf(32);
                    if (tableEnd == -1) {
                        throw new IllegalStateException("Could not find end of the table name: " + sql);
                    }
                    TableStats tableStats = (TableStats)tables.get(table = table.substring(0, tableEnd));
                    if (tableStats == null) {
                        tableStats = new TableStats(table);
                        tables.put(table, tableStats);
                    }
                    tableStats.updates += item.getCount();
                    continue;
                }
                if (sql.startsWith("insert into ")) {
                    String table = sql.substring("insert into ".length());
                    int tableEnd = table.indexOf(40);
                    if (tableEnd == -1) {
                        throw new IllegalStateException("Could not find end of the table name: " + sql);
                    }
                    TableStats tableStats = (TableStats)tables.get(table = table.substring(0, tableEnd).trim());
                    if (tableStats == null) {
                        tableStats = new TableStats(table);
                        tables.put(table, tableStats);
                    }
                    tableStats.inserts += item.getCount();
                    continue;
                }
                if (sql.startsWith("delete from ")) {
                    String table = sql.substring("delete from ".length());
                    int tableEnd = table.indexOf(32);
                    if (tableEnd == -1) {
                        throw new IllegalStateException("Could not find end of the table name: " + sql);
                    }
                    TableStats tableStats = (TableStats)tables.get(table = table.substring(0, tableEnd));
                    if (tableStats == null) {
                        tableStats = new TableStats(table);
                        tables.put(table, tableStats);
                    }
                    tableStats.deletes += item.getCount();
                    continue;
                }
                throw new IllegalStateException("Unrecognized sql statement: " + sql);
            }
        }
    }

    private static class TableStats {
        public final String name;
        public int selects;
        public int updates;
        public int inserts;
        public int deletes;

        public TableStats(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TableStats)) {
                return false;
            }
            TableStats tableStats = (TableStats)o;
            return this.name.equals(tableStats.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class SqlStats {
        public final String sql;
        public int total;

        public SqlStats(String sql) {
            this.sql = sql;
        }
    }
}

